/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.common;

import com.zthzinfo.common.BusinessException;
import java.util.HashMap;
import java.util.Map;

public class ResponseMapBuilder {
    public static final String KEY_RESULTCODE = "resultCode";
    public static final String KEY_RESULTMSG = "resultMsg";
    private Map<String, Object> result;

    public static ResponseMapBuilder emptyBuilder() {
        ResponseMapBuilder builder = new ResponseMapBuilder();
        return builder;
    }

    public static ResponseMapBuilder newBuilder() {
        ResponseMapBuilder builder = new ResponseMapBuilder();
        builder.result = new HashMap<String, Object>();
        return builder;
    }

    public static ResponseMapBuilder newBuilder(Map<String, Object> result) {
        ResponseMapBuilder builder = new ResponseMapBuilder();
        builder.result = result;
        return builder;
    }

    private ResponseMapBuilder() {
    }

    public Map<String, Object> getResult() {
        return this.result;
    }

    public void setResult(Map<String, Object> result) {
        this.result = result;
    }

    public ResponseMapBuilder putSuccess() {
        if (this.result == null) {
            return this;
        }
        this.put(KEY_RESULTCODE, "0");
        this.put(KEY_RESULTMSG, "");
        return this;
    }

    public ResponseMapBuilder putBusinessException(BusinessException e) {
        if (e == null) {
            return this;
        }
        this.put(KEY_RESULTCODE, e.getError().getCode());
        this.put(KEY_RESULTMSG, e.getError().getDesc());
        return this;
    }

    public ResponseMapBuilder put(String property, Object value) {
        this.result.put(property, value);
        return this;
    }
}

