package com.zthzinfo;

import javax.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;

public class InterfaceUtil {

	public static boolean validateToken(final HttpServletRequest request, String PK){
		String token_calc = generateToken(request, PK);
		String token_param = request.getParameter("sign");

		if (token_calc != null && token_calc.equalsIgnoreCase(token_param)) {
			return true;
		} else {
			return false;
		}
	}

	public static String generateToken(final HttpServletRequest request, String PK){
		Map<String, String[]> map = request.getParameterMap();
		Map<String, String> newMap = new HashMap<>();
		Iterator<Map.Entry<String, String[]>> iterator =  map.entrySet().iterator();
		while(iterator.hasNext()){
			Map.Entry<String, String[]> tmp = iterator.next();
			String key = tmp.getKey();
			String[] val = tmp.getValue();
			if(!"sign".equals(key)&&val!=null&&val.length>0){
				newMap.put(key,val[0]);
			}
		}
		return generateToken(newMap,PK);
	}


	private static String generateToken(final Map<String, String> param, String PK) {

		String token = InterfaceUtil.generateToken(PK, new ArrayList<String>(param.keySet()), new InterfaceUtil.ParamMap() {
			@Override
			public String getValue(String key) {
				return param.get(key);
			}
		});
		return token;
	}

	private static String generateToken(String PK, Collection<String> keys, ParamMap paramMap) {
		if (PK == null) {
			return null;
		}
		String strOri = generateSource(PK, keys, paramMap);

		String token = md5(strOri);
		return token;
	}

	/**
	 * Encodes a string 2 MD5
	 *
	 * @param str String to encode
	 * @return Encoded String
	 * @throws NoSuchAlgorithmException
	 */
	private static String md5(String str) {
		if (str == null || str.length() == 0) {
			throw new IllegalArgumentException("String to encript cannot be null or zero length");
		}
		StringBuffer hexString = new StringBuffer();
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(str.getBytes());
			byte[] hash = md.digest();
			for (int i = 0; i < hash.length; i++) {
				if ((0xff & hash[i]) < 0x10) {
					hexString.append("0" + Integer.toHexString((0xFF & hash[i])));
				} else {
					hexString.append(Integer.toHexString(0xFF & hash[i]));
				}
			}
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		return hexString.toString();
	}

	private static String generateSource(String PK, Collection<String> keys, ParamMap paramMap) {

		StringBuffer strOri = new StringBuffer();
		List<String> keysBySort = new ArrayList<String>(keys);

		Collections.sort(keysBySort);
		for (String key : keysBySort) {
			String value = paramMap.getValue(key);
			strOri.append((value == null ? "": value) + "|");
		}
		strOri.append(PK);

		return strOri.toString();
	}



	private interface ParamMap {
		String getValue(String key);
	}

}
