/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class InterfaceUtil {
    public static boolean validateToken(HttpServletRequest request, String PK) {
        String token_calc = InterfaceUtil.generateToken(request, PK);
        String token_param = request.getParameter("sign");
        return token_calc != null && token_calc.equalsIgnoreCase(token_param);
    }

    public static String generateToken(HttpServletRequest request, String PK) {
        Map map = request.getParameterMap();
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry tmp : map.entrySet()) {
            String key = (String)tmp.getKey();
            String[] val = (String[])tmp.getValue();
            if ("sign".equals(key) || val == null || val.length <= 0) continue;
            newMap.put(key, val[0]);
        }
        return InterfaceUtil.generateToken(newMap, PK);
    }

    private static String generateToken(final Map<String, String> param, String PK) {
        String token = InterfaceUtil.generateToken(PK, new ArrayList<String>(param.keySet()), new ParamMap(){

            @Override
            public String getValue(String key) {
                return (String)param.get(key);
            }
        });
        return token;
    }

    private static String generateToken(String PK, Collection<String> keys, ParamMap paramMap) {
        if (PK == null) {
            return null;
        }
        String strOri = InterfaceUtil.generateSource(PK, keys, paramMap);
        String token = InterfaceUtil.md5(strOri);
        return token;
    }

    private static String md5(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("String to encript cannot be null or zero length");
        }
        StringBuffer hexString = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] hash = md.digest();
            for (int i = 0; i < hash.length; ++i) {
                if ((0xFF & hash[i]) < 16) {
                    hexString.append("0" + Integer.toHexString(0xFF & hash[i]));
                    continue;
                }
                hexString.append(Integer.toHexString(0xFF & hash[i]));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return hexString.toString();
    }

    private static String generateSource(String PK, Collection<String> keys, ParamMap paramMap) {
        StringBuffer strOri = new StringBuffer();
        ArrayList<String> keysBySort = new ArrayList<String>(keys);
        Collections.sort(keysBySort);
        for (String key : keysBySort) {
            String value = paramMap.getValue(key);
            strOri.append((value == null ? "" : value) + "|");
        }
        strOri.append(PK);
        return strOri.toString();
    }

    private static interface ParamMap {
        public String getValue(String var1);
    }
}

