package com.zthzinfo.microservice.security;

import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OKHttp3Util {

	public static Map<String, String> getParams(Request request) {
		if (request == null) {
			return null;
		}

		//公共参数
		Map<String, String> params = new HashMap<>();
		HttpUrl mHttpUrl = request.url();

		Set<String> paramNames = mHttpUrl.queryParameterNames();
		for (String key : paramNames) {
			params.put(key, mHttpUrl.queryParameter(key));
		}


		RequestBody body = request.body();
		if (body != null && (body instanceof FormBody)) {
			for (int i = 0; i < ((FormBody) body).size(); i++) {
				params.put(((FormBody) body).encodedName(i),((FormBody) body).encodedValue(i));
			}
		}

		return params;
	}

}
