/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.entity;

import com.cxqm.xiaoerke.common.bean.ICookieEntity;
import com.cxqm.xiaoerke.common.persistence.DataEntity;
import com.cxqm.xiaoerke.common.supcan.annotation.treelist.cols.SupCol;
import com.cxqm.xiaoerke.common.utils.Collections3;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.modules.sys.entity.Office;
import com.cxqm.xiaoerke.modules.sys.entity.Role;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;

public class User
extends DataEntity<User>
implements ICookieEntity {
    private static final long serialVersionUID = 1L;
    public static final String USER_TYPE_USER = "user";
    public static final String USER_TYPE_DOCTOR = "doctor";
    public static final String USER_TYPE_DISTRIBUTOR = "distributor";
    public static final String USER_TYPE_CONSULTDOCTOR = "consultDoctor";
    public static final String USER_TYPE_DOCTOR_HELPER = "doctorHelper";
    private Office company;
    private Office office;
    private String loginName;
    private String password;
    private String no;
    private String name;
    private String email;
    private String phone;
    private String mobile;
    private String userType;
    private String loginIp;
    private Date loginDate;
    private String loginFlag;
    private String photo;
    private String buckter;
    private Date birthDate;
    private String oldLoginName;
    private String newPassword;
    private String oldLoginIp;
    private Date oldLoginDate;
    private Role role;
    private List<Role> roleList = Lists.newArrayList();
    private String openid;
    private String marketer;
    private Integer sex;
    private String unionId;
    private String idPicFront;
    private String idPicFrontBucket;
    private String idPicBack;
    private String idPicBackBucket;
    private String dataFrom;
    private String detailedAddress;
    private String doctorOpenid;
    private String doctorHeplerOpenid;
    private List<String> ids;
    private List<String> names;
    private List<String> mobiles;
    private String realName;
    private String idCard;
    private String region;
    private String updateType;
    private String interimPhoto;
    private String idPicFrontTran;
    private String idPicBackTran;

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public List<String> getMobiles() {
        return this.mobiles;
    }

    public void setMobiles(List<String> mobiles) {
        this.mobiles = mobiles;
    }

    public Integer getSex() {
        return this.sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getIdPicFront() {
        return this.idPicFront;
    }

    public void setIdPicFront(String idPicFront) {
        this.idPicFront = idPicFront;
    }

    public String getIdPicFrontBucket() {
        return this.idPicFrontBucket;
    }

    public void setIdPicFrontBucket(String idPicFrontBucket) {
        this.idPicFrontBucket = idPicFrontBucket;
    }

    public String getIdPicBack() {
        return this.idPicBack;
    }

    public void setIdPicBack(String idPicBack) {
        this.idPicBack = idPicBack;
    }

    public String getIdPicBackBucket() {
        return this.idPicBackBucket;
    }

    public void setIdPicBackBucket(String idPicBackBucket) {
        this.idPicBackBucket = idPicBackBucket;
    }

    public String getDataFrom() {
        return this.dataFrom;
    }

    public void setDataFrom(String dataFrom) {
        this.dataFrom = dataFrom;
    }

    public User() {
        this.loginFlag = "1";
    }

    public User(String id) {
        super(id);
    }

    public User(String id, String loginName) {
        super(id);
        this.loginName = loginName;
    }

    public User(Role role) {
        this.role = role;
    }

    @Override
    public String getPhoto() {
        return this.photo;
    }

    @Override
    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public String getLoginFlag() {
        return this.loginFlag;
    }

    public void setLoginFlag(String loginFlag) {
        this.loginFlag = loginFlag;
    }

    @Override
    @SupCol(isUnique="true", isHide="true")
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    @NotNull(message="\u5f52\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a")
    public Office getCompany() {
        return this.company;
    }

    public void setCompany(Office company) {
        this.company = company;
    }

    @JsonIgnore
    @NotNull(message="\u5f52\u5c5e\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a")
    public Office getOffice() {
        return this.office;
    }

    public void setOffice(Office office) {
        this.office = office;
    }

    @Length(min=1, max=100, message="\u767b\u5f55\u540d\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    @JsonIgnore
    @Length(min=1, max=100, message="\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Length(min=1, max=100, message="\u59d3\u540d\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    public String getName() {
        return this.name;
    }

    @Length(min=1, max=100, message="\u5de5\u53f7\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Email(message="\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e")
    @Length(min=0, max=200, message="\u90ae\u7bb1\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 200 \u4e4b\u95f4")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Length(min=0, max=200, message="\u7535\u8bdd\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 200 \u4e4b\u95f4")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Override
    @Length(min=0, max=200, message="\u624b\u673a\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 200 \u4e4b\u95f4")
    public String getMobile() {
        return this.mobile;
    }

    @Override
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    @Length(min=0, max=100, message="\u7528\u6237\u7c7b\u578b\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    public String getUserType() {
        return this.userType;
    }

    @Override
    public void setUserType(String userType) {
        this.userType = userType;
    }

    @Override
    public Date getCreateDate() {
        return this.createDate;
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getLoginDate() {
        return this.loginDate;
    }

    public void setLoginDate(Date loginDate) {
        this.loginDate = loginDate;
    }

    public String getOldLoginName() {
        return this.oldLoginName;
    }

    public void setOldLoginName(String oldLoginName) {
        this.oldLoginName = oldLoginName;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getOldLoginIp() {
        if (this.oldLoginIp == null) {
            return this.loginIp;
        }
        return this.oldLoginIp;
    }

    public void setOldLoginIp(String oldLoginIp) {
        this.oldLoginIp = oldLoginIp;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getOldLoginDate() {
        if (this.oldLoginDate == null) {
            return this.loginDate;
        }
        return this.oldLoginDate;
    }

    public void setOldLoginDate(Date oldLoginDate) {
        this.oldLoginDate = oldLoginDate;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @JsonIgnore
    public List<Role> getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List<Role> roleList) {
        this.roleList = roleList;
    }

    @JsonIgnore
    public List<String> getRoleIdList() {
        ArrayList roleIdList = Lists.newArrayList();
        for (Role role : this.roleList) {
            roleIdList.add(role.getId());
        }
        return roleIdList;
    }

    public void setRoleIdList(List<String> roleIdList) {
        this.roleList = Lists.newArrayList();
        for (String roleId : roleIdList) {
            Role role = new Role();
            role.setId(roleId);
            this.roleList.add(role);
        }
    }

    public String getRoleNames() {
        return Collections3.extractToString(this.roleList, "name", ",");
    }

    public boolean isAdmin() {
        return User.isAdmin(this.id);
    }

    public static boolean isAdmin(String id) {
        return id != null && "1".equals(id);
    }

    @Override
    public String toString() {
        return this.id;
    }

    @JsonIgnore
    @Length(min=1, max=500, message="openid")
    public String getOpenid() {
        return this.openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getMarketer() {
        return this.marketer;
    }

    public void setMarketer(String marketer) {
        this.marketer = marketer;
    }

    @Override
    public String getBuckter() {
        return this.buckter;
    }

    @Override
    public void setBuckter(String buckter) {
        this.buckter = buckter;
    }

    @Override
    public String getFullPhoto() {
        if (this.photo == null || this.buckter == null) {
            return null;
        }
        return OSSObjectTool.getUrl(this.photo, this.buckter);
    }

    public String getIdPicFrontPhoto() {
        if (this.idPicFront == null || this.idPicFrontBucket == null) {
            return null;
        }
        return OSSObjectTool.getUrl(this.idPicFront, this.idPicFrontBucket);
    }

    public String getIdPicBackPhoto() {
        if (this.idPicBack == null || this.idPicBackBucket == null) {
            return null;
        }
        return OSSObjectTool.getUrl(this.idPicBack, this.idPicBackBucket);
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public String getInterimPhoto() {
        return this.interimPhoto;
    }

    public void setInterimPhoto(String interimPhoto) {
        this.interimPhoto = interimPhoto;
    }

    public String getDetailedAddress() {
        return this.detailedAddress;
    }

    public void setDetailedAddress(String detailedAddress) {
        this.detailedAddress = detailedAddress;
    }

    public String getIdPicFrontTran() {
        return this.idPicFrontTran;
    }

    public void setIdPicFrontTran(String idPicFrontTran) {
        this.idPicFrontTran = idPicFrontTran;
    }

    public String getIdPicBackTran() {
        return this.idPicBackTran;
    }

    public void setIdPicBackTran(String idPicBackTran) {
        this.idPicBackTran = idPicBackTran;
    }

    @Override
    public void setFullPhoto(String fullPhoto) {
    }

    public String getDoctorOpenid() {
        return this.doctorOpenid;
    }

    public void setDoctorOpenid(String doctorOpenid) {
        this.doctorOpenid = doctorOpenid;
    }

    public String getDoctorHeplerOpenid() {
        return this.doctorHeplerOpenid;
    }

    public void setDoctorHeplerOpenid(String doctorHeplerOpenid) {
        this.doctorHeplerOpenid = doctorHeplerOpenid;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Integer getAge() {
        if (this.birthDate == null) {
            return null;
        }
        Calendar from = Calendar.getInstance();
        from.setTime(this.birthDate);
        Calendar to = Calendar.getInstance();
        to.setTime(new Date());
        int fromYear = from.get(1);
        int fromMonth = from.get(2);
        int toYear = to.get(1);
        int toMonth = to.get(2);
        Integer year = toYear - fromYear;
        return toMonth >= fromMonth ? year : year - 1;
    }
}

