package com.cxqm.xiaoerke.common.bean;

public enum BaseErrors implements IErrorInfo {
	/**
	 * 令牌验证失败
	 */
	TOKEN_ERROR("ZTHZ00000001", "令牌验证失败"),
	/**
	 * 时间戳验证失败
	 */
	TIMESTAMP_ERROR("ZTHZ00000002", "时间戳验证失败"),

	/**
	 * 用户未登录
	 */
	USER_NOTE_LOGIN("ZTHZ00000003", "用户未登录"),

	/**
	 * 未知错误
	 */
	UNKNOW("ZTHZ00000004", "未知错误"),

	/**
	 * 参数不能为空
	 */
	PARAM_NOT_NULL("ZTHZ00000005", "参数不能为空"),

	/**
	 * 格式不正确
	 */
	FORMAT_ERROR("ZTHZ00000006", "格式不正确"),
	;

	private String code;
	private String desc;

	private BaseErrors(String code, String desc) {
		this.setCode(code);
		this.setDesc(desc);
	}

	@Override
	public String toString() {
		return "[" + this.code + "]" + this.desc;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}
}
