package com.cxqm.xiaoerke.common.web;

/**
 * Created by yanghb on 17/3/13.
 */
//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

import com.ckfinder.connector.configuration.Events;
import com.ckfinder.connector.data.InitCommandEventArgs;
import com.ckfinder.connector.data.PluginInfo;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import com.ckfinder.connector.utils.PathUtils;
import org.w3c.dom.Element;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CKFAliyunInitCommand extends XMLCommand {
	private static final int[] LICENSE_CHARS = new int[]{11, 0, 8, 12, 26, 2, 3, 25, 1};
	private static final int LICENSE_CHAR_NR = 5;
	private static final int HASH = 255;
	private static final int LICENSE_KEY_LENGTH = 34;
	private String type;

	public CKFAliyunInitCommand() {
	}

	protected int getDataForXml() {
		return 0;
	}

	protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
		if(errorNum == 0) {
			this.createConnectorData(rootElement);

			try {
				this.createResouceTypesData(rootElement);
			} catch (Exception var4) {
				if(this.configuration.isDebugMode()) {
					throw new ConnectorException(var4);
				}
			}

			this.createPluginsData(rootElement);
		}

	}

	private void createConnectorData(Element rootElement) {
		Element element = this.creator.getDocument().createElement("ConnectorInfo");
		element.setAttribute("enabled", String.valueOf(this.configuration.enabled()));
		element.setAttribute("s", this.getLicenseName());
		element.setAttribute("c", this.createLicenseKey(this.configuration.getLicenseKey()));
		element.setAttribute("thumbsEnabled", String.valueOf(this.configuration.getThumbsEnabled()));
		element.setAttribute("uploadCheckImages", this.configuration.checkSizeAfterScaling()?"false":"true");
		if(this.configuration.getThumbsEnabled()) {
			element.setAttribute("thumbsUrl", this.configuration.getThumbsURL());
			element.setAttribute("thumbsDirectAccess", String.valueOf(this.configuration.getThumbsDirectAccess()));
			element.setAttribute("thumbsWidth", String.valueOf(this.configuration.getMaxThumbWidth()));
			element.setAttribute("thumbsHeight", String.valueOf(this.configuration.getMaxThumbHeight()));
		}

		element.setAttribute("imgWidth", String.valueOf(this.configuration.getImgWidth()));
		element.setAttribute("imgHeight", String.valueOf(this.configuration.getImgHeight()));
		if(this.configuration.getPlugins().size() > 0) {
			element.setAttribute("plugins", this.getPlugins());
		}

		rootElement.appendChild(element);
	}

	private String getPlugins() {
		StringBuffer sb = new StringBuffer();
		boolean first = false;
		Iterator i$ = this.configuration.getPlugins().iterator();

		while(i$.hasNext()) {
			PluginInfo item = (PluginInfo)i$.next();
			if(item.isEnabled()) {
				if(first) {
					sb.append(",");
				}

				sb.append(item.getName());
				first = true;
			}
		}

		return sb.toString();
	}

	private String getLicenseName() {
		if(this.validateLicenseKey(this.configuration.getLicenseKey())) {
			int index = "123456789ABCDEFGHJKLMNPQRSTUVWXYZ".indexOf(this.configuration.getLicenseKey().charAt(0)) % 5;
			if(index == 1 || index == 4) {
				return this.configuration.getLicenseName();
			}
		}

		return "";
	}

	private String createLicenseKey(String licenseKey) {
		if(!this.validateLicenseKey(licenseKey)) {
			return "";
		} else {
			StringBuilder sb = new StringBuilder();
			int[] arr$ = LICENSE_CHARS;
			int len$ = arr$.length;

			for(int i$ = 0; i$ < len$; ++i$) {
				int i = arr$[i$];
				sb.append(licenseKey.charAt(i));
			}

			return sb.toString();
		}
	}

	private boolean validateLicenseKey(String licenseKey) {
		return licenseKey != null && licenseKey.length() == 34;
	}

	public void createPluginsData(Element rootElement) throws ConnectorException {
		Element element = this.creator.getDocument().createElement("PluginsInfo");
		rootElement.appendChild(element);
		InitCommandEventArgs args = new InitCommandEventArgs();
		args.setXml(this.creator);
		args.setRootElement(rootElement);
		if(this.configuration.getEvents() != null) {
			this.configuration.getEvents().run(Events.EventTypes.InitCommand, args, this.configuration);
		}

	}

	private void createResouceTypesData(Element rootElement) throws Exception {
		Element element = this.creator.getDocument().createElement("ResourceTypes");
		rootElement.appendChild(element);
		Object types = null;
		if(super.type != null && !super.type.equals("")) {
			types = new ArrayList();
			((List)types).add(super.type);
		} else {
			types = this.getTypes();
		}

		Iterator i$ = ((List)types).iterator();

		while(true) {
			String key;
			ResourceType resourceType;
			do {
				do {
					do {
						if(!i$.hasNext()) {
							return;
						}

						key = (String)i$.next();
						resourceType = (ResourceType)this.configuration.getTypes().get(key);
					} while(this.type != null && !this.type.equals(key));
				} while(resourceType == null);
			} while(!AccessControlUtil.getInstance(this.configuration).checkFolderACL(key, "/", this.userRole, 1));

			Element childElement = this.creator.getDocument().createElement("ResourceType");
			childElement.setAttribute("name", resourceType.getName());
			childElement.setAttribute("acl", String.valueOf(AccessControlUtil.getInstance(this.configuration).checkACLForRole(key, "/", this.userRole)));
			childElement.setAttribute("hash", this.randomHash(resourceType.getPath()));
			childElement.setAttribute("allowedExtensions", resourceType.getAllowedExtensions());
			childElement.setAttribute("deniedExtensions", resourceType.getDeniedExtensions());
			childElement.setAttribute("url", resourceType.getUrl() + "/");
			Long maxSize = resourceType.getMaxSize();
			childElement.setAttribute("maxSize", maxSize != null && maxSize.longValue() > 0L?maxSize.toString():"0");
			childElement.setAttribute("hasChildren", Boolean.valueOf(true).toString());
			element.appendChild(childElement);
		}
	}

	private List<String> getTypes() {
		return this.configuration.getDefaultResourceTypes().size() > 0?this.configuration.getDefaultResourceTypes():this.configuration.getResourceTypesOrder();
	}

	private String randomHash(String folder) throws Exception {
		try {
			MessageDigest e = MessageDigest.getInstance("MD5");
			e.reset();

			try {
				e.update(folder.getBytes("UTF8"));
			} catch (UnsupportedEncodingException var6) {
				if(this.configuration.isDebugMode()) {
					throw var6;
				}

				e.update(folder.getBytes());
			}

			byte[] messageDigest = e.digest();
			StringBuffer hexString = new StringBuffer();

			for(int i = 0; i < messageDigest.length; ++i) {
				hexString.append(Integer.toHexString(255 & messageDigest[i]));
			}

			return hexString.toString();
		} catch (NoSuchAlgorithmException var7) {
			if(this.configuration.isDebugMode()) {
				throw var7;
			} else {
				return "";
			}
		}
	}

	protected boolean mustAddCurrentFolderNode() {
		return false;
	}

	protected void getCurrentFolderParam(HttpServletRequest request) {
		this.currentFolder = null;
	}
}
