/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.servlet;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.filter.CKFAliyunBukert;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.util.UriUtils;

public class UserfilesDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void fileOutputStream(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String filepath = req.getRequestURI();
        int index = filepath.indexOf("/userfiles/");
        if (index >= 0) {
            filepath = filepath.substring(index + "/userfiles/".length());
        }
        try {
            filepath = UriUtils.decode((String)filepath, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            this.logger.error(String.format("\u89e3\u91ca\u6587\u4ef6\u8def\u5f84\u5931\u8d25\uff0cURL\u5730\u5740\u4e3a%s", filepath), (Throwable)e1);
        }
        File file = new File(Global.getUserfilesBaseDir() + "/userfiles/" + filepath);
        try {
            FileCopyUtils.copy((InputStream)new FileInputStream(file), (OutputStream)resp.getOutputStream());
            resp.setHeader("Content-Type", "application/octet-stream");
            return;
        }
        catch (FileNotFoundException e) {
            req.setAttribute("exception", (Object)new FileNotFoundException("\u8bf7\u6c42\u7684\u6587\u4ef6\u4e0d\u5b58\u5728"));
            req.getRequestDispatcher("/WEB-INF/views/error/404.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String filepath = req.getRequestURI();
        String userId = CKFAliyunBukert.getUserId();
        String projectName = CKFAliyunBukert.getBuketKey();
        int index = filepath.indexOf("/userfiles/");
        if (index >= 0) {
            filepath = filepath.substring(index + "/userfiles/".length());
        }
        try {
            filepath = UriUtils.decode((String)filepath, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            this.logger.error(String.format("\u89e3\u91ca\u6587\u4ef6\u8def\u5f84\u5931\u8d25\uff0cURL\u5730\u5740\u4e3a%s", filepath), (Throwable)e1);
        }
        String[] dirs = filepath.split("/");
        boolean isThumbs = false;
        if (dirs.length >= 2) {
            String fileName;
            String afterPoint = fileName = dirs[dirs.length - 1];
            int pointIndex = fileName.indexOf(46);
            if (pointIndex >= 0) {
                afterPoint = fileName.substring(pointIndex);
            }
            if (afterPoint.indexOf("-") >= 0 || afterPoint.indexOf("_") >= 0 || afterPoint.indexOf("!") >= 0 || afterPoint.indexOf("/") >= 0) {
                filepath = this.removeIndexOneAndJoin(dirs);
            } else if (dirs[1].equals("_thumbs")) {
                isThumbs = true;
                filepath = this.removeIndexOneAndJoin(dirs);
            }
        }
        if (isThumbs) {
            filepath = filepath + "-thumbs";
        }
        resp.sendRedirect(OSSObjectTool.getUrl(filepath, projectName == null || projectName.trim().equals("") ? OSSObjectTool.BUCKET_BACKEND_PIC : projectName));
    }

    private String removeIndexOneAndJoin(String[] dirs) {
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(dirs));
        strings.remove(1);
        dirs = strings.toArray(new String[strings.size()]);
        return StringUtils.join((Object[])dirs, (String)"/");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

