/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.security.shiro.cache;

import com.cxqm.xiaoerke.common.web.Servlets;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCacheManager
implements CacheManager {
    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        return new sessionCache(name);
    }

    public class sessionCache<K, V>
    implements Cache<K, V> {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private String cacheKeyName = null;

        public sessionCache(String cacheKeyName) {
            this.cacheKeyName = cacheKeyName;
        }

        public Session getSession() {
            Session session = null;
            try {
                Subject subject = SecurityUtils.getSubject();
                session = subject.getSession(false);
                if (session == null) {
                    session = subject.getSession();
                }
            }
            catch (InvalidSessionException e) {
                this.logger.error("Invalid session error", (Throwable)e);
            }
            catch (UnavailableSecurityManagerException e2) {
                this.logger.error("Unavailable SecurityManager error", (Throwable)e2);
            }
            return session;
        }

        public V get(K key) throws CacheException {
            if (key == null) {
                return null;
            }
            Object v = null;
            HttpServletRequest request = Servlets.getRequest();
            if (request != null && (v = request.getAttribute(this.cacheKeyName)) != null) {
                return (V)v;
            }
            Object value = null;
            value = this.getSession().getAttribute((Object)this.cacheKeyName);
            this.logger.debug("get {} {} {}", new Object[]{this.cacheKeyName, key, request != null ? request.getRequestURI() : ""});
            if (request != null && value != null) {
                request.setAttribute(this.cacheKeyName, value);
            }
            return (V)value;
        }

        public V put(K key, V value) throws CacheException {
            if (key == null) {
                return null;
            }
            this.getSession().setAttribute((Object)this.cacheKeyName, value);
            if (this.logger.isDebugEnabled()) {
                HttpServletRequest request = Servlets.getRequest();
                this.logger.debug("put {} {} {}", new Object[]{this.cacheKeyName, key, request != null ? request.getRequestURI() : ""});
            }
            return value;
        }

        public V remove(K key) throws CacheException {
            Object value = null;
            value = this.getSession().removeAttribute((Object)this.cacheKeyName);
            this.logger.debug("remove {} {}", (Object)this.cacheKeyName, key);
            return (V)value;
        }

        public void clear() throws CacheException {
            this.getSession().removeAttribute((Object)this.cacheKeyName);
            this.logger.debug("clear {}", (Object)this.cacheKeyName);
        }

        public int size() {
            this.logger.debug("invoke session size abstract size method not supported.");
            return 0;
        }

        public Set<K> keys() {
            this.logger.debug("invoke session keys abstract size method not supported.");
            return Sets.newHashSet();
        }

        public Collection<V> values() {
            this.logger.debug("invoke session values abstract size method not supported.");
            return Collections.emptyList();
        }
    }
}

