/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DBCompareUtil {
    public static List<DBTable> test = new ArrayList<DBTable>();
    public static List<DBTable> prod = new ArrayList<DBTable>();
    public static Set<String> newTables = new LinkedHashSet<String>();
    public static Set<String> newColumns = new LinkedHashSet<String>();
    public static Set<String> deleteTables = new LinkedHashSet<String>();
    public static Set<String> deleteColumns = new LinkedHashSet<String>();
    public static Set<String> changeColumns = new LinkedHashSet<String>();

    public static void main(String[] args) {
        DBCompareUtil.fillTest();
        DBCompareUtil.fillProd();
        DBCompareUtil.compare(test, prod);
    }

    public static void fillTest() {
    }

    public static void fillProd() {
    }

    public static void compare(List<DBTable> _test, List<DBTable> _prod) {
        DBCompareUtil.findChangeOfTable(test, prod, newTables, deleteTables);
        DBCompareUtil.findNewOrDeleteColumn(test, prod, newColumns, deleteColumns);
        DBCompareUtil.findChangeColumn(test, prod, changeColumns);
        System.out.println("\u65b0\u589e\u7684\u8868\uff1a");
        for (String newTable : newTables) {
            System.out.println(newTable);
        }
        System.out.println("-----------------------------------------------");
        System.out.println("\u5220\u9664\u7684\u8868\uff1a");
        for (String deleteTable : deleteTables) {
            System.out.println(deleteTable);
        }
        System.out.println("-----------------------------------------------");
        System.out.println("\u65b0\u589e\u7684\u5b57\u6bb5\uff1a");
        for (String newColumn : newColumns) {
            System.out.println(newColumn);
        }
        System.out.println("-----------------------------------------------");
        System.out.println("\u5220\u9664\u7684\u5b57\u6bb5\uff1a");
        for (String deleteColumn : deleteColumns) {
            System.out.println(deleteColumn);
        }
        System.out.println("-----------------------------------------------");
        System.out.println("\u53d8\u5316\u7684\u5b57\u6bb5\uff1a");
        for (String changeColumn : changeColumns) {
            System.out.println(changeColumn);
        }
        System.out.println("-----------------------------------------------");
    }

    public static void findChangeColumn(List<DBTable> _test, List<DBTable> _prod, Set<String> _changeColumns) {
        for (DBTable tableInTest : _test) {
            DBTable tableInProd = DBCompareUtil.findDBTableInList(_prod, tableInTest.name);
            for (int i = 0; i < tableInTest.columns.size(); ++i) {
                DBColumn columnInTest = (DBColumn)tableInTest.columns.get(i);
                DBColumn columnInProd = DBCompareUtil.findDBColumnInList(tableInProd.columns, columnInTest.name);
                if (columnInProd.equals(columnInTest)) continue;
                changeColumns.add(tableInProd.name + "." + columnInProd.name);
            }
        }
    }

    public static void findNewOrDeleteColumn(List<DBTable> _test, List<DBTable> _prod, Set<String> _newColumns, Set<String> _deleteColumns) {
        int i;
        for (DBTable tableInTest : _test) {
            DBTable tableInProd = DBCompareUtil.findDBTableInList(_prod, tableInTest.name);
            for (i = 0; i < tableInTest.columns.size(); ++i) {
                DBColumn columnInTest = (DBColumn)tableInTest.columns.get(i);
                DBColumn columnInProd = DBCompareUtil.findDBColumnInList(tableInProd.columns, columnInTest.name);
                if (columnInProd != null) continue;
                _newColumns.add(tableInTest.name + "." + columnInTest.name);
                tableInTest.columns.remove(i--);
            }
        }
        for (DBTable tableInProd : _prod) {
            DBTable tableInTest = DBCompareUtil.findDBTableInList(_test, tableInProd.name);
            for (i = 0; i < tableInProd.columns.size(); ++i) {
                DBColumn columnInProd = (DBColumn)tableInProd.columns.get(i);
                DBColumn columnInTest = DBCompareUtil.findDBColumnInList(tableInTest.columns, columnInProd.name);
                if (columnInTest != null) continue;
                _deleteColumns.add(tableInProd.name + "." + columnInProd.name);
                tableInProd.columns.remove(i--);
            }
        }
    }

    public static void findChangeOfTable(List<DBTable> _test, List<DBTable> _prod, Set<String> _newTables, Set<String> _deleteTables) {
        DBTable dbTableInList;
        int i;
        for (i = 0; i < _test.size(); ++i) {
            DBTable tableOfTest = _test.get(i);
            dbTableInList = DBCompareUtil.findDBTableInList(_prod, tableOfTest.name);
            if (dbTableInList != null) continue;
            _newTables.add(tableOfTest.name);
            _test.remove(i--);
        }
        for (i = 0; i < _prod.size(); ++i) {
            DBTable tableOfProd = _prod.get(i);
            dbTableInList = DBCompareUtil.findDBTableInList(_test, tableOfProd.name);
            if (dbTableInList != null) continue;
            _deleteTables.add(tableOfProd.name);
            _prod.remove(i--);
        }
    }

    public static void add(List<DBTable> db, String item) {
        String[] split = item.split("\\*");
        String tableName = split[0];
        String columnName = split[1];
        String type = split[2];
        String nullable = split[3];
        String key = split[4];
        String order = split[5];
        String defaultValue = split.length < 7 ? null : (split[6].equals("[NULL]") ? null : split[6]);
        String extra = split.length < 8 ? null : split[7];
        DBTable table = DBCompareUtil.findDBTableInList(db, tableName);
        if (table == null) {
            table = new DBTable(tableName);
            db.add(table);
        }
        table.addColumn(columnName, type, nullable, key, order, defaultValue, extra);
    }

    public static DBTable findDBTableInList(List<DBTable> tables, String tableName) {
        for (DBTable table : tables) {
            if (!table.name.equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public static DBColumn findDBColumnInList(List<DBColumn> columns, String columnName) {
        for (DBColumn column : columns) {
            if (!column.name.equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public static class DBColumn {
        private String name;
        private String type;
        private Boolean nullable;
        private String key;
        private String order;
        private String defaultValue;
        private String extra;

        public DBColumn() {
        }

        public DBColumn(String name, String type, String nullable, String key, String order, String defaultValue, String extra) {
            this(name, type, "YES".equals(nullable), key, order, defaultValue, extra);
        }

        public DBColumn(String name, String type, Boolean nullable, String key, String order, String defaultValue, String extra) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.key = key;
            this.order = order;
            this.defaultValue = defaultValue;
            this.extra = extra;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DBColumn dbColumn = (DBColumn)o;
            if (this.name != null ? !this.name.equals(dbColumn.name) : dbColumn.name != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(dbColumn.type) : dbColumn.type != null) {
                return false;
            }
            if (this.nullable != null ? !this.nullable.equals(dbColumn.nullable) : dbColumn.nullable != null) {
                return false;
            }
            if (this.key != null ? !this.key.equals(dbColumn.key) : dbColumn.key != null) {
                return false;
            }
            if (this.order != null ? !this.order.equals(dbColumn.order) : dbColumn.order != null) {
                return false;
            }
            if (this.defaultValue != null ? !this.defaultValue.equals(dbColumn.defaultValue) : dbColumn.defaultValue != null) {
                return false;
            }
            return !(this.extra == null ? dbColumn.extra != null : !this.extra.equals(dbColumn.extra));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.nullable != null ? this.nullable.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
            result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
            result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
            return result;
        }
    }

    public static class DBTable {
        private String name;
        private List<DBColumn> columns = new ArrayList<DBColumn>();

        public DBTable() {
        }

        public DBTable(String name) {
            this();
            this.name = name;
        }

        public void addColumn(String columnName, String type, String nullable, String key, String order, String defaultValue, String extra) {
            this.columns.add(new DBColumn(columnName, type, nullable, key, order, defaultValue, extra));
        }
    }
}

