package com.cxqm.xiaoerke.common.bean;

import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * Created by sunzb on 16/12/26.
 */
public class DownedResource {
	private String fileName;
	private ByteArrayInputStream inputStrem;
	private Integer length;
	private String ext;
	private String contentType;

	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public ByteArrayInputStream getInputStrem() {
		return inputStrem;
	}

	public void setInputStrem(ByteArrayInputStream inputStrem) {
		this.inputStrem = inputStrem;
	}

	public Integer getLength() {
		return length;
	}

	public void setLength(Integer length) {
		this.length = length;
	}

	public String getExt() {
		return ext;
	}

	public void setExt(String ext) {
		this.ext = ext;
	}

	public String fillExt() {
		if (this.getFileName() == null) {
			return null;
		}
		int index = this.getFileName().lastIndexOf('.');
		if (index < 0) {
			if (contentType == null) {
				return null;
			}

			MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
			MimeType jpeg = null;
			try {
				jpeg = allTypes.forName(contentType);
			} catch (MimeTypeException e) {
				return null;
			}
			this.ext = jpeg.getExtension();
			return this.ext;
		}

		this.ext = "." + this.getFileName().substring(index + 1);
		return this.ext;
	}
}
