package com.cxqm.xiaoerke.common.web;

import com.cxqm.xiaoerke.common.bean.BaseErrors;
import com.cxqm.xiaoerke.common.bean.BaseValidateModule;
import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.MD5Util;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Created by sunzsh on 2016/12/15.
 */
public class ApiValidateInterceptor extends HandlerInterceptorAdapter {

	private ApiValidateIntercreptorKeyGetter keyGetter;
	public ApiValidateIntercreptorKeyGetter getKeyGetter() {
		return keyGetter;
	}
	public void setKeyGetter(ApiValidateIntercreptorKeyGetter keyGetter) {
		this.keyGetter = keyGetter;
	}

	private String getKey(final HttpServletRequest request,final HttpServletResponse response, final Object handler) {
		if (this.primariyKey != null){
			return this.primariyKey;
		}
		if (this.keyGetter != null) {
			return this.keyGetter.getKey(request, response, handler);
		}
		return null;
	}

	private String primariyKey;

	private String dynamicPrimariyKey;

	public String getDynamicPrimariyKey() {
		return dynamicPrimariyKey;
	}

	public void setDynamicPrimariyKey(String dynamicPrimariyKey) {
		this.dynamicPrimariyKey = dynamicPrimariyKey;
	}

	public String getPrimariyKey() {
		return primariyKey;
	}

	public void setPrimariyKey(String primariyKey) {
		this.primariyKey = primariyKey;
	}

	private String enableDebug;

	public String getEnableDebug() {
		return enableDebug;
	}

	public void setEnableDebug(String enableDebug) {
		this.enableDebug = enableDebug;
	}

	@Override
	public boolean preHandle(final HttpServletRequest request, HttpServletResponse response, Object handler)
			throws Exception {
		if (enableDebug != null && enableDebug.equals("1")) {
			String debug = request.getParameter("DEBUG");
			if (debug != null && debug.equals("1")) {
				return super.preHandle(request, response, handler);
			}
		}
		String tokenByRequest = request.getParameter("token");
		if (tokenByRequest == null || tokenByRequest.trim().length() == 0) {
			throw new BusinessException(BaseErrors.TOKEN_ERROR);
		}
		String timestamp = request.getParameter("timestamp");
		if (timestamp == null || timestamp.trim().length() == 0) {
			throw new BusinessException(BaseErrors.TIMESTAMP_ERROR);
		}

		List<String> keys = Collections.list(request.getParameterNames());
		keys.remove("token");

		String token = generateToken(this.getKey(request, response, handler), keys, new ParamMap() {
			@Override
			public String getValue(String key) {
				return request.getParameter(key);
			}
		});

		if (!tokenByRequest.equalsIgnoreCase(token)) {
			throw new BusinessException(BaseErrors.TOKEN_ERROR);
		}

		return super.preHandle(request, response, handler);
	}
	public static String validateToken(final HttpServletRequest request,String PK){
		Map<String,String> map = request.getParameterMap();
		map.remove("sign");
		return validateToken(map,PK);
	}
	public static String validateToken(final Map<String, String> param, String PK) {

		String token = ApiValidateInterceptor.generateToken(PK, new ArrayList<String>(param.keySet()), new ApiValidateInterceptor.ParamMap() {
			@Override
			public String getValue(String key) {
				return param.get(key);
			}
		});
		return token;
	}
	public static ApiValidateTokenVo generateToken(String PK, Map<String, String> param) {
		final Map<String, String> myParam = new HashMap<String, String>(param);

		ApiValidateTokenVo result = new ApiValidateTokenVo(new Date().getTime());

		myParam.put("timestamp", result.getTimestamp()+"");
		String token = generateToken(PK, new ArrayList<String>(myParam.keySet()), new ParamMap() {
			@Override
			public String getValue(String key) {
				return myParam.get(key);
			}
		});

		result.setToken(token);

		return result;

	}

	public static String generateToken(String PK, Collection<String> keys, ParamMap paramMap) {
		if (PK == null) {
			return null;
		}

		StringBuffer strOri = new StringBuffer();
		List<String> keysBySort = new ArrayList<String>(keys);

		Collections.sort(keysBySort);
		for (String key : keysBySort) {
			String value = paramMap.getValue(key);
			strOri.append((value == null ? "": value) + "|");
		}
		strOri.append(PK);

		String token = MD5Util.MD5Encode(strOri.toString(), "utf-8");
		return token;
	}


	public interface ParamMap {
		String getValue(String key);
	}
}
