package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatBean;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.sf.json.JSONObject;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;


/**
 * Created by sunzb on 16/12/21.
 */
public class WCurrentUserUtil {

	public static String COOKIEPK = "X1+n3$]`N8~/";
	/**
	 * 微信端cookie用户信息对应KEY
	 */
	public static String COOKIE_USERINFO_KEY = "haoyun_userInfo";
	/**
	 * 微信端cookie版本号对应KEY
	 */
	public static String COOKIE_VERSION_KEY = "haoyun_version";
	/**
	 * 微信端cookie微信呢用户信息对应KEY
	 */
	public static String COOKIE_WEIXIN_USERINFO_KEY = "haoyun_weixin_userInfo";
	/**
	 * 用户版本号
	 */
	public static Integer COOKIE_VERSION = 4;
	/**
	 * 微信用户信息cookie版本号对应KEY
	 */
	public static String COOKIE_VERSION_WEIXIN_KEY = "haoyun_weixin_version";
	/**
	 * 微信用户信息密文cookie版本号对应KEY
	 */
	public static String COOKIE_USERINFO_WEIXIN_TOKEN_KEY = "haoyun_userInfo_weixin_token";

	/**
	 * 微信用户信息版本号
	 */
	public static Integer COOKIE_WEIXIN_VERSION = 1;
	/**
	 * 微信端cookie用户信息对应KEY验证token
	 */
	public static String COOKIE_USERINFO_TOKEN_KEY = "haoyun_userInfo_token";

	/**
	 * 用户微信头像地址
	 */
	public final static String COOKIE_USERINFO_HEAD_URL_KEY = "haoyun_userInfo_head_url";

	public static void clearUserInfoCookie(HttpServletRequest request,HttpServletResponse response){
		String s=request.getServerName();
		String[] domainArr=s.split("\\.");
		String doamin="";
		if(domainArr.length==1 || domainArr[domainArr.length - 1].matches("\\d*")){
			doamin=request.getServerName();
		}else{
			doamin="." + domainArr[domainArr.length-2]+"."+domainArr[domainArr.length-1];
		}
		Cookie cookie = new Cookie(COOKIE_USERINFO_KEY, null);
		cookie.setMaxAge(0);
		cookie.setPath("/");
		cookie.setDomain(doamin);
		response.addCookie(cookie);
		cookie = new Cookie(COOKIE_USERINFO_TOKEN_KEY, null);
		cookie.setMaxAge(0);
		cookie.setPath("/");
		cookie.setDomain(doamin);
		response.addCookie(cookie);
		cookie = new Cookie(COOKIE_VERSION_KEY, null);
		cookie.setMaxAge(0);
		cookie.setPath("/");
		cookie.setDomain(doamin);
		response.addCookie(cookie);
	}


	public static boolean setCurrentUser(User user, HttpServletRequest request,HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
		String[] domainArr=request.getServerName().split("\\.");
		String doamin="";
		if(domainArr.length==1 || domainArr[domainArr.length - 1].matches("\\d*")){
			doamin=request.getServerName();
		}else{
			doamin="." + domainArr[domainArr.length-2]+"."+domainArr[domainArr.length-1];
		}
		JSONObject userCookie = packagingUserCookie(user);
		Cookie cookie = new Cookie(COOKIE_USERINFO_KEY,URLEncoder.encode(String.valueOf(userCookie), "UTF-8"));
		cookie.setMaxAge(Integer.MAX_VALUE);
		cookie.setPath("/");
		cookie.setDomain(doamin);
		response.addCookie(cookie);
		String userCookieStr = String.valueOf(userCookie);
		String tokenOri = userCookieStr + COOKIEPK;
		String token = MD5UtilNew.getMD5String(tokenOri);
		Cookie cookieToken = new Cookie(COOKIE_USERINFO_TOKEN_KEY, token);
		cookieToken.setMaxAge(Integer.MAX_VALUE);
		cookieToken.setPath("/");
		cookieToken.setDomain(doamin);
		response.addCookie(cookieToken);
		Cookie cookieVersion = new Cookie(COOKIE_VERSION_KEY, COOKIE_VERSION.toString());
		cookieVersion.setMaxAge(Integer.MAX_VALUE);
		cookieVersion.setPath("/");
		cookieVersion.setDomain(doamin);
		response.addCookie(cookieVersion);
		return  true;
	}

	public static void clearWeinXinUserInfoCookie(HttpServletRequest request,HttpServletResponse response){
		String s=request.getServerName();
		String[] domainArr=s.split("\\.");
		String doamin="";
		if(domainArr.length==1|| domainArr[domainArr.length - 1].matches("\\d*")){
			doamin=request.getServerName();
		}else{
			doamin="." + domainArr[domainArr.length-2]+"."+domainArr[domainArr.length-1];
		}
		Cookie cookie = new Cookie(COOKIE_WEIXIN_USERINFO_KEY, null);
		cookie.setMaxAge(0);
		cookie.setPath("/");
		cookie.setDomain(doamin);
		response.addCookie(cookie);
	}

	/**
	 * @param user
	 * @param isSuperPwd 是否使用超级密码登录
	 * @return
	 */
	public static JSONObject packagingUserCookie(User user, boolean isSuperPwd){
		JSONObject jsonObject=new JSONObject();
		jsonObject.put("id",user.getId());
		jsonObject.put("mobile",user.getMobile());
		jsonObject.put("name",user.getName());
		jsonObject.put("photo",user.getPhoto());
		jsonObject.put("buckter",user.getBuckter());
		jsonObject.put("header",user.getFullPhoto() == null ? "" : user.getFullPhoto()+"-dmax232");
		jsonObject.put("userType",user.getUserType());
		if (isSuperPwd) {
			jsonObject.put("isSuperPwd", "1");
		}
		return jsonObject;
	}

	public static JSONObject packagingUserCookie(User user){
		return packagingUserCookie(user, false);
	}

	public static User  getPackagingUserCookie(JSONObject jsonObject){
		User userEntity = new User();
		userEntity.setId((String)jsonObject.get("id"));
		userEntity.setMobile((String)jsonObject.get("mobile"));
		userEntity.setName((String)jsonObject.get("name"));
		userEntity.setPhoto((String)jsonObject.get("photo"));
		userEntity.setBuckter((String)jsonObject.get("buckter"));
		userEntity.setUserType((String)jsonObject.get("userType"));
		return  userEntity;
	}

	public static Map stringToMap(String singInfo){
		//将map.toString后的串反转成map
		String str1 = singInfo.replaceAll("\\{|\\}", "");//singInfo是一个map  toString后的字符串。
		String str2 = str1.replaceAll(" ", "");
		String str3 = str2.replaceAll(",", "&");
		Map<String, String> map = null;
		if ((null != str3) && (!"".equals(str3.trim())))
		{
			String[] resArray = str3.split("&");
			if (0 != resArray.length)
			{
				map = new HashMap(resArray.length);
				for (String arrayStr : resArray) {
					if ((null != arrayStr) && (!"".equals(arrayStr.trim())))
					{
						int index = arrayStr.indexOf("=");
						if (-1 != index) {
							map.put(arrayStr.substring(0, index), arrayStr.substring(index + 1));
						}
					}
				}
			}
		}
		return map;
	}

	public static boolean setCurrentWeixinUser(WechatUserInfo user,HttpServletRequest request,HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
		String[] domainArr=request.getServerName().split("\\.");
		String doamin="";
		if(domainArr.length==1){
			doamin= domainArr[0];
		}else{
			doamin= "." + domainArr[domainArr.length-2]+"."+domainArr[domainArr.length-1];
		}
		ObjectMapper mapper = new ObjectMapper();
		user.setNickname(EmojiFilter.coverEmoji(user.getNickname()));
		String userCookie = mapper.writeValueAsString(user);
		Cookie cookie = new Cookie(COOKIE_WEIXIN_USERINFO_KEY, URLEncoder.encode(userCookie, "UTF-8"));
		cookie.setMaxAge(Integer.MAX_VALUE);
		cookie.setPath("/");
		cookie.setDomain(doamin);
		response.addCookie(cookie);
		String userCookieStr = String.valueOf(userCookie);
		String tokenOri = userCookieStr + COOKIEPK;
		String token = MD5UtilNew.getMD5String(tokenOri);
		Cookie cookieToken = new Cookie(COOKIE_USERINFO_WEIXIN_TOKEN_KEY, URLEncoder.encode(token,"UTF-8"));
		cookieToken.setMaxAge(Integer.MAX_VALUE);
		cookieToken.setPath("/");
		cookieToken.setDomain(doamin);
		response.addCookie(cookieToken);
		Cookie cookieVersion = new Cookie(COOKIE_VERSION_WEIXIN_KEY, COOKIE_WEIXIN_VERSION.toString());
		cookieVersion.setMaxAge(Integer.MAX_VALUE);
		cookieVersion.setPath("/");
		cookieVersion.setDomain(doamin);
		response.addCookie(cookieVersion);
		return  true;
	}

	public static String MD5UserToken(String user)throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException{
		if(user==null||user.equals("")||user.equals("null")){
			return "";
		}
		String tokenOri = user + COOKIEPK;
		String token = MD5UtilNew.getMD5String(tokenOri);
		return URLEncoder.encode(token,"UTF-8");
	}

	public static String MD5WeiXinUserToken(String wechatUserInfo)throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException{
		if(wechatUserInfo==null||wechatUserInfo.equals("")||wechatUserInfo.equals("null")){
			return "";
		}
		String tokenOri = wechatUserInfo + COOKIEPK;
		String token = MD5UtilNew.getMD5String(tokenOri);
		return URLEncoder.encode(token,"UTF-8");
	}



	public static boolean isSuperPwd(HttpServletRequest request) {
		try {
			request.setCharacterEncoding("utf-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		Cookie[] cookies = request.getCookies();
		User userEntity=null;
		String userCookie=null;
		String userHiddenCookie=null;
		Integer versionCookie=null;
		if(cookies!=null){
			for (Cookie cookie : cookies) {
				//明文用户信息cookie
				if (WCurrentUserUtil.COOKIE_USERINFO_KEY.equals(cookie.getName())) {
					try {
						userCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
					} catch (UnsupportedEncodingException e) {
						e.printStackTrace();
					}
				}
				//密文用户信息cookie
				if(WCurrentUserUtil.COOKIE_USERINFO_TOKEN_KEY.equals(cookie.getName())) {
					try {
						userHiddenCookie= URLDecoder.decode(cookie.getValue(), "UTF-8");
					} catch (UnsupportedEncodingException e) {
						e.printStackTrace();
					}
				}
				//版本号
				if(WCurrentUserUtil.COOKIE_VERSION_KEY.equals(cookie.getName())){
					versionCookie= Integer.valueOf(cookie.getValue());
				}
			}
		}
		if(userCookie!=null){
			String userCookieStr = String.valueOf(userCookie);
			String tokenOri = userCookieStr + WCurrentUserUtil.COOKIEPK;
			String token = MD5UtilNew.getMD5String(tokenOri);
			if(token.equals(userHiddenCookie)&&versionCookie==WCurrentUserUtil.COOKIE_VERSION){
				JSONObject json=JSONObject.fromObject(userCookieStr);
				if(!json.has("isSuperPwd")) {
					return false;
				}
				String isSuperPwd = json.getString("isSuperPwd");
				return isSuperPwd != null && isSuperPwd.equals("1");
			}
		}
		return false;
	}
}
