package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.modules.sys.entity.SysPropertyVoWithBLOBsVo;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatBean;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import com.cxqm.xiaoerke.modules.sys.service.SysPropertyServiceImpl;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

/**
 * Created by sunzb on 16/12/21.
 */
public class WeixinUtil {
	public static Logger logger = LoggerFactory.getLogger(WeixinUtil.class);
	/**
	 * 不跳转登录页
	 */
	public final static Integer NOT_JUMP_STATUS=0;
	/**
	 * 跳转登录页
	 */
	public final static Integer JUMP_STATUS=1;
	/**
	 * 根据appid secret code 获取网页授权信息(包括openId等信息)
	 * @return
	 */
	public final static String  GET_OPENID_BY_CODE = "https://api.weixin.qq.com/sns/oauth2/access_token?";
	/**
	 * 根据appid secret code 获取网页授权信息(包括openId等信息)
	 * @return
	 */
	public final static String  GET_INFO_BY_TOKEN_OPENID="https://api.weixin.qq.com/sns/userinfo?";

	/**
	 * 根据appid secret code 获取网页授权信息(包括openId等信息)
	 * @return
	 */
	public final static String  GET_CGI_BIN_BY_TOKEN_OPENID="https://api.weixin.qq.com/cgi-bin/user/info?";

	//获取微信用户openid
	public static WechatBean getOpenIdByCode(String appid, String secret,String code){
		String httpReq = GET_OPENID_BY_CODE + "appid=" + appid + "&secret=" + secret+"&code="+code+"&grant_type=authorization_code";
		String json= HttpRequestUtil.getConnectionResult(httpReq, "GET", "");
		WechatBean wechat = JsonUtil.getObjFromJsonStr(json, WechatBean.class);
		if (wechat == null || wechat.getOpenid() == null) {
			logger.error(String.format("oauth认证失败[%s,%s,%s]：%s", appid, secret, code, json));
		}
		return wechat;
	}

	//获取微信用户信息
	public static WechatUserInfo getInfoByAccessTokenOpenId(WechatBean wechat){
		String httpReq = GET_INFO_BY_TOKEN_OPENID + "access_token=" + wechat.getAccess_token() + "&openid=" + wechat.getOpenid()+"&lang=zh_CN";
		String json= HttpRequestUtil.getConnectionResult(httpReq, "GET", "");
		WechatUserInfo info = JsonUtil.getObjFromJsonStr(json, WechatUserInfo.class);
		if (wechat == null || wechat.getNickname() == null) {
			logger.error(String.format("oauth拉去用户信息1失败[%s,%s]：%s", wechat.getAccess_token(), wechat.getOpenid(), json));
		}
		return info;
	}

	//获取微信用户信息
	public static WechatUserInfo getCgiBinByAccessTokenOpenId(WechatBean wechat){
		String httpReq = GET_CGI_BIN_BY_TOKEN_OPENID + "access_token=" + wechat.getAccess_token() + "&openid=" + wechat.getOpenid()+"&lang=zh_CN";
		String json= HttpRequestUtil.getConnectionResult(httpReq, "GET", "");
		WechatUserInfo info = JsonUtil.getObjFromJsonStr(json, WechatUserInfo.class);
		if (wechat == null || wechat.getNickname() == null) {
			logger.error(String.format("oauth拉去用户信息2失败[%s,%s]：%s", wechat.getAccess_token(), wechat.getOpenid(), json));
		}
		return info;
	}

	//判断是否为微信浏览器访问
	public static boolean isWeiXin(HttpServletRequest request) {
		return isWeiXin(request, null);
	}

	//判断是否为微信浏览器访问
	public static boolean isWeiXin(HttpServletRequest request, String ignoreWechatParamName){
		String uaOri = request.getHeader("user-agent");
		if (uaOri == null) {
			return false;
		}
		String ua = uaOri.toLowerCase();
		if (ua.indexOf("micromessenger") > 0) {// 是微信浏览器
			if (ignoreWechatParamName == null || ignoreWechatParamName.trim().length() == 0) {
				return true;
			}

			String ignore_wechat = request.getParameter(ignoreWechatParamName);
			if (ignore_wechat != null && ignore_wechat.equals("1")) {
				return false;
			}
			return true;
		}else{
			return false;
		}
	}


	//取浏览器中存取的用户信息cookie
	public static User getUserFromCookie(HttpServletRequest request) throws UnsupportedEncodingException, NoSuchAlgorithmException {
		request.setCharacterEncoding("utf-8");
		Cookie[] cookies = request.getCookies();
		User userEntity=null;
		String userCookie=null;
		String userHiddenCookie=null;
		Integer versionCookie=null;
		if(cookies!=null){
			for (Cookie cookie : cookies) {
				//明文用户信息cookie
				if (WCurrentUserUtil.COOKIE_USERINFO_KEY.equals(cookie.getName())) {
					userCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
				}
				//密文用户信息cookie
				if(WCurrentUserUtil.COOKIE_USERINFO_TOKEN_KEY.equals(cookie.getName())) {
					userHiddenCookie= URLDecoder.decode(cookie.getValue(), "UTF-8");
				}
				//版本号
				if(WCurrentUserUtil.COOKIE_VERSION_KEY.equals(cookie.getName())){
					versionCookie= Integer.valueOf(cookie.getValue());
				}
			}
		}
		if(userCookie!=null){
			String userCookieStr = String.valueOf(userCookie);
			String tokenOri = userCookieStr + WCurrentUserUtil.COOKIEPK;
			String token = MD5UtilNew.getMD5String(tokenOri);
			if(token.equals(userHiddenCookie)&&versionCookie==WCurrentUserUtil.COOKIE_VERSION){
				JSONObject json=JSONObject.fromObject(userCookieStr);
				userEntity=WCurrentUserUtil.getPackagingUserCookie(json);
			}
		}
		return userEntity;
	}

	//取浏览器中存取的微信用户信息cookie
	public static WechatUserInfo getWechatUserInfoFromCookie(HttpServletRequest request) throws UnsupportedEncodingException, NoSuchAlgorithmException {
		request.setCharacterEncoding("utf-8");
		Cookie[] cookies = request.getCookies();
		WechatUserInfo userEntity=null;
		String weixinCookie=null;
		String userHiddenCookie=null;
		if(cookies!=null){
			for (Cookie cookie : cookies) {
				//微信用户信息cookie
				if(WCurrentUserUtil.COOKIE_WEIXIN_USERINFO_KEY.equals(cookie.getName())){
					weixinCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
				}
				//密文用户信息cookie
				if(WCurrentUserUtil.COOKIE_USERINFO_WEIXIN_TOKEN_KEY.equals(cookie.getName())) {
					userHiddenCookie= URLDecoder.decode(cookie.getValue(), "UTF-8");
				}
			}
		}
		if(weixinCookie!=null){
			String userCookieStr = String.valueOf(weixinCookie);
			String tokenOri = userCookieStr + WCurrentUserUtil.COOKIEPK;
			String token = MD5UtilNew.getMD5String(tokenOri);
			if(token.equals(userHiddenCookie)){
				JSONObject u = JSONObject.fromObject(weixinCookie);
				userEntity = (WechatUserInfo) JSONObject.toBean(u, WechatUserInfo.class);
			}
		}
		return userEntity;
	}

	public static void getWeiXinCode(HttpServletRequest request, HttpServletResponse response){

	}
}
