/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.bean.GetUserObjectTypeInterface;
import com.cxqm.xiaoerke.common.utils.EmojiFilter;
import com.cxqm.xiaoerke.common.utils.MD5UtilNew;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;

public class WCurrentUserUtil {
    public static String COOKIEPK = "X1+n3$]`N8~/";
    public static String COOKIE_USERINFO_KEY = "haoyun_userInfo";
    public static String COOKIE_VERSION_KEY = "haoyun_version";
    public static String COOKIE_WEIXIN_USERINFO_KEY = "haoyun_weixin_userInfo";
    public static Integer COOKIE_VERSION = 4;
    public static String COOKIE_VERSION_WEIXIN_KEY = "haoyun_weixin_version";
    public static String COOKIE_USERINFO_WEIXIN_TOKEN_KEY = "haoyun_userInfo_weixin_token";
    public static Integer COOKIE_WEIXIN_VERSION = 1;
    public static String COOKIE_USERINFO_TOKEN_KEY = "haoyun_userInfo_token";
    public static final String COOKIE_USERINFO_HEAD_URL_KEY = "haoyun_userInfo_head_url";

    public static void clearUserInfoCookie(HttpServletRequest request, HttpServletResponse response) {
        WCurrentUserUtil.clearUserInfoCookie(COOKIE_USERINFO_KEY, COOKIE_USERINFO_TOKEN_KEY, COOKIE_VERSION_KEY, request, response);
    }

    public static void clearUserInfoCookie(String userKey, String userTokenKey, String versionKey, HttpServletRequest request, HttpServletResponse response) {
        String s = request.getServerName();
        String[] domainArr = s.split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*") ? request.getServerName() : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        WCurrentUserUtil.coverCookieByKey(userKey, doamin, response);
        WCurrentUserUtil.coverCookieByKey(userTokenKey, doamin, response);
        WCurrentUserUtil.coverCookieByKey(versionKey, doamin, response);
    }

    public static void clearWeinXinUserInfoCookie(HttpServletRequest request, HttpServletResponse response) {
        WCurrentUserUtil.clearWeinXinUserInfoCookie(request, response, COOKIE_WEIXIN_USERINFO_KEY);
    }

    public static void clearWeinXinUserInfoCookie(HttpServletRequest request, HttpServletResponse response, String key) {
        String s = request.getServerName();
        String[] domainArr = s.split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*") ? request.getServerName() : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        WCurrentUserUtil.coverCookieByKey(key, doamin, response);
    }

    public static boolean setCurrentUser(User user, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        return WCurrentUserUtil.setCurrentUser(user, null, COOKIE_USERINFO_KEY, COOKIEPK, COOKIE_USERINFO_TOKEN_KEY, COOKIE_VERSION_KEY, COOKIE_VERSION, request, response);
    }

    public static <T> boolean setCurrentUser(T t, GetUserObjectTypeInterface userInterface, String userKey, String userTokenPK, String userTokenKey, String versionKey, Integer versionValue, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        String[] domainArr = request.getServerName().split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*") ? request.getServerName() : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        JSONObject userCookie = null;
        try {
            userCookie = WCurrentUserUtil.packagingUserCookie(t, false);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        WCurrentUserUtil.saveCookieByKey(userKey, doamin, userCookie, response);
        String userCookieStr = String.valueOf(userCookie);
        String tokenOri = userCookieStr + userTokenPK;
        String token = MD5UtilNew.getMD5String(tokenOri);
        WCurrentUserUtil.saveCookieByKey(userTokenKey, doamin, token, response);
        WCurrentUserUtil.saveCookieByKey(versionKey, doamin, versionValue, response);
        return false;
    }

    public static boolean setCurrentWeixinUser(WechatUserInfo user, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        WCurrentUserUtil.setCurrentWeixinUser(user, COOKIE_WEIXIN_USERINFO_KEY, COOKIEPK, COOKIE_USERINFO_WEIXIN_TOKEN_KEY, COOKIE_VERSION_WEIXIN_KEY, COOKIE_WEIXIN_VERSION, request, response);
        return true;
    }

    public static boolean setCurrentWeixinUser(WechatUserInfo user, String userKey, String userPKKey, String userTokenKey, String versionKey, Integer versionValue, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        String[] domainArr = request.getServerName().split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 ? domainArr[0] : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        ObjectMapper mapper = new ObjectMapper();
        user.setNickname(EmojiFilter.coverEmoji(user.getNickname()));
        String userCookie = mapper.writeValueAsString((Object)user);
        WCurrentUserUtil.saveCookieByKey(userKey, doamin, userCookie, response);
        String userCookieStr = String.valueOf(userCookie);
        String tokenOri = userCookieStr + userPKKey;
        String token = MD5UtilNew.getMD5String(tokenOri);
        WCurrentUserUtil.saveCookieByKey(userTokenKey, doamin, token, response);
        WCurrentUserUtil.saveCookieByKey(versionKey, doamin, versionValue, response);
        return true;
    }

    private <T> JSONObject packagingUserCookie(T t, GetUserObjectTypeInterface userInterface) {
        if (userInterface == null) {
            try {
                return WCurrentUserUtil.packagingUserCookie(t, false);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return userInterface.getUserJsonObject(t);
    }

    private static void coverCookieByKey(String key, String doamin, HttpServletResponse response) {
        Cookie cookie = new Cookie(key, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
    }

    private static void saveCookieByKey(String key, String doamin, Object value, HttpServletResponse response) throws UnsupportedEncodingException {
        Cookie cookie = new Cookie(key, URLEncoder.encode(String.valueOf(value), "UTF-8"));
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
    }

    public static <T> T getPackagingUserCookie(JSONObject jsonObject, Class<T> t) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        T userEntity = t.newInstance();
        WCurrentUserUtil.setField("id", jsonObject, userEntity);
        WCurrentUserUtil.setField("mobile", jsonObject, userEntity);
        WCurrentUserUtil.setField("name", jsonObject, userEntity);
        WCurrentUserUtil.setField("photo", jsonObject, userEntity);
        WCurrentUserUtil.setField("buckter", jsonObject, userEntity);
        WCurrentUserUtil.setField("userType", jsonObject, userEntity);
        return userEntity;
    }

    private static <T> void setField(String key, JSONObject jsonObject, T t) {
        try {
            Class<?> curClass = t.getClass();
            Field field = null;
            for (Class<?> clazz = curClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(key);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (field != null) {
                field.setAccessible(true);
                field.set(t, (String)jsonObject.get(key));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static <T> Field getFieldByKey(T t, String key) {
        try {
            Class<?> curClass = t.getClass();
            Field field = null;
            for (Class<?> clazz = curClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(key);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (field != null) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> JSONObject packagingUserCookie(T t, boolean isSuperPwd) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        T userEntity = t;
        Field idField = WCurrentUserUtil.getFieldByKey(userEntity, "id");
        Field mobileField = WCurrentUserUtil.getFieldByKey(userEntity, "mobile");
        Field nameField = WCurrentUserUtil.getFieldByKey(userEntity, "name");
        Field photoField = WCurrentUserUtil.getFieldByKey(userEntity, "photo");
        Field buckterField = WCurrentUserUtil.getFieldByKey(userEntity, "buckter");
        Field headerField = WCurrentUserUtil.getFieldByKey(userEntity, "header");
        Field userTypeField = WCurrentUserUtil.getFieldByKey(userEntity, "userType");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"id", idField == null ? null : idField.get(userEntity));
        jsonObject.put((Object)"mobile", mobileField == null ? null : mobileField.get(userEntity));
        jsonObject.put((Object)"name", nameField == null ? null : nameField.get(userEntity));
        jsonObject.put((Object)"photo", photoField == null ? null : photoField.get(userEntity));
        jsonObject.put((Object)"buckter", buckterField == null ? null : buckterField.get(userEntity));
        jsonObject.put((Object)"header", headerField == null ? null : headerField.get(userEntity) + "-dmax232");
        jsonObject.put((Object)"userType", userTypeField == null ? null : userTypeField.get(userEntity));
        if (isSuperPwd) {
            jsonObject.put((Object)"isSuperPwd", (Object)"1");
        }
        return jsonObject;
    }

    public static JSONObject packagingUserCookie(User user) {
        try {
            return WCurrentUserUtil.packagingUserCookie(user, false);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map stringToMap(String singInfo) {
        String[] resArray;
        String str1 = singInfo.replaceAll("\\{|\\}", "");
        String str2 = str1.replaceAll(" ", "");
        String str3 = str2.replaceAll(",", "&");
        HashMap<String, String> map = null;
        if (null != str3 && !"".equals(str3.trim()) && 0 != (resArray = str3.split("&")).length) {
            map = new HashMap<String, String>(resArray.length);
            for (String arrayStr : resArray) {
                int index;
                if (null == arrayStr || "".equals(arrayStr.trim()) || -1 == (index = arrayStr.indexOf("="))) continue;
                map.put(arrayStr.substring(0, index), arrayStr.substring(index + 1));
            }
        }
        return map;
    }

    public static String MD5UserToken(String user) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        if (user == null || user.equals("") || user.equals("null")) {
            return "";
        }
        return WCurrentUserUtil.MD5UserToken(user, COOKIEPK);
    }

    public static String MD5UserToken(String obj, String PK) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        if (obj == null || obj.equals("") || obj.equals("null")) {
            return "";
        }
        String tokenOri = obj + PK;
        String token = MD5UtilNew.getMD5String(tokenOri);
        return URLEncoder.encode(token, "UTF-8");
    }

    public static String MD5WeiXinUserToken(String wechatUserInfo) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        if (wechatUserInfo == null || wechatUserInfo.equals("") || wechatUserInfo.equals("null")) {
            return "";
        }
        String tokenOri = wechatUserInfo + COOKIEPK;
        String token = MD5UtilNew.getMD5String(tokenOri);
        return URLEncoder.encode(token, "UTF-8");
    }

    public static boolean isSuperPwd(HttpServletRequest request) {
        String userCookieStr;
        String tokenOri;
        String token;
        try {
            request.setCharacterEncoding("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Cookie[] cookies = request.getCookies();
        Object userEntity = null;
        String userCookie = null;
        String userHiddenCookie = null;
        Integer versionCookie = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (COOKIE_USERINFO_KEY.equals(cookie.getName())) {
                    try {
                        userCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (COOKIE_USERINFO_TOKEN_KEY.equals(cookie.getName())) {
                    try {
                        userHiddenCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (!COOKIE_VERSION_KEY.equals(cookie.getName())) continue;
                versionCookie = Integer.valueOf(cookie.getValue());
            }
        }
        if (userCookie != null && (token = MD5UtilNew.getMD5String(tokenOri = (userCookieStr = String.valueOf(userCookie)) + COOKIEPK)).equals(userHiddenCookie) && versionCookie == COOKIE_VERSION) {
            JSONObject json = JSONObject.fromObject((Object)userCookieStr);
            if (!json.has("isSuperPwd")) {
                return false;
            }
            String isSuperPwd = json.getString("isSuperPwd");
            return isSuperPwd != null && isSuperPwd.equals("1");
        }
        return false;
    }
}

