package com.cxqm.xiaoerke.modules.sys.beans;

import com.cxqm.xiaoerke.common.bean.WechatTemplateItem;
import com.cxqm.xiaoerke.common.bean.WechatTemplateMsg;
import com.cxqm.xiaoerke.common.config.Global;

import java.io.Serializable;

/**
 * Created by sunzsh on 2017/4/12.
 * 用到微信推送队列时，每个模版消息需要新建一个类来继承此类，并在.properties里面维护模版id和模版内容
 */
public abstract class WechatMsg implements Serializable{

	private String userId;

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public WechatMsg(String openid, String url, String userId) {
		this.openid = openid;
		this.url = url;
		this.userId = userId;
	}

	public WechatMsg(String openid, String url) {
		this.openid = openid;
		this.url = url;
	}

	public WechatMsg(String openid) {
		this.openid = openid;
	}

	public WechatMsg() {
	}


	private static String replaceTemplate(String content, WechatTemplateItem item, String tempReg) {
		if (content == null) {
			return content;
		}
		if (tempReg == null || tempReg.trim().length() == 0) {
			return content;
		}
		return content.replaceAll(tempReg, (item == null || item.getText()==null)?"":item.getText());
	}

	public abstract String getTemplateId();

	public String getContent() {
		String template = Global.getConfig("wechatMsg-" + this.getClass().getSimpleName() + "-content");
		if (template == null || template.trim().length() == 0) {
			return null;
		}
		if (getFirst() != null && getFirst().getText() != null) {

		}
		String content = replaceTemplate(template, getFirst(), "\\{\\{first\\.DATA\\}\\}");
		content = replaceTemplate(content, getKeyword1(), "\\{\\{keyword1\\.DATA\\}\\}");
		content = replaceTemplate(content, getKeyword2(), "\\{\\{keyword2\\.DATA\\}\\}");
		content = replaceTemplate(content, getKeyword3(), "\\{\\{keyword3\\.DATA\\}\\}");
		content = replaceTemplate(content, getKeyword4(), "\\{\\{keyword4\\.DATA\\}\\}");
		content = replaceTemplate(content, getRemark(), "\\{\\{remark\\.DATA\\}\\}");

		return content;
	}

	private static final long serialVersionUID = 8480095405674556162L;

	private WechatTemplateItem first;
	private WechatTemplateItem keyword1;
	private WechatTemplateItem keyword2;
	private WechatTemplateItem keyword3;
	private WechatTemplateItem keyword4;
	private WechatTemplateItem remark;
	private String url;
	private String openid;
	private String modelId;
	private String token;

	public void setFirstText(String first) {
		if (this.first == null) {
			this.first = new WechatTemplateItem(first);
		} else {
			this.first.setText(first);
		}
	}

	public void setFirstColor(String color) {
		if (this.first == null) {
			this.first = new WechatTemplateItem();
		}
		this.first.setColor(color);
	}

	public void setKeyword1Text(String keyword1) {
		if (this.keyword1 == null) {
			this.keyword1 = new WechatTemplateItem(keyword1);
		} else {
			this.keyword1.setText(keyword1);
		}
	}

	public void setKeyword1Color(String color) {
		if (this.keyword1 == null) {
			this.keyword1 = new WechatTemplateItem();
		}
		this.keyword1.setColor(color);
	}


	public void setKeyword2Text(String keyword2) {
		if (this.keyword2 == null) {
			this.keyword2 = new WechatTemplateItem(keyword2);
		} else {
			this.keyword2.setText(keyword2);
		}
	}

	public void setKeyword2Color(String color) {
		if (this.keyword2 == null) {
			this.keyword2 = new WechatTemplateItem();
		}
		this.keyword2.setColor(color);
	}


	public void setKeyword3Text(String keyword3) {
		if (this.keyword3 == null) {
			this.keyword3 = new WechatTemplateItem(keyword3);
		} else {
			this.keyword3.setText(keyword3);
		}
	}

	public void setKeyword3Color(String color) {
		if (this.keyword3 == null) {
			this.keyword3 = new WechatTemplateItem();
		}
		this.keyword3.setColor(color);
	}


	public void setKeyword4Text(String keyword4) {
		if (this.keyword4 == null) {
			this.keyword4 = new WechatTemplateItem(keyword4);
		} else {
			this.keyword4.setText(keyword4);
		}
	}

	public void setKeyword4Color(String color) {
		if (this.keyword4 == null) {
			this.keyword4 = new WechatTemplateItem();
		}
		this.keyword4.setColor(color);
	}


	public void setRemarkText(String remark) {
		if (this.remark == null) {
			this.remark = new WechatTemplateItem(remark);
		} else {
			this.remark.setText(remark);
		}
	}

	public void setRemarkColor(String color) {
		if (this.remark == null) {
			this.remark = new WechatTemplateItem();
		}
		this.remark.setColor(color);
	}



	public WechatTemplateItem getFirst() {
		return first;
	}

	public void setFirst(WechatTemplateItem first) {
		this.first = first;
	}

	public WechatTemplateItem getKeyword1() {
		return keyword1;
	}

	public void setKeyword1(WechatTemplateItem keyword1) {
		this.keyword1 = keyword1;
	}

	public WechatTemplateItem getKeyword2() {
		return keyword2;
	}

	public void setKeyword2(WechatTemplateItem keyword2) {
		this.keyword2 = keyword2;
	}

	public WechatTemplateItem getKeyword3() {
		return keyword3;
	}

	public void setKeyword3(WechatTemplateItem keyword3) {
		this.keyword3 = keyword3;
	}

	public WechatTemplateItem getKeyword4() {
		return keyword4;
	}

	public void setKeyword4(WechatTemplateItem keyword4) {
		this.keyword4 = keyword4;
	}

	public WechatTemplateItem getRemark() {
		return remark;
	}

	public void setRemark(WechatTemplateItem remark) {
		this.remark = remark;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getModelId() {
		return modelId;
	}

	public void setModelId(String modelId) {
		this.modelId = modelId;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}
}
