package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.bean.DownedResource;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

import javax.net.ssl.SSLContext;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

/**
 * Created by sunzb on 16/12/26.
 */
public class DownLoadUtil {

	public static DownedResource down(String url) {
		HttpClient httpClient = new HttpClient();
		GetMethod httpGet = new GetMethod(url);
		byte[] ba;
		String contentType;
		try {
			if (httpClient.executeMethod(httpGet) != HttpStatus.SC_OK) {
				return null;
			}
			Header header = httpGet.getResponseHeader("Content-Type");

			contentType = header == null ? null : header.getValue();
			System.out.println(contentType);
			ba = httpGet.getResponseBody();
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}


		DownedResource resource = new DownedResource();
		resource.setInputStrem(new ByteArrayInputStream(ba));
		String fileName = getFileNameByUrl(url);
		resource.setContentType(contentType);
		resource.setFileName(fileName);
		resource.fillExt();
		resource.setLength(ba.length);

		return resource;
	}

	public static String getFileNameByUrl(String urlStr) {
		URL url = null;
		try {
			url = new URL(urlStr);
		} catch (MalformedURLException e) {
			e.printStackTrace();
			return null;
		}
		String path = url.getPath();
		int index = path.lastIndexOf('/');
		if (index < 0) {
			return null;
		}

		return path.substring(index + 1);
	}


//	public static void main(String[] args) throws MalformedURLException {
//
//		String urlStr = "https://ss0.bdstatic.com/5aV1bjqh_Q23odCf/static/superman/img/logo/bd_logo1_31bdc765.png?aa=234";
////		String urlStr = "http://img4.duitang.com/uploads/item/201512/01/20151201144857_LieWC.thumb.700_0.jpeg?a=32";
//		DownedResource res = down(urlStr);
//
//
//		String test = OSSObjectTool.uploadFileInputStream(IdGen.randomBase62(32) + "." + res.getExt(), new Long(res.getLength()), res.getInputStrem(), "junhaoyun");
//
//		System.out.println(test);
//	}

}
