/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.utils.EmojiFilter;
import com.cxqm.xiaoerke.common.utils.MD5UtilNew;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;

public class WCurrentUserUtil {
    public static String COOKIEPK = "X1+n3$]`N8~/";
    public static String COOKIE_USERINFO_KEY = "haoyun_userInfo";
    public static String COOKIE_VERSION_KEY = "haoyun_version";
    public static String COOKIE_WEIXIN_USERINFO_KEY = "haoyun_weixin_userInfo";
    public static Integer COOKIE_VERSION = 4;
    public static String COOKIE_VERSION_WEIXIN_KEY = "haoyun_weixin_version";
    public static String COOKIE_USERINFO_WEIXIN_TOKEN_KEY = "haoyun_userInfo_weixin_token";
    public static Integer COOKIE_WEIXIN_VERSION = 1;
    public static String COOKIE_USERINFO_TOKEN_KEY = "haoyun_userInfo_token";
    public static final String COOKIE_USERINFO_HEAD_URL_KEY = "haoyun_userInfo_head_url";

    public static void clearUserInfoCookie(HttpServletRequest request, HttpServletResponse response) {
        String s = request.getServerName();
        String[] domainArr = s.split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*") ? request.getServerName() : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        Cookie cookie = new Cookie(COOKIE_USERINFO_KEY, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
        cookie = new Cookie(COOKIE_USERINFO_TOKEN_KEY, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
        cookie = new Cookie(COOKIE_VERSION_KEY, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
    }

    public static boolean setCurrentUser(User user, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        String[] domainArr = request.getServerName().split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*") ? request.getServerName() : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        JSONObject userCookie = WCurrentUserUtil.packagingUserCookie(user);
        Cookie cookie = new Cookie(COOKIE_USERINFO_KEY, URLEncoder.encode(String.valueOf(userCookie), "UTF-8"));
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
        String userCookieStr = String.valueOf(userCookie);
        String tokenOri = userCookieStr + COOKIEPK;
        String token = MD5UtilNew.getMD5String(tokenOri);
        Cookie cookieToken = new Cookie(COOKIE_USERINFO_TOKEN_KEY, token);
        cookieToken.setMaxAge(Integer.MAX_VALUE);
        cookieToken.setPath("/");
        cookieToken.setDomain(doamin);
        response.addCookie(cookieToken);
        Cookie cookieVersion = new Cookie(COOKIE_VERSION_KEY, COOKIE_VERSION.toString());
        cookieVersion.setMaxAge(Integer.MAX_VALUE);
        cookieVersion.setPath("/");
        cookieVersion.setDomain(doamin);
        response.addCookie(cookieVersion);
        return true;
    }

    public static void clearWeinXinUserInfoCookie(HttpServletRequest request, HttpServletResponse response) {
        String s = request.getServerName();
        String[] domainArr = s.split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*") ? request.getServerName() : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        Cookie cookie = new Cookie(COOKIE_WEIXIN_USERINFO_KEY, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
    }

    public static JSONObject packagingUserCookie(User user, boolean isSuperPwd) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"id", (Object)user.getId());
        jsonObject.put((Object)"mobile", (Object)user.getMobile());
        jsonObject.put((Object)"name", (Object)user.getName());
        jsonObject.put((Object)"photo", (Object)user.getPhoto());
        jsonObject.put((Object)"buckter", (Object)user.getBuckter());
        jsonObject.put((Object)"header", (Object)(user.getFullPhoto() == null ? "" : user.getFullPhoto() + "-dmax232"));
        jsonObject.put((Object)"userType", (Object)user.getUserType());
        if (isSuperPwd) {
            jsonObject.put((Object)"isSuperPwd", (Object)"1");
        }
        return jsonObject;
    }

    public static JSONObject packagingUserCookie(User user) {
        return WCurrentUserUtil.packagingUserCookie(user, false);
    }

    public static User getPackagingUserCookie(JSONObject jsonObject) {
        User userEntity = new User();
        userEntity.setId((String)jsonObject.get("id"));
        userEntity.setMobile((String)jsonObject.get("mobile"));
        userEntity.setName((String)jsonObject.get("name"));
        userEntity.setPhoto((String)jsonObject.get("photo"));
        userEntity.setBuckter((String)jsonObject.get("buckter"));
        userEntity.setUserType((String)jsonObject.get("userType"));
        return userEntity;
    }

    public static Map stringToMap(String singInfo) {
        String[] resArray;
        String str1 = singInfo.replaceAll("\\{|\\}", "");
        String str2 = str1.replaceAll(" ", "");
        String str3 = str2.replaceAll(",", "&");
        HashMap<String, String> map = null;
        if (null != str3 && !"".equals(str3.trim()) && 0 != (resArray = str3.split("&")).length) {
            map = new HashMap<String, String>(resArray.length);
            for (String arrayStr : resArray) {
                int index;
                if (null == arrayStr || "".equals(arrayStr.trim()) || -1 == (index = arrayStr.indexOf("="))) continue;
                map.put(arrayStr.substring(0, index), arrayStr.substring(index + 1));
            }
        }
        return map;
    }

    public static boolean setCurrentWeixinUser(WechatUserInfo user, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        String[] domainArr = request.getServerName().split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 ? domainArr[0] : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        ObjectMapper mapper = new ObjectMapper();
        user.setNickname(EmojiFilter.coverEmoji(user.getNickname()));
        String userCookie = mapper.writeValueAsString((Object)user);
        Cookie cookie = new Cookie(COOKIE_WEIXIN_USERINFO_KEY, URLEncoder.encode(userCookie, "UTF-8"));
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
        String userCookieStr = String.valueOf(userCookie);
        String tokenOri = userCookieStr + COOKIEPK;
        String token = MD5UtilNew.getMD5String(tokenOri);
        Cookie cookieToken = new Cookie(COOKIE_USERINFO_WEIXIN_TOKEN_KEY, URLEncoder.encode(token, "UTF-8"));
        cookieToken.setMaxAge(Integer.MAX_VALUE);
        cookieToken.setPath("/");
        cookieToken.setDomain(doamin);
        response.addCookie(cookieToken);
        Cookie cookieVersion = new Cookie(COOKIE_VERSION_WEIXIN_KEY, COOKIE_WEIXIN_VERSION.toString());
        cookieVersion.setMaxAge(Integer.MAX_VALUE);
        cookieVersion.setPath("/");
        cookieVersion.setDomain(doamin);
        response.addCookie(cookieVersion);
        return true;
    }

    public static String MD5UserToken(String user) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        if (user == null || user.equals("") || user.equals("null")) {
            return "";
        }
        String tokenOri = user + COOKIEPK;
        String token = MD5UtilNew.getMD5String(tokenOri);
        return URLEncoder.encode(token, "UTF-8");
    }

    public static String MD5WeiXinUserToken(String wechatUserInfo) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        if (wechatUserInfo == null || wechatUserInfo.equals("") || wechatUserInfo.equals("null")) {
            return "";
        }
        String tokenOri = wechatUserInfo + COOKIEPK;
        String token = MD5UtilNew.getMD5String(tokenOri);
        return URLEncoder.encode(token, "UTF-8");
    }

    public static boolean isSuperPwd(HttpServletRequest request) {
        String userCookieStr;
        String tokenOri;
        String token;
        try {
            request.setCharacterEncoding("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Cookie[] cookies = request.getCookies();
        Object userEntity = null;
        String userCookie = null;
        String userHiddenCookie = null;
        Integer versionCookie = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (COOKIE_USERINFO_KEY.equals(cookie.getName())) {
                    try {
                        userCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (COOKIE_USERINFO_TOKEN_KEY.equals(cookie.getName())) {
                    try {
                        userHiddenCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (!COOKIE_VERSION_KEY.equals(cookie.getName())) continue;
                versionCookie = Integer.valueOf(cookie.getValue());
            }
        }
        if (userCookie != null && (token = MD5UtilNew.getMD5String(tokenOri = (userCookieStr = String.valueOf(userCookie)) + COOKIEPK)).equals(userHiddenCookie) && versionCookie == COOKIE_VERSION) {
            JSONObject json = JSONObject.fromObject((Object)userCookieStr);
            if (!json.has("isSuperPwd")) {
                return false;
            }
            String isSuperPwd = json.getString("isSuperPwd");
            return isSuperPwd != null && isSuperPwd.equals("1");
        }
        return false;
    }
}

