package com.cxqm.xiaoerke.common.mobile;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class JMMessageInvoker {

	Logger logger = LoggerFactory.getLogger("mobileMsg");

	public static void main(String[] args) {
		JMMessageInvoker msg = new JMMessageInvoker("1445", "Hj57450yl");
		String s = msg.sendSMS("18910574500", "【好孕助手】尊敬的客户，非常抱歉的通知您：您的检查检验结果不符合祝孕试管婴儿医疗保险（A款）的投保条件。有任何问题，您可通过好孕助手在线客服或者锦江生殖祝孕咨询顾问进行咨询，或者拨打电话4009608028。祝您好运！退订回T", "2");
		System.out.println(s);
	}

	public String get_uc() {
		return _uc;
	}

	public void set_uc(String _uc) {
		this._uc = _uc;
	}

	public void set_pwd(String _pwd) {
		this._pwd = _pwd;
	}

	public JMMessageInvoker() {

	}

	public JMMessageInvoker(String uc, String pwd) {
		this._uc = uc;
		this._pwd = pwd;


	}
	String _uc,_pwd; //帐号，密码
	String _host="http://sms.53api.com/sdk/SMS?";
	public String get_pwd() {
		return this.MD5Encode(_pwd);
	}


	public String sendSMS(String mobiles, String cont) {
		int id = new Random(new Date().getTime()).nextInt(99999);
		return sendSMS(mobiles, cont, id+"");
	}

	/**
	 *发送短信
	 * @param mobiles String 接收号码
	 * @param cont String 短信内容
	 * @param msgid String 短信ID
	 * @return String
	 */
	public String sendSMS(String mobiles, String cont, String msgid) {
		int i = new Random(new Date().getTime()).nextInt(99999);
		DecimalFormat df = new DecimalFormat("00000");
		String no = df.format(i);// 用于区分日志信息

		logger.info(String.format("(%s)%s|%s|%s", no, mobiles, cont, msgid));
		String re = "";
		try {
			cont = URLEncoder.encode(cont, "GBK"); //短信内容需要编码
			String sendUrl =
					_host+ "cmd=send&uid=" +
							_uc + "&psw=" + this.get_pwd() + "&mobiles=" + mobiles + "&msgid=" +
							msgid + "&msg=" + cont + " ";
			re = submit(sendUrl);
		} catch (Exception ex) {
			ex.printStackTrace();
			logger.info(String.format("发送失败：(%s)%s", no, ex.getMessage()));
		}

		logger.info(String.format("(%s)%s|%s|%s", no, mobiles, cont, msgid));
		logger.info(String.format("(%s)发送结果：%s", no, re));
		return re;
	}

	/**
	 * 接收短信
	 * @return String
	 */
	public String getMO() {
		String re = "";
		try{
			String moUrl =
					_host+"cmd=getmo&uid=" +
							_uc + "&psw=" + this.get_pwd() + "";
			re = submit(moUrl);
		}catch(Exception ex)
		{

		}
		return re;
	}
	/**
	 * 取发送状态
	 * @return String
	 */
	public String getStatus(){
		String re="";
		String getstatusUrl =_host+"cmd=getstatus&uid=" +_uc + "&psw=" + this.get_pwd() + "";
		re = submit(getstatusUrl);
		return re;
	}


	/**
	 * GET提交
	 * @param strURL String
	 * @return String
	 */
	private String submit(String strURL) {
		String re = "";

		HttpURLConnection urlConn = null;
		InputStream in = null;
		List<String> list = new ArrayList<>();
		try
		{
			URL url = new URL(strURL);
			urlConn = (HttpURLConnection) url.openConnection();
			urlConn.setDoOutput(true);
			urlConn.setConnectTimeout(3000);
			urlConn.setRequestMethod("GET");
			urlConn.getOutputStream().flush();
			urlConn.getOutputStream().close();
			in = urlConn.getInputStream();
			BufferedReader rd = new BufferedReader(new InputStreamReader(in, "GBK"));
			String line = rd.readLine();

			while (line != null)
			{
				line = line.trim();
				if (!line.equals(""))
					list.add(line);
				line = rd.readLine();
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (in != null)
				try
				{
					in.close();
				}
				catch (IOException e)
				{
				}

			if (urlConn != null)
			{
				urlConn.disconnect();
			}
		}

		if (list != null)
		{
			if(list.size()==1)
			{
				re += list.get(0);
			}
			else if(list.size() > 1)
			{
				for (int i = 0; i < list.size(); i++)
				{
					re += list.get(i);
				}
			}
		}

		return re.trim();
	}
	/**
	 * MD5加密
	 * @param origin
	 * @return
	 */
	private String MD5Encode(String origin) {
		String resultString = null;
		try {
			resultString = new String(origin);
			MessageDigest md = MessageDigest.getInstance("MD5");
			resultString = byteArrayToHexString(md.digest(resultString.getBytes()));
		} catch (Exception ex) {

		}
		return resultString;
	}

	private String byteToHexString(byte b) {
		int n = b;
		if (n < 0) {
			n = 256 + n;
		}
		int d1 = n / 16;
		int d2 = n % 16;
		return hexDigits[d1] + hexDigits[d2];
	}

	public String byteArrayToHexString(byte[] b) {
		StringBuffer resultSb = new StringBuffer();
		for (int i = 0; i < b.length; i++) {
			resultSb.append(byteToHexString(b[i]));
		}
		return resultSb.toString();
	}






	private final static String[] hexDigits = {
			"0", "1", "2", "3", "4", "5", "6",
			"7",
			"8", "9", "a", "b", "c", "d", "e",
			"f"};



}
