/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.common;

import com.zthzinfo.common.ClusterMethodLock;
import com.zthzinfo.common.RedisLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.StringRedisTemplate;

public class AOPClusterLockForMethod {
    public static final String PREFIX_KEY = "CLSTLOCK";
    @Autowired(required=false)
    StringRedisTemplate template;
    @Autowired
    private Environment env;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(com.zthzinfo.common.ClusterMethodLock)")
    public void clusterLockPointCut() {
    }

    private String getKey(ProceedingJoinPoint joinPoint, ClusterMethodLock methodLock) {
        if (methodLock.value() != null && methodLock.value().trim().length() > 0) {
            return String.format("%s_%s", PREFIX_KEY, methodLock.value());
        }
        return String.format("%s_%s.%s", PREFIX_KEY, joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName());
    }

    @Around(value="clusterLockPointCut() && @annotation(methodLock)")
    public void aroundExec(ProceedingJoinPoint joinPoint, ClusterMethodLock methodLock) throws Throwable {
        String key = this.getKey(joinPoint, methodLock);
        String enableStr = methodLock.enableStr();
        boolean enable = methodLock.enable();
        if (enableStr != null && enableStr.trim().length() != 0) {
            String property = enableStr;
            if (property.matches("\\$\\{.*\\}")) {
                property = this.env.getProperty(enableStr.replaceAll("\\s*\\$\\{\\s*", "").replaceAll("\\s*\\}", ""));
            }
            enable = property != null && !property.equals("0") && !property.trim().equalsIgnoreCase("false");
        }
        if (!enable) {
            this.logger.info(String.format("\u96c6\u7fa4\u73af\u5883\uff0c\u8be5\u65b9\u6cd5\u88ab\u7981\u7528[%s]", key));
            return;
        }
        if (this.template == null) {
            this.logger.info("\u672a\u914d\u7f6eRedisTemplate");
            return;
        }
        RedisLock lock = new RedisLock(this.template, key);
        try {
            if (!lock.lock()) {
                this.logger.info(String.format("\u96c6\u7fa4\u73af\u5883\uff0c\u8be5\u65b9\u6cd5\u5df2\u88ab\u5176\u4ed6\u8282\u70b9\u6267\u884c[%s]", key));
                return;
            }
            joinPoint.proceed();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
        finally {
            lock.unlock();
        }
    }
}

