package com.zthzinfo.common;

import java.util.*;
import java.util.function.Function;

public class BeanUtils {

	public static <T> boolean diff(T item1,  T item2, Function<T, Object>...functions) {
		if (functions == null || functions.length == 0) {
			return false;
		}
		for (Function<T, Object> f : functions) {
			Object value1 = f.apply(item1);
			Object value2 = f.apply(item2);

			boolean itemSame = Optional.ofNullable(value1)
					.equals(Optional.ofNullable(value2));
			if (itemSame == false) {
				return false;
			}
		}
		return true;
	}

	public static <T> Map<String, List<T>> convertListToMapList(List<T> list, Function<T, Object> getter) {
		Map<String, List<T>> result = new HashMap<>();

		if (list == null || list.size() == 0) {
			return result;
		}

		for (T t : list) {
			String key = Optional.ofNullable(getter.apply(t)).map(o -> o.toString()).orElse(null);
			List<T> ts = result.get(key);
			if (ts == null) {
				ts = new ArrayList<>();
				result.put(key, ts);
			}

			ts.add(t);
		}

		return result;
	}

	public static <T> Map<String, T> convertListToMap(List<T> list, Function<T, Object> getter) {
		Map<String, T> result = new HashMap<>();

		if (list == null || list.size() == 0) {
			return result;
		}

		for (T t : list) {
			String key = Optional.ofNullable(getter.apply(t)).map(o -> o.toString()).orElse(null);
			result.put(key, t);
		}

		return result;

	}

}
