package com.cxqm.xiaoerke.wechat.beans;

import com.cxqm.xiaoerke.common.bean.IErrorInfo;

/**
 * Created by yanghb on 17/8/29.
 */
public enum WechatErrors implements IErrorInfo {

	/**
	 * 超出临时二维码最长有效时间
	 */
	WECHAT_NOT_FOUND("ZTHZWECHAT0001", "未获取到公众号信息"),
	/**
	 * 超出临时二维码最长有效时间
	 */
	OVER_MAX_ACTIVE_TIME("ZTHZWECHAT0002", "超出临时二维码最长有效时间"),
	/**
	 * 从微信服务器获取二维码出现异常
	 */
	REQUEST_QRCODE_ERROR("ZTHZWECHAT0003", "从微信服务器获取二维码出现异常"),
	/**
	 * 保存二维码记录出现异常
	 */
	SAVE_QRCODE_ERROR("ZTHZWECHAT0004", "保存二维码记录出现异常"),
	/**
	 * 保存二维码记录出现异常
	 */
	GET_WECHAT_TOKEN_ERROR("ZTHZWECHAT0005", "获取access_token出现异常"),
	/**
	 * 获取wechat配置文件异常
	 */
	GET_WECHAT_ACCESSTOKEN_BEAN_ERROR("ZTHZWECHAT0006", "获取微信配置信息出现异常");

	private String code;
	private String desc;

	private WechatErrors(String code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	@Override
	public String getCode() {
		return this.code;
	}


	@Override
	public String getDesc() {
		return this.desc;
	}
}
