/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.event.listener;

import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDoctorManageOrder;
import com.cxqm.xiaoerke.modules.haoyun.entity.HySchemeDoctor;
import com.cxqm.xiaoerke.modules.haoyun.event.CreateManageOrderEvent;
import com.cxqm.xiaoerke.modules.haoyun.event.listener.PublicPush;
import com.cxqm.xiaoerke.modules.haoyun.service.HySchemeDoctorService;
import com.cxqm.xiaoerke.modules.sys.utils.TokenKeyUtil;
import com.cxqm.xiaoerke.modules.wechat.push.AngelWechatPushService;
import com.zthzinfo.delaytask.service.DelayTaskService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@Component
@EnableAsync
public class CreateManageOrderEventListener
extends PublicPush
implements ApplicationListener<CreateManageOrderEvent> {
    @Autowired
    DelayTaskService delayTaskService;
    @Autowired
    MongoDictionaryService mongoDictionaryService;
    @Autowired
    HySchemeDoctorService hySchemeDoctorService;
    @Autowired
    AngelWechatPushService angelWechatPushService;

    @Async
    public void onApplicationEvent(CreateManageOrderEvent createManageOrderEvent) {
        HyDoctorManageOrder order = (HyDoctorManageOrder)createManageOrderEvent.getSource();
        System.out.println("\u8ba2\u5355id=" + order.getId() + ";\u75c5\u7a0b\u7ba1\u7406\u8ba2\u5355\u521b\u5efa\u5b8c\u6210\uff0c\u5f00\u59cb\u6267\u884c\u521b\u5efa\u5b8c\u6210\u540e\u4efb\u52a1\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        try {
            this.delayTask(order);
        }
        catch (Exception e) {
            System.out.println("\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\u3002\u3002\u3002");
            e.printStackTrace();
        }
        try {
            this.pushMsgToDoctor(order);
        }
        catch (Exception e) {
            System.out.println("\u8ba2\u5355id=" + order.getId() + ";\u63a8\u9001\u6d88\u606f\u5230\u533b\u751f\u516c\u4f17\u53f7\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u3002\u3002");
            e.printStackTrace();
        }
        try {
            this.pushMsgToManager(order, this.mongoDictionaryService, this.angelWechatPushService);
        }
        catch (Exception e) {
            System.out.println("\u8ba2\u5355id=" + order.getId() + ";\u63a8\u9001\u6d88\u606f\u5230\u7ba1\u7406\u4eba\u5458\u516c\u4f17\u53f7\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u3002\u3002");
            e.printStackTrace();
        }
    }

    private void pushMsgToDoctor(HyDoctorManageOrder order) {
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("miniprogram", "doctor");
        MongoDictionary configs = this.mongoDictionaryService.queryDictionary("miniprogram_newmanageapply");
        HySchemeDoctor schemeDoctor = this.hySchemeDoctorService.querySchemeByDoctorUserIdAndSchemeId(order.getDoctorUserId(), order.getHySchemeId());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String templateId = Global.getConfig((String)"doctor_wechat_template_id");
        this.angelWechatPushService.pushByUserId(order.getDoctorUserId(), templateId, configs.getStr1(), mongoDictionary.getStr1(), configs.getStr2(), String.format(configs.getStr3(), order.getUserName_()), order.getUserName_(), formatter.format(new Date()), String.format(configs.getStr4(), schemeDoctor.getHyScheme().getTimeDescribe()), configs.getStr5(), TokenKeyUtil.doctor_key);
    }

    private void delayTask(HyDoctorManageOrder order) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderId", (Object)order.getId());
        this.delayTaskService.genQuartzTask("angel", "http://" + Global.getConfig((String)"baseUrl") + "/hy/usersidespweb/order/orderInvalid.do", jsonObject.toJSONString(), 604800000L);
    }
}

