/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.event.listener;

import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.common.utils.Base64Utils;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyDoctorManageChatlogMapper;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDoctorManageChatlog;
import com.cxqm.xiaoerke.modules.haoyun.event.ManageChatMsgEvent;
import com.cxqm.xiaoerke.modules.sys.utils.TokenKeyUtil;
import com.cxqm.xiaoerke.modules.wechat.push.AngelWechatPushService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@Component
@EnableAsync
public class SaveManageChatMsgListener
implements ApplicationListener<ManageChatMsgEvent> {
    @Autowired
    AngelWechatPushService angelWechatPushService;
    @Autowired
    MongoDictionaryService mongoDictionaryService;
    @Autowired
    HyDoctorManageChatlogMapper hyDoctorManageChatlogMapper;
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Async
    public void onApplicationEvent(ManageChatMsgEvent manageChatMsgEvent) {
        HyDoctorManageChatlog chatlog = (HyDoctorManageChatlog)manageChatMsgEvent.getSource();
        this.hyDoctorManageChatlogMapper.insertSelective(chatlog);
        if ("user".equals(chatlog.getToUserType())) {
            this.pushWxMsgToUser(chatlog);
        } else if ("doctor".equals(chatlog.getToUserType())) {
            this.pushWxMsgToDoctor(chatlog);
        }
    }

    private void pushWxMsgToUser(HyDoctorManageChatlog chatlog) {
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("miniprogram", "user");
        MongoDictionary configs = this.mongoDictionaryService.queryDictionary("miniprogram_gunalichat");
        String miniprogram_appid = mongoDictionary.getStr1();
        String openurl = configs.getStr4();
        String miniprogram_path = configs.getStr1();
        String index = mongoDictionary.getStr2();
        String jumpUrl = configs.getStr3();
        if (jumpUrl != null && jumpUrl.trim().length() > 0) {
            jumpUrl = String.format(jumpUrl, chatlog.getOrderId());
            jumpUrl = Base64Utils.encode((byte[])jumpUrl.getBytes());
            miniprogram_path = index + jumpUrl;
        }
        System.out.println("miniprogram_appid=========================" + miniprogram_appid);
        String templateId = Global.getConfig((String)"public_wechat_template_id");
        this.angelWechatPushService.pushByUserId(chatlog.getAcceptUserId(), templateId, openurl, miniprogram_appid, miniprogram_path, "\u60a8\u6536\u5230\u4e00\u6761\u6765\u81ea\u533b\u751f\u7684\u6d88\u606f", chatlog.getSendName() + " \u533b\u751f", this.formatter.format(new Date()), "\u60a3\u8005\u7ba1\u7406\u56de\u590d", chatlog.getMessage(), TokenKeyUtil.angel_key);
        System.out.println("\u63a8\u9001\u6d88\u606f\u5230\u60a3\u8005\u5fae\u4fe1\u53f7==========================\u53c2\u6570\uff1a" + chatlog.getMessage());
    }

    private void pushWxMsgToDoctor(HyDoctorManageChatlog chatlog) {
        System.out.println("\u63a8\u9001\u6d88\u606f\u5230\u533b\u751f\u5fae\u4fe1\u53f7==========================\u53c2\u6570\uff1a" + chatlog.toString());
        String templateId = Global.getConfig((String)"doctor_wechat_template_id");
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("miniprogram", "doctor");
        MongoDictionary configs = this.mongoDictionaryService.queryDictionary("miniprogram_gunalichat");
        String miniprogram_appid = mongoDictionary.getStr1();
        String index = mongoDictionary.getStr2();
        String miniprogram_path = "";
        String openurl = configs.getStr4();
        String jumpUrl = configs.getStr3();
        if (jumpUrl != null && jumpUrl.trim().length() > 0) {
            jumpUrl = String.format(jumpUrl, chatlog.getOrderId());
            jumpUrl = Base64Utils.encode((byte[])jumpUrl.getBytes());
            miniprogram_path = index + jumpUrl;
        }
        this.angelWechatPushService.pushByUserId(chatlog.getAcceptUserId(), templateId, openurl, miniprogram_appid, miniprogram_path, "\u60a8\u6536\u5230\u4e00\u6761\u6765\u81ea\u60a3\u8005\u7684\u6d88\u606f", chatlog.getSendName(), this.formatter.format(new Date()), "\u60a3\u8005\u7ba1\u7406\u56de\u590d", chatlog.getMessage(), TokenKeyUtil.doctor_key);
    }
}

