/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.event.listener;

import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.common.utils.Base64Utils;
import com.cxqm.xiaoerke.modules.consult.entity.Message;
import com.cxqm.xiaoerke.modules.consult.event.UnReadEvent;
import com.cxqm.xiaoerke.modules.haoyun.service.HyWechatPushService;
import com.cxqm.xiaoerke.modules.push.service.PushNetService;
import com.cxqm.xiaoerke.modules.sys.utils.TokenKeyUtil;
import com.cxqm.xiaoerke.modules.wechat.push.AngelWechatPushService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@Component
@EnableAsync
public class UnReadEventMessageListener
implements ApplicationListener<UnReadEvent> {
    @Autowired
    PushNetService pushNetService;
    @Autowired
    HyWechatPushService hyWechatPushService;
    @Autowired
    AngelWechatPushService angelWechatPushService;
    @Autowired
    MongoDictionaryService mongoDictionaryService;
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Async
    public void onApplicationEvent(UnReadEvent unReadEvent) {
        Message msg = (Message)unReadEvent.getSource();
        if ("user".equals(msg.getSendusertype())) {
            this.pushUserToDocter(msg);
        } else if ("doctor".equals(msg.getSendusertype())) {
            this.pushDocterToUser(msg);
        }
    }

    private void pushUserToDocter(Message msg) {
        System.out.println("\u63a8\u9001\u6d88\u606f\u5230\u533b\u751f\u7aefapp==========================" + msg.getMwebPath());
        try {
            HashMap<String, String> dictionary = new HashMap<String, String>();
            dictionary.put("openurl", msg.getMwebPath());
            this.pushNetService.push(msg.getUserId(), "ios", null, null, null, dictionary, msg.getPushcount(), "graphicconsult", msg.getSendname() + "\uff1a" + msg.getEscapeMsgImg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u63a8\u9001\u6d88\u606f\u5230\u533b\u751f\u5fae\u4fe1\u53f7==========================\u53c2\u6570\uff1a" + msg.toString());
        String templateId = Global.getConfig((String)"doctor_wechat_template_id");
        String miniprogram_appid = "";
        String miniprogram_path = "";
        String openurl = msg.getOpenurl();
        MongoDictionary pbys = this.mongoDictionaryService.queryDictionary("ymf_shield");
        boolean needOpenXcx = true;
        try {
            String[] doctor_id = pbys.getStr1().split(",");
            for (int i = 0; i < doctor_id.length; ++i) {
                if (!msg.getUserId().equals(doctor_id[i])) continue;
                needOpenXcx = false;
            }
        }
        catch (Exception doctor_id) {
            // empty catch block
        }
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("miniprogram", "doctor");
        miniprogram_appid = mongoDictionary.getStr1();
        MongoDictionary configs = this.mongoDictionaryService.queryDictionary("miniprogram_tuwen");
        String index = mongoDictionary.getStr2();
        String jumpUrl = configs.getStr3();
        if (configs.getStr4() != null) {
            openurl = configs.getStr4();
        }
        if (jumpUrl != null && jumpUrl.trim().length() > 0) {
            jumpUrl = String.format(jumpUrl, msg.getOrderid());
            jumpUrl = Base64Utils.encode((byte[])jumpUrl.getBytes());
            miniprogram_path = index + jumpUrl;
        }
        this.angelWechatPushService.pushByUserId(msg.getUserId(), templateId, openurl, miniprogram_appid, miniprogram_path, "\u60a8\u6536\u5230\u4e00\u6761\u6765\u81ea\u60a3\u8005\u7684\u6d88\u606f", msg.getSendname(), this.formatter.format(new Date()), "\u56fe\u6587\u54a8\u8be2\u56de\u590d", msg.getEscapeMsgImg(), TokenKeyUtil.doctor_key);
    }

    private void pushDocterToUser(Message msg) {
        String miniprogram_appid = "";
        String miniprogram_path = "";
        String openurl = msg.getOpenurl();
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("miniprogram", "user");
        miniprogram_appid = mongoDictionary.getStr1();
        MongoDictionary configs = this.mongoDictionaryService.queryDictionary("miniprogram_tuwen");
        String index = mongoDictionary.getStr2();
        String jumpUrl = configs.getStr1();
        if (configs.getStr2() != null) {
            openurl = configs.getStr2();
        }
        if (jumpUrl != null && jumpUrl.trim().length() > 0) {
            jumpUrl = String.format(jumpUrl, msg.getOrderid());
            jumpUrl = Base64Utils.encode((byte[])jumpUrl.getBytes());
            miniprogram_path = index + jumpUrl;
        }
        System.out.println("miniprogram_appid=========================" + miniprogram_appid);
        String templateId = Global.getConfig((String)"public_wechat_template_id");
        this.angelWechatPushService.pushByUserId(msg.getUserId(), templateId, openurl, miniprogram_appid, miniprogram_path, "\u60a8\u6536\u5230\u4e00\u6761\u6765\u81ea\u533b\u751f\u7684\u6d88\u606f", msg.getSendname() + " \u533b\u751f", this.formatter.format(new Date()), "\u56fe\u6587\u54a8\u8be2\u56de\u590d", msg.getEscapeMsgImg(), TokenKeyUtil.angel_key);
        System.out.println("\u63a8\u9001\u6d88\u606f\u5230\u60a3\u8005\u5fae\u4fe1\u53f7==========================\u53c2\u6570\uff1a" + msg.toString());
    }
}

