/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.doctormanagechat;

import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.StartService;
import com.cxqm.xiaoerke.modules.entity.HandlerParam;
import com.cxqm.xiaoerke.modules.entity.Path;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDoctorManageChatlog;
import com.cxqm.xiaoerke.modules.haoyun.event.ManageChatMsgEvent;
import com.cxqm.xiaoerke.modules.haoyun.service.doctormanageentity.ManageChatRoom;
import com.cxqm.xiaoerke.modules.haoyun.service.doctormanageentity.ManageChatUserEvent;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Path(key="managechat")
@Service
public class ManageChat {
    @Autowired
    ManageChatUserEvent manageChatUserEvent;
    @Autowired
    StartService doctorManageChat;

    @Path(key="sendMsg")
    public void sendMsg(HandlerParam handlerParam) {
        System.out.println("\u7528\u6237\uff1a" + handlerParam.getUuid() + "\uff1b\u53d1\u9001\u6d88\u606f=" + handlerParam.getMsg());
        JSONObject msg = handlerParam.getMsg();
        String smsg = msg.getString("msg");
        if (smsg == null || smsg.length() <= 0) {
            return;
        }
        HyDoctorManageChatlog chatlog = new HyDoctorManageChatlog();
        chatlog.setMessage(msg.getString("msg"));
        chatlog.setTimestamp(Long.valueOf(new Date().getTime()));
        chatlog.setId(IdGen.vestaId());
        chatlog.setCreateDate(new Date());
        chatlog.setCreateBy(new User(handlerParam.getUuid()));
        Channel channel = this.getRepChannel(handlerParam.getUuid(), chatlog);
        if (channel != null) {
            JSONObject object = new JSONObject();
            object.put("msg", (Object)msg.getString("msg"));
            object.put("id", (Object)chatlog.getId());
            channel.writeAndFlush((Object)new TextWebSocketFrame(object.toJSONString()).retain());
            chatlog.setRepIsOnline(true);
            chatlog.setIsread(Integer.valueOf(1));
        } else {
            chatlog.setRepIsOnline(false);
            chatlog.setIsread(Integer.valueOf(0));
        }
        if (smsg.indexOf("loadpic[") != -1) {
            return;
        }
        try {
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new ManageChatMsgEvent(chatlog));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Channel getRepChannel(String myid, HyDoctorManageChatlog chatlog) {
        String roomid = this.manageChatUserEvent.getUserRoom().get(myid);
        if (roomid == null || roomid.trim().length() <= 0) {
            return null;
        }
        chatlog.setOrderId(roomid);
        chatlog.setSenderUserId(myid);
        ManageChatRoom manageChatRoom = this.manageChatUserEvent.getChatroom().get(roomid);
        Channel channel = null;
        if (myid.equals(manageChatRoom.getUser().getId())) {
            channel = manageChatRoom.getDoctorChannel();
            chatlog.setAcceptUserId(manageChatRoom.getDoctor().getId());
            chatlog.setSendName(manageChatRoom.getUser().getName());
            chatlog.setToUserType("doctor");
        } else if (myid.equals(manageChatRoom.getDoctor().getId())) {
            channel = manageChatRoom.getUserChannel();
            chatlog.setAcceptUserId(manageChatRoom.getUser().getId());
            chatlog.setSendName(manageChatRoom.getDoctor().getName());
            chatlog.setToUserType("user");
        }
        if (channel != null && !channel.isOpen()) {
            channel = null;
        }
        return channel;
    }
}

