/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.ArticleVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyArticleCollectVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyArticleBuyDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyArticleCollectDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyArticleBuy;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyArticleCollect;
import com.cxqm.xiaoerke.modules.haoyun.example.CmsArticleExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyArticleBuyExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyArticleCollectExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyArticleCollectService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyArticleCollectServiceImpl
implements HyArticleCollectService {
    @Autowired
    private HyArticleCollectDao hyArticleCollectDao;
    @Autowired
    private HyArticleBuyDao hyArticleBuyDao;

    public List<HyArticleCollect> selectByExample(HyArticleCollectExample example) {
        return this.hyArticleCollectDao.selectByExample(example);
    }

    public Page<HyArticleCollectVo> findVoByPage(Page<HyArticleCollectVo> page, HyArticleCollectExample eArticleCollect, CmsArticleExample eArticle, String userid) {
        Page<HyArticleCollectVo> resultPage = this.hyArticleCollectDao.selectVoByPage(page, eArticleCollect, eArticle);
        if (resultPage != null && resultPage.getList().size() > 0) {
            this.fillArticleVoStatisticsData(resultPage.getList(), userid);
        }
        return resultPage;
    }

    private void fillArticleVoStatisticsData(List<HyArticleCollectVo> list, String userId) {
        if (list == null || list.size() == 0) {
            return;
        }
        ArrayList<String> articleList = new ArrayList<String>();
        ArrayList<String> allArticleList = new ArrayList<String>();
        for (HyArticleCollectVo vo : list) {
            if (vo != null && vo.getArticleVo() != null && vo.getArticleVo().getDoctorArticleId() != null && vo.getArticleVo().getDoctorArticleId().trim().length() > 0) {
                articleList.add(vo.getArticleVo().getId());
            }
            if (vo == null || vo.getArticleVo() == null || vo.getArticleVo().getId() == null) continue;
            allArticleList.add(vo.getArticleVo().getId());
        }
        HashedMap userCollectMap = new HashedMap();
        if (userId != null && userId.trim().length() > 0 && allArticleList.size() > 0) {
            HyArticleCollectExample collectExample = new HyArticleCollectExample();
            HyArticleCollectExample.Criteria collectExampleCriteria = collectExample.createCriteria();
            collectExampleCriteria.andArticleIdIn(allArticleList);
            collectExampleCriteria.andUserIdEqualTo(userId);
            List<HyArticleCollect> collectList = this.hyArticleCollectDao.selectByExample(collectExample);
            if (collectList != null && collectList.size() > 0) {
                for (HyArticleCollect collect : collectList) {
                    userCollectMap.put(collect.getArticleId(), collect.getUserId());
                }
            }
        }
        HashedMap salesVolumeMap = new HashedMap();
        HashedMap userBuyMap = new HashedMap();
        if (articleList != null && articleList.size() > 0) {
            HyArticleBuyExample articleBuyExample = new HyArticleBuyExample();
            HyArticleBuyExample.Criteria articleBuyExampleCriteria = articleBuyExample.createCriteria();
            articleBuyExampleCriteria.andArticleIdIn(articleList);
            articleBuyExampleCriteria.andStatusEqualTo("10");
            List<HyArticleBuy> articleBuyList = this.hyArticleBuyDao.selectByExample(articleBuyExample);
            if (articleBuyList != null && articleBuyList.size() > 0) {
                for (HyArticleBuy hyArticleBuy : articleBuyList) {
                    Integer volume = 0;
                    if (salesVolumeMap.containsKey(hyArticleBuy.getArticleId())) {
                        volume = (Integer)salesVolumeMap.get(hyArticleBuy.getArticleId());
                    }
                    volume = volume + 1;
                    salesVolumeMap.put(hyArticleBuy.getArticleId(), volume);
                    if (userId == null || userId.trim().length() <= 0 || !hyArticleBuy.getUserId().equals(userId)) continue;
                    userBuyMap.put(hyArticleBuy.getArticleId(), userId);
                }
            }
        }
        for (HyArticleCollectVo collectVo : list) {
            ArticleVo vo = collectVo.getArticleVo();
            if (vo == null) continue;
            if (vo.getArticleData() != null && vo.getArticleData().getContent() != null && vo.getArticleData().getContent().trim().length() > 0) {
                vo.getArticleData().setContent(vo.getArticleData().getContent().replaceAll("&quot;", "'"));
            }
            vo.setSalesVolume((Integer)salesVolumeMap.get(vo.getId()));
            if (userBuyMap != null && userBuyMap.containsKey(vo.getId())) {
                vo.setHasBuy(true);
            }
            if (userCollectMap != null && userCollectMap.containsKey(vo.getId())) {
                vo.setHasCollect(true);
            }
            if (vo.getDoctorVo() == null || vo.getDoctorVo().getSysUserId() == null || !vo.getDoctorVo().getSysUserId().equals(userId)) continue;
            vo.setSelfArticle(true);
        }
    }

    public boolean save(HyArticleCollect record) {
        List<HyArticleCollect> collectList;
        if (record == null) {
            return false;
        }
        HyArticleCollectExample collectExample = new HyArticleCollectExample();
        HyArticleCollectExample.Criteria collectExampleCriteria = collectExample.createCriteria();
        collectExampleCriteria.andDelFlagEqualTo("0");
        if (record.getUserId() != null && record.getUserId().trim().length() > 0) {
            collectExampleCriteria.andUserIdEqualTo(record.getUserId());
        }
        if (record.getArticleId() != null && record.getArticleId().trim().length() > 0) {
            collectExampleCriteria.andArticleIdEqualTo(record.getArticleId());
        }
        if ((collectList = this.selectByExample(collectExample)) != null && collectList.size() > 0) {
            return false;
        }
        if (record.getCreateDate() == null) {
            record.setCreateDate(new Date());
        }
        record.setId(IdGen.vestaId());
        int saveFlag = this.hyArticleCollectDao.insertSelective(record);
        return saveFlag == 1;
    }

    public boolean update(HyArticleCollect record) {
        int updateFlag;
        if (record == null) {
            return false;
        }
        if (record.getUpdateDate() == null) {
            record.setCreateDate(new Date());
        }
        return (updateFlag = this.hyArticleCollectDao.updateByPrimaryKeySelective(record)) == 1;
    }

    public boolean delete(String id) {
        if (id == null || id.trim().length() == 0) {
            return false;
        }
        int deleteFlag = this.hyArticleCollectDao.deleteByPrimaryKey(id);
        return deleteFlag == 1;
    }

    public HyArticleCollect findById(String id) {
        return this.hyArticleCollectDao.selectByPrimaryKey(id);
    }
}

