/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyAssayInspectImageDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyAssayInspectImage;
import com.cxqm.xiaoerke.modules.haoyun.example.HyAssayInspectImageExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyAssayInspectImageService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyAssayInspectImageServiceImpl
implements HyAssayInspectImageService {
    @Autowired
    HyAssayInspectImageDao hyAssayInspectImageDao;

    public void save(String hyAssayInspectId, String imageUrl, String userId) {
        if (hyAssayInspectId != null && !"".equals(hyAssayInspectId == null ? "" : hyAssayInspectId.trim()) && imageUrl != null && !"".equals(imageUrl == null ? "" : imageUrl.trim())) {
            return;
        }
        String[] img = imageUrl.split(",");
        this.saveByImgs(img, hyAssayInspectId, userId);
    }

    public void update(String hyAssayInspectId, String imageUrl, String userId) {
        if (hyAssayInspectId != null && !"".equals(hyAssayInspectId == null ? "" : hyAssayInspectId.trim()) && imageUrl != null && !"".equals(imageUrl == null ? "" : imageUrl.trim())) {
            return;
        }
        this.deleteByHyAssayInspectId(hyAssayInspectId);
        String[] img = imageUrl.split(",");
        this.saveByImgs(img, hyAssayInspectId, userId);
    }

    private void saveByImgs(String[] img, String hyAssayInspectId, String userId) {
        Date date = new Date();
        for (String url : img) {
            HyAssayInspectImage hyAssayInspectImage = new HyAssayInspectImage();
            hyAssayInspectImage.setId(IdGen.vestaId());
            hyAssayInspectImage.setHyAssayInspectId(hyAssayInspectId);
            hyAssayInspectImage.setImageUrl(url);
            hyAssayInspectImage.setCreateBy(new User(userId));
            hyAssayInspectImage.setCreateDate(date);
            hyAssayInspectImage.setDelFlag("0");
            this.hyAssayInspectImageDao.insertSelective(hyAssayInspectImage);
        }
    }

    public void save(List<HyAssayInspectImage> list, String hyAssayInspectId, String userId) {
        this.deleteByHyAssayInspectId(hyAssayInspectId);
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            new JSONObject();
            JSONObject obj = JSONObject.fromObject((Object)list.get(i));
            HyAssayInspectImage image = new HyAssayInspectImage();
            image.setHyAssayInspectId(hyAssayInspectId);
            image.setDelFlag("0");
            image.setCreateBy(new User(userId));
            image.setCreateDate(new Date());
            image.setId(IdGen.vestaId());
            try {
                image.setImageUrl(obj.getString("imageUrl"));
            }
            catch (Exception e) {
                image.setImageUrl("");
            }
            this.hyAssayInspectImageDao.insertSelective(image);
        }
    }

    public void deleteByHyAssayInspectId(String hyAssayInspectId) {
        if (hyAssayInspectId == null || hyAssayInspectId.trim().equals("")) {
            return;
        }
        HyAssayInspectImageExample example = new HyAssayInspectImageExample();
        example.createCriteria().andHyAssayInspectIdEqualTo(hyAssayInspectId);
        this.hyAssayInspectImageDao.deleteByExample(example);
    }

    public List<HyAssayInspectImage> queryByHyAssayInspectId(String hyAssayInspectId) {
        HyAssayInspectImageExample example = new HyAssayInspectImageExample();
        example.createCriteria().andHyAssayInspectIdEqualTo(hyAssayInspectId);
        return this.hyAssayInspectImageDao.selectByExample(example);
    }
}

