/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyAssayInspectBean;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyAssayInspectCondition;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyAssayInspectDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyAssayInspect;
import com.cxqm.xiaoerke.modules.haoyun.example.HyAssayInspectExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyAssayInspectImageService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyAssayInspectService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyAssayInspectServiceImpl
implements HyAssayInspectService {
    @Autowired
    HyAssayInspectDao hyAssayInspectDao;
    @Autowired
    HyAssayInspectImageService hyAssayInspectImageService;

    public Integer queryUserHaveInspect(String code, String userId) {
        if (code == null || code.trim().equals("") || userId == null || userId.trim().equals("")) {
            return 0;
        }
        HyAssayInspectExample example = new HyAssayInspectExample();
        example.createCriteria().andUserIdEqualTo(userId).andHyInspectCodeEqualTo(code);
        List<HyAssayInspect> list = this.hyAssayInspectDao.selectByExample(example);
        return list == null || list.size() == 0 ? 0 : list.size();
    }

    public void allSave(String json, String code, String userId) {
        if (json == null || json.trim().equals("")) {
            return;
        }
        List list = (List)com.alibaba.fastjson.JSONObject.parse((String)json);
        for (int i = 0; i < list.size(); ++i) {
            HyAssayInspect inspect = new HyAssayInspect();
            new JSONObject();
            JSONObject obj = JSONObject.fromObject(list.get(i));
            HyAssayInspectBean bean = (HyAssayInspectBean)JSONObject.toBean((JSONObject)obj, HyAssayInspectBean.class);
            bean.setHyInspectCode(code);
            inspect = this.save(bean, inspect, userId);
            this.hyAssayInspectImageService.save(bean.getImages(), inspect.getId(), userId);
        }
    }

    private HyAssayInspect save(HyAssayInspectBean bean, HyAssayInspect inspect, String userId) {
        if (bean == null || inspect == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (bean.getId() == null || bean.getId().trim().equals("")) {
            inspect.setUserId(userId);
            inspect.setSpare1(bean.getSpare1());
            inspect.setSpare2(bean.getSpare2());
            inspect.setSpare3(bean.getSpare3());
            inspect.setDelFlag("0");
            inspect.setCreateBy(new User(userId));
            inspect.setCreateDate(new Date());
            inspect.setId(IdGen.vestaId());
            try {
                inspect.setInspectTime(bean.getTime() == null ? null : sdf.parse(bean.getTime()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            inspect.setInspectRecord(bean.getInspectRecord());
            inspect.setHyInspectCode(bean.getHyInspectCode());
            this.hyAssayInspectDao.insertSelective(inspect);
        } else {
            inspect = this.queryById(bean.getId());
            inspect.setUserId(userId);
            inspect.setSpare1(bean.getSpare1());
            inspect.setSpare2(bean.getSpare2());
            inspect.setSpare3(bean.getSpare3());
            inspect.setUpdateBy(new User(userId));
            inspect.setUpdateDate(new Date());
            try {
                inspect.setInspectTime(sdf.parse(bean.getTime()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            inspect.setInspectRecord(bean.getInspectRecord());
            inspect.setHyInspectCode(bean.getHyInspectCode());
            this.hyAssayInspectDao.updateByPrimaryKeySelective(inspect);
        }
        return inspect;
    }

    private HyAssayInspect queryById(String id) {
        return this.hyAssayInspectDao.selectByPrimaryKey(id);
    }

    public void deletePage(String id) {
        this.hyAssayInspectImageService.deleteByHyAssayInspectId(id);
        this.hyAssayInspectDao.deleteByPrimaryKey(id);
    }

    public void save(String hyInspectCode, String inspectRecord, String inspectTime, String spare1, String spare2, String spare3, String imageUrl, String userId) {
        HyAssayInspect hyAssayInspect = new HyAssayInspect();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        hyAssayInspect.setId(IdGen.vestaId());
        hyAssayInspect.setHyInspectCode(hyInspectCode);
        hyAssayInspect.setInspectRecord(inspectRecord);
        try {
            hyAssayInspect.setInspectTime(sdf.parse(inspectTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        hyAssayInspect.setSpare1(spare1);
        hyAssayInspect.setSpare2(spare2);
        hyAssayInspect.setSpare3(spare3);
        hyAssayInspect.setUserId(userId);
        hyAssayInspect.setCreateBy(new User(userId));
        hyAssayInspect.setCreateDate(new Date());
        hyAssayInspect.setDelFlag("0");
        this.hyAssayInspectDao.insertSelective(hyAssayInspect);
        this.hyAssayInspectImageService.save(hyAssayInspect.getId(), imageUrl, userId);
    }

    public void update(String id, String hyInspectCode, String inspectRecord, String inspectTime, String spare1, String spare2, String spare3, String imageUrl, String userId) {
        HyAssayInspect hyAssayInspect = new HyAssayInspect();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        hyAssayInspect.setId(id);
        hyAssayInspect.setHyInspectCode(hyInspectCode);
        hyAssayInspect.setInspectRecord(inspectRecord);
        try {
            hyAssayInspect.setInspectTime(sdf.parse(inspectTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        hyAssayInspect.setSpare1(spare1);
        hyAssayInspect.setSpare2(spare2);
        hyAssayInspect.setSpare3(spare3);
        hyAssayInspect.setUserId(userId);
        hyAssayInspect.setUpdateBy(new User(userId));
        hyAssayInspect.setUpdateDate(new Date());
        this.hyAssayInspectDao.updateByPrimaryKeySelective(hyAssayInspect);
        this.hyAssayInspectImageService.update(hyAssayInspect.getId(), imageUrl, userId);
    }

    public Page<HyAssayInspectBean> queryByUserIdAndCode(Page<HyAssayInspect> page, String userId, String code) {
        HyAssayInspectCondition condition = new HyAssayInspectCondition();
        condition.setUserId(userId);
        condition.setHyInspectCode(code);
        Page<HyAssayInspectBean> beanPage = this.hyAssayInspectDao.queryList(page, condition);
        if (beanPage == null || beanPage.getList() == null || beanPage.getList().size() == 0) {
            return null;
        }
        List list = beanPage.getList();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (HyAssayInspectBean bean : list) {
            List imageList = this.hyAssayInspectImageService.queryByHyAssayInspectId(bean.getId());
            bean.setImages(imageList);
        }
        beanPage.setList(list);
        return beanPage;
    }
}

