/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyConsultationOrderBean;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyConsultationOrderCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyDoctorManageOrderCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.UserDetailVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyConsultationOrderDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserAccountDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserAccountDetailDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyConsultationOrder;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyLabelSubCategory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyScheme;
import com.cxqm.xiaoerke.modules.haoyun.entity.HySchemeDoctor;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyYunSubStatus;
import com.cxqm.xiaoerke.modules.haoyun.enums.HyConsultationOrderEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.HyConsultationOrderRefundStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.example.HyConsultationOrderExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyConsultationOrderService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorManagePlanService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyLabelSubCategoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HySchemeDoctorService;
import com.cxqm.xiaoerke.modules.haoyun.service.HySchemeService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserLabelService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserYunStatusService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyYunSubStatusService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountDetailService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyConsultationOrderServiceImpl
implements HyConsultationOrderService {
    @Autowired
    HyConsultationOrderDao hyConsultationOrderDao;
    @Autowired
    HyDoctorManagePlanService hyDoctorManagePlanService;
    @Autowired
    HySchemeService hySchemeService;
    @Autowired
    HyUserLabelService hyUserLabelService;
    @Autowired
    UserInfoService userInfoService;
    @Autowired
    HyUserYunStatusService hyUserYunStatusService;
    @Autowired
    HyYunSubStatusService hyYunSubStatusService;
    @Autowired
    HySchemeDoctorService hySchemeDoctorService;
    @Autowired
    HyLabelSubCategoryService hyLabelSubCategoryService;
    @Autowired
    SysUserAccountDetailDao sysUserAccountDetailDao;
    @Autowired
    SysUserAccountDao sysUserAccountDao;
    @Autowired
    SysUserAccountDetailService sysUserAccountDetailService;

    public void refundOrder(String id, String userId) {
        HyConsultationOrder HyConsultationOrder2 = new HyConsultationOrder();
        Date date = new Date();
        HyConsultationOrder2.setId(id);
        HyConsultationOrder2.setUpdateBy(new User(userId));
        HyConsultationOrder2.setUpdateDate(date);
        HyConsultationOrder2.setRefundStatus(HyConsultationOrderRefundStatusEnum.AGREE_REFUND.getCode());
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(HyConsultationOrder2);
    }

    public int queryMyDoctorNumber(String userId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setOrderStatus(HyConsultationOrderEnum.USER_PAY_SUCCESS.getCode());
        condition.setUserId(userId);
        return 1;
    }

    public void refuseRefundOrder(String id, String userId, String refundReason) {
        HyConsultationOrder HyConsultationOrder2 = new HyConsultationOrder();
        Date date = new Date();
        HyConsultationOrder2.setId(id);
        HyConsultationOrder2.setUpdateBy(new User(userId));
        HyConsultationOrder2.setUpdateDate(date);
        HyConsultationOrder2.setRefundReason(refundReason);
        HyConsultationOrder2.setRefundStatus(HyConsultationOrderRefundStatusEnum.REFUSE_REFUND.getCode());
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(HyConsultationOrder2);
    }

    public void applyRefundOrder(String id, String userId, String refundReason) {
        HyConsultationOrder HyConsultationOrder2 = new HyConsultationOrder();
        Date date = new Date();
        HyConsultationOrder2.setId(id);
        HyConsultationOrder2.setUpdateBy(new User(userId));
        HyConsultationOrder2.setUpdateDate(date);
        HyConsultationOrder2.setRefundReason(refundReason);
        HyConsultationOrder2.setRefundStatus(HyConsultationOrderRefundStatusEnum.APPLY_REFUND_WAITING.getCode());
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(HyConsultationOrder2);
    }

    public Page<HyConsultationOrderBean> queryAlreadyPaidPage(Page<HyConsultationOrderBean> page, HyConsultationOrderBean HyConsultationOrderBean2) {
        HyConsultationOrderBean2 = HyConsultationOrderBean2 == null ? new HyConsultationOrderBean() : HyConsultationOrderBean2;
        HyConsultationOrderBean2.setAlreadyPaid(true);
        return this.hyConsultationOrderDao.queryPage(page, HyConsultationOrderBean2);
    }

    public Page<HyConsultationOrderBean> queryApplyRefundPage(Page<HyConsultationOrderBean> page, HyConsultationOrderBean HyConsultationOrderBean2) {
        HyConsultationOrderBean2 = HyConsultationOrderBean2 == null ? new HyConsultationOrderBean() : HyConsultationOrderBean2;
        HyConsultationOrderBean2.setRefundStatus(HyConsultationOrderRefundStatusEnum.APPLY_REFUND_WAITING.getCode());
        return this.hyConsultationOrderDao.queryPage(page, HyConsultationOrderBean2);
    }

    public List<User> queryDoctorList() {
        return this.hyConsultationOrderDao.queryDoctorList();
    }

    public List<User> queryDoctorList2() {
        return this.hyConsultationOrderDao.queryDoctorList2();
    }

    public void payOrderInvalid(String orderId) {
        HyConsultationOrder order = this.queryById(orderId);
        if (order.getOrderStatus().equals(HyConsultationOrderEnum.DOCTOR_AGREE.getCode()) || order.getOrderStatus().equals(HyConsultationOrderEnum.WAIT_USER_AGREE.getCode())) {
            this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
        }
    }

    public boolean currentOrderIsExist(String doctorUserId, String userId) {
        HyConsultationOrderExample example = new HyConsultationOrderExample();
        HyConsultationOrderExample example1 = new HyConsultationOrderExample();
        HyConsultationOrderExample example2 = new HyConsultationOrderExample();
        HyConsultationOrderExample example3 = new HyConsultationOrderExample();
        example.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andUserIdEqualTo(userId).andOrderStatusEqualTo(HyConsultationOrderEnum.WAIT_DOTOC_AGREE.getCode());
        example1.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andUserIdEqualTo(userId).andOrderStatusEqualTo(HyConsultationOrderEnum.DOCTOR_AGREE.getCode());
        example2.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andUserIdEqualTo(userId).andOrderStatusEqualTo(HyConsultationOrderEnum.USER_PAY_SUCCESS.getCode());
        example3.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andUserIdEqualTo(userId).andOrderStatusEqualTo(HyConsultationOrderEnum.WAIT_USER_AGREE.getCode());
        example.or(example1.createCriteria());
        example.or(example2.createCriteria());
        example.or(example3.createCriteria());
        List<HyConsultationOrder> list = this.hyConsultationOrderDao.selectByExample(example);
        return list != null && list.size() != 0;
    }

    public HyConsultationOrder queryManageOrderByOrderId(String id) {
        return this.hyConsultationOrderDao.selectByPrimaryKey(id);
    }

    public HyConsultationOrder queryByOrderNo(String orderNo) {
        HyConsultationOrderExample example = new HyConsultationOrderExample();
        example.createCriteria().andOrderNoEqualTo(orderNo);
        List<HyConsultationOrder> list = this.hyConsultationOrderDao.selectByExample(example);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public void doctorInviteInvalid(String orderId) {
        HyConsultationOrder order = this.queryById(orderId);
        if (order.getOrderStatus().equals(HyConsultationOrderEnum.WAIT_USER_AGREE.getCode())) {
            this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
        }
    }

    public void userInviteInvalid(String orderId) {
        HyConsultationOrder order = this.queryById(orderId);
        if (order.getOrderStatus().equals(HyConsultationOrderEnum.WAIT_DOTOC_AGREE.getCode())) {
            this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
        }
    }

    public void orderInvalid(String orderId) {
        HyConsultationOrder order = this.queryById(orderId);
        if (order.getOrderStatus().equals(HyConsultationOrderEnum.USER_PAY_SUCCESS.getCode())) {
            this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
        }
    }

    public HyConsultationOrder createOrderByUserId(String userId, String schemeId, String doctorId, String price) {
        HyConsultationOrder order = new HyConsultationOrder();
        order.setId(IdGen.vestaId());
        order.setOrderNo(IdGen.vestaId());
        order.setCreateBy(new User(doctorId));
        order.setCreateDate(new Date());
        order.setDelFlag("0");
        this.hyConsultationOrderDao.insertSelective(order);
        return order;
    }

    public HyConsultationOrder createOrder(String doctorId, String schemeId, String userId, String price) {
        HyConsultationOrder order = new HyConsultationOrder();
        order.setId(IdGen.vestaId());
        order.setOrderNo(IdGen.vestaId());
        order.setCreateBy(new User(userId));
        order.setCreateDate(new Date());
        order.setDelFlag("0");
        HySchemeDoctor hySchemeDoctor = this.hySchemeDoctorService.querySchemeByDoctorUserIdAndSchemeId(doctorId, schemeId);
        int actualPrice = 0;
        if (hySchemeDoctor != null && hySchemeDoctor.getPrice() != null) {
            actualPrice = (int)(hySchemeDoctor.getPrice() * 100.0);
        }
        this.hyConsultationOrderDao.insertSelective(order);
        return order;
    }

    public void updatePayOrderStatus(String orderId, String price, String buyTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HyConsultationOrder order = this.queryById(orderId);
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
    }

    public int queryOrderNumber(String doctorId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyConsultationOrderEnum.ORDER_END.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_NOT_EVALUATE.getCode().toString());
        return 1;
    }

    public void userEvaluateDoctor(String orderId, String content, Integer key, Integer key2, Integer key3) {
        HyConsultationOrder order = this.queryById(orderId);
        order.setUpdateDate(new Date());
        order.setRemarks(content);
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
    }

    public Page<HyConsultationOrderBean> queryMyOrderHistory(Page<HyConsultationOrderBean> page, String userId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyConsultationOrderEnum.ORDER_END.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_NOT_EVALUATE.getCode().toString());
        list.add(HyConsultationOrderEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(HyConsultationOrderEnum.ORDER_REFUND.getCode().toString());
        list.add(HyConsultationOrderEnum.ORDER_PAY_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.ORDER_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_REFUSE.getCode().toString());
        return this.hyConsultationOrderDao.queryDoctorHistoryPage(page, condition);
    }

    public Page<HyConsultationOrderBean> queryMyOrder(Page<HyConsultationOrderBean> page, String userId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyConsultationOrderEnum.WAIT_DOTOC_AGREE.getCode().toString());
        list.add(HyConsultationOrderEnum.DOCTOR_AGREE.getCode().toString());
        list.add(HyConsultationOrderEnum.WAIT_USER_AGREE.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_PAY_SUCCESS.getCode().toString());
        return null;
    }

    public Page<HyConsultationOrderBean> queryManageDoctor(Page<HyConsultationOrder> page, String userId, String name) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        return null;
    }

    public Page<HyConsultationOrderBean> queryExecutionOrder(Page<HyConsultationOrder> page, String doctorId, String status, String scheme, String label) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        if (label != null && !"".equals(label == null ? "" : label.trim())) {
            String[] labels = label.split(",");
            ArrayList<String> labelList = new ArrayList<String>();
            for (String l : labels) {
                labelList.add(l);
            }
        }
        if (scheme != null && !"".equals(scheme == null ? "" : scheme.trim())) {
            String[] schemes = scheme.split(",");
            ArrayList<String> schemeList = new ArrayList<String>();
            for (String l : schemes) {
                schemeList.add(l);
            }
        }
        if (status != null && !"".equals(status == null ? "" : status.trim())) {
            String[] statuss = status.split(",");
            ArrayList<String> statusList = new ArrayList<String>();
            for (String l : statuss) {
                statusList.add(l);
            }
        }
        return null;
    }

    public UserDetailVo queryUserDetail(String userId, String orderId) {
        User user = this.userInfoService.getUserById(userId);
        UserDetailVo userDetailVo = new UserDetailVo();
        this.packageUser(userDetailVo, user);
        List list = this.hyLabelSubCategoryService.queryByUserId(orderId);
        userDetailVo.setLabelList(list);
        HyYunSubStatus status = this.hyYunSubStatusService.queryStatusByUserId(user.getId());
        userDetailVo.setStatusName(status == null ? "" : status.getName());
        return userDetailVo;
    }

    public Page<HyConsultationOrderBean> queryApplying(Page<HyConsultationOrder> page, String doctorId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        return null;
    }

    public Page<HyConsultationOrderBean> queryNotPayment(Page<HyConsultationOrder> page, String doctorId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        return null;
    }

    public List<HyLabelSubCategory> queryManageDistinctLabel(String doctorId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        return null;
    }

    public List<HyScheme> queryManageDistinctScheme(String doctorId) {
        List schemeDoctorList = this.hySchemeDoctorService.querySchemeList(doctorId);
        if (schemeDoctorList == null || schemeDoctorList.size() == 0) {
            return null;
        }
        ArrayList<HyScheme> list = new ArrayList<HyScheme>();
        for (HySchemeDoctor hySchemeDoctor : schemeDoctorList) {
            list.add(hySchemeDoctor.getHyScheme());
        }
        return list;
    }

    public List<HyLabelSubCategory> queryHistoryDistinctLabel(String doctorId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyConsultationOrderEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyConsultationOrderEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_REFUSE.getCode().toString());
        list.add(HyConsultationOrderEnum.ORDER_END.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_NOT_EVALUATE.getCode().toString());
        return null;
    }

    public List<HyLabelSubCategory> queryManageLabel(String doctorId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyConsultationOrderEnum.USER_PAY_SUCCESS.getCode().toString());
        return null;
    }

    public List<HyScheme> queryHistoryDistinctScheme(String doctorId) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyConsultationOrderEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyConsultationOrderEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_REFUSE.getCode().toString());
        return null;
    }

    public Page<HyConsultationOrderBean> queryDoctorHistoryPageByDoctorId(Page<HyConsultationOrderBean> page, String doctorId, String status, String scheme, String label) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        if (label != null && !"".equals(label == null ? "" : label.trim())) {
            String[] labels = label.split(",");
            ArrayList<String> labelList = new ArrayList<String>();
            for (String l : labels) {
                labelList.add(l);
            }
        }
        if (scheme != null && !"".equals(scheme == null ? "" : scheme.trim())) {
            String[] schemes = scheme.split(",");
            ArrayList<String> schemeList = new ArrayList<String>();
            for (String l : schemes) {
                schemeList.add(l);
            }
        }
        if (status != null && !"".equals(status == null ? "" : status.trim())) {
            String[] statuss = status.split(",");
            ArrayList<String> statusList = new ArrayList<String>();
            for (String l : statuss) {
                statusList.add(l);
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyConsultationOrderEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyConsultationOrderEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_REFUSE.getCode().toString());
        list.add(HyConsultationOrderEnum.ORDER_END.getCode().toString());
        list.add(HyConsultationOrderEnum.ORDER_REFUND.getCode().toString());
        list.add(HyConsultationOrderEnum.ORDER_PAY_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.ORDER_INVALID.getCode().toString());
        list.add(HyConsultationOrderEnum.USER_NOT_EVALUATE.getCode().toString());
        return null;
    }

    public HyConsultationOrder queryById(String id) {
        HyConsultationOrderExample example = new HyConsultationOrderExample();
        example.createCriteria().andIdEqualTo(id);
        List<HyConsultationOrder> list = this.hyConsultationOrderDao.selectByExample(example);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public UserDetailVo packageUserDetailVo(String doctorUserId, String orderId) {
        HyConsultationOrder HyConsultationOrder2 = this.queryById(orderId);
        UserDetailVo userDetailVo = new UserDetailVo();
        List list = this.hyLabelSubCategoryService.queryByUserId(orderId);
        userDetailVo.setLabelList(list);
        return userDetailVo;
    }

    private void packageUser(UserDetailVo userDetailVo, User user) {
        userDetailVo.setId(user.getId());
        userDetailVo.setName(user.getName());
        userDetailVo.setBuckter(user.getBuckter());
        userDetailVo.setMarketer(user.getMarketer());
        userDetailVo.setPhoto(user.getPhoto());
        userDetailVo.setSex(user.getSex());
        userDetailVo.setDetailedAddress(user.getDetailedAddress());
        userDetailVo.setHeight(user.getHeight());
        userDetailVo.setWeight(user.getWeight());
        userDetailVo.setBirthDate(user.getBirthDate());
        userDetailVo.setRegion(user.getRegion());
    }

    public void selectedUser(String userId, String planId, String currentUserId) {
        HyConsultationOrder HyConsultationOrder2 = new HyConsultationOrder();
        HyConsultationOrder2.setId(IdGen.vestaId());
        HyConsultationOrder2.setOrderNo(IdGen.vestaId());
        HyConsultationOrder2.setCreateBy(new User(currentUserId));
        HyConsultationOrder2.setCreateDate(new Date());
        HyConsultationOrder2.setDelFlag("0");
        this.hyConsultationOrderDao.insertSelective(HyConsultationOrder2);
    }

    public void agreeManage(String doctorUserId, String orderId) {
        HyConsultationOrderExample example = new HyConsultationOrderExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<HyConsultationOrder> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        HyConsultationOrder order = list.get(0);
        order.setUpdateBy(new User(doctorUserId));
        order.setUpdateDate(new Date());
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
    }

    public void refuseManage(String doctorUserId, String orderId) {
        HyConsultationOrderExample example = new HyConsultationOrderExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<HyConsultationOrder> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        HyConsultationOrder order = list.get(0);
        order.setUpdateBy(new User(doctorUserId));
        order.setUpdateDate(new Date());
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
    }

    public void userEndManage(String orderId) {
        HyConsultationOrderExample example = new HyConsultationOrderExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<HyConsultationOrder> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        HyConsultationOrder order = list.get(0);
        order.setUpdateDate(new Date());
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
    }

    public void userRefuseManage(String orderId) {
        HyConsultationOrderExample example = new HyConsultationOrderExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<HyConsultationOrder> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        HyConsultationOrder order = list.get(0);
        order.setUpdateDate(new Date());
        this.hyConsultationOrderDao.updateByPrimaryKeySelective(order);
    }

    public Page<HyConsultationOrderBean> queryPageByDoctorUserId(Page<HyConsultationOrderBean> page, String userId) {
        HyConsultationOrderBean bean = new HyConsultationOrderBean();
        return null;
    }

    public Page<HyConsultationOrderBean> queryPageByUserId(Page<HyConsultationOrderBean> page, String userId) {
        HyConsultationOrderBean bean = new HyConsultationOrderBean();
        return null;
    }

    public void selectedDoctor(String doctorUserId, String userId) {
        HyConsultationOrder HyConsultationOrder2 = new HyConsultationOrder();
        HyConsultationOrder2.setId(IdGen.vestaId());
        HyConsultationOrder2.setOrderNo(IdGen.vestaId());
        HyConsultationOrder2.setCreateBy(new User(userId));
        HyConsultationOrder2.setCreateDate(new Date());
        HyConsultationOrder2.setDelFlag("0");
        this.hyConsultationOrderDao.insertSelective(HyConsultationOrder2);
    }

    public int doctorManageCount(String doctorUserId) {
        HyConsultationOrderExample query = new HyConsultationOrderExample();
        query.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andOrderStatusEqualTo(HyConsultationOrderEnum.USER_PAY_SUCCESS.getCode());
        return 0;
    }

    public int update(HyConsultationOrder record) {
        return this.hyConsultationOrderDao.updateByPrimaryKeySelective(record);
    }

    public void ManageOrderAdmission(Date date) {
        if (date == null) {
            date = new Date();
        }
        boolean haveNext = true;
        boolean pageNo = true;
        int pageSize = 200;
        HyConsultationOrder query = new HyConsultationOrder();
        while (haveNext) {
        }
    }

    public static int daysBetween(Date smdate, Date bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    private List<HyConsultationOrder> queryList(HyConsultationOrderExample example) {
        return this.hyConsultationOrderDao.selectByExample(example);
    }
}

