/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.cms.entity.Article;
import com.cxqm.xiaoerke.modules.cms.entity.Category;
import com.cxqm.xiaoerke.modules.cms.service.ArticleService;
import com.cxqm.xiaoerke.modules.cms.service.CategoryService;
import com.cxqm.xiaoerke.modules.haoyun.beans.ArticleVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyDoctorArticleVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyUserYunStatusVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyArticleBuyDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyArticleCollectDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyCategoryYunStatusRelationDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyDoctorArticleDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyArticleBuy;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyArticleCollect;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyCategoryYunStatusRelation;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDoctorArticle;
import com.cxqm.xiaoerke.modules.haoyun.example.CmsArticleExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyArticleBuyExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyArticleCollectExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyCategoryYunStatusRelationExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyDoctorArticleExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorArticleService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserYunStatusService;
import com.cxqm.xiaoerke.modules.haoyun.web.SpUserInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyDoctorArticleServiceImpl
implements HyDoctorArticleService {
    @Autowired
    private HyDoctorArticleDao hyDoctorArticleDao;
    @Autowired
    private HyArticleBuyDao hyArticleBuyDao;
    @Autowired
    private HyArticleCollectDao hyArticleCollectDao;
    @Autowired
    private HyCategoryYunStatusRelationDao hyCategoryYunStatusRelationDao;
    @Autowired
    private ArticleService articleService;
    @Autowired
    private MongoDictionaryService mongoDictionaryService;
    @Autowired
    HyUserYunStatusService hyUserYunStatusService;
    @Autowired
    CategoryService categoryService;

    public Page<HyDoctorArticleVo> findVoByPage(Page<HyDoctorArticleVo> page, HyDoctorArticleExample example, CmsArticleExample eArticle) {
        Page<HyDoctorArticleVo> doctorArticleVoPage = this.hyDoctorArticleDao.selectVoByPage(page, example, eArticle);
        if (doctorArticleVoPage != null && doctorArticleVoPage.getList() != null && doctorArticleVoPage.getList().size() > 0) {
            ArrayList<String> allArticleList = new ArrayList<String>();
            for (HyDoctorArticleVo vo : doctorArticleVoPage.getList()) {
                if (vo.getArticleVo() == null || vo.getArticleVo().getId() == null || vo.getArticleVo().getId().trim().length() <= 0) continue;
                allArticleList.add(vo.getArticleVo().getId());
            }
            if (allArticleList.size() > 0) {
                HashedMap salesVolumeMap = new HashedMap();
                HyArticleBuyExample articleBuyExample = new HyArticleBuyExample();
                HyArticleBuyExample.Criteria articleBuyExampleCriteria = articleBuyExample.createCriteria();
                articleBuyExampleCriteria.andArticleIdIn(allArticleList);
                articleBuyExampleCriteria.andStatusEqualTo("10");
                List<HyArticleBuy> articleBuyList = this.hyArticleBuyDao.selectByExample(articleBuyExample);
                if (articleBuyList != null && articleBuyList.size() > 0) {
                    for (HyArticleBuy hyArticleBuy : articleBuyList) {
                        Integer volume = 0;
                        if (salesVolumeMap.containsKey(hyArticleBuy.getArticleId())) {
                            volume = (Integer)salesVolumeMap.get(hyArticleBuy.getArticleId());
                        }
                        volume = volume + 1;
                        salesVolumeMap.put(hyArticleBuy.getArticleId(), volume);
                    }
                }
                if (salesVolumeMap.size() > 0) {
                    for (HyDoctorArticleVo vo : doctorArticleVoPage.getList()) {
                        vo.getArticleVo().setSalesVolume((Integer)salesVolumeMap.get(vo.getArticleId()));
                    }
                }
            }
        }
        return doctorArticleVoPage;
    }

    public List<HyDoctorArticleVo> findVoByList(HyDoctorArticleExample example, CmsArticleExample eArticle) {
        List<HyDoctorArticleVo> doctorArticleVoList = this.hyDoctorArticleDao.selectVoByPage(example, eArticle);
        if (doctorArticleVoList != null && doctorArticleVoList.size() > 0) {
            ArrayList<String> allArticleList = new ArrayList<String>();
            for (HyDoctorArticleVo vo : doctorArticleVoList) {
                if (vo.getArticleVo() == null || vo.getArticleVo().getId() == null || vo.getArticleVo().getId().trim().length() <= 0) continue;
                allArticleList.add(vo.getArticleVo().getId());
            }
            if (allArticleList.size() > 0) {
                HashedMap salesVolumeMap = new HashedMap();
                HyArticleBuyExample articleBuyExample = new HyArticleBuyExample();
                HyArticleBuyExample.Criteria articleBuyExampleCriteria = articleBuyExample.createCriteria();
                articleBuyExampleCriteria.andArticleIdIn(allArticleList);
                articleBuyExampleCriteria.andStatusEqualTo("10");
                List<HyArticleBuy> articleBuyList = this.hyArticleBuyDao.selectByExample(articleBuyExample);
                if (articleBuyList != null && articleBuyList.size() > 0) {
                    for (HyArticleBuy hyArticleBuy : articleBuyList) {
                        Integer volume = 0;
                        if (salesVolumeMap.containsKey(hyArticleBuy.getArticleId())) {
                            volume = (Integer)salesVolumeMap.get(hyArticleBuy.getArticleId());
                        }
                        volume = volume + 1;
                        salesVolumeMap.put(hyArticleBuy.getArticleId(), volume);
                    }
                }
                if (salesVolumeMap.size() > 0) {
                    for (HyDoctorArticleVo vo : doctorArticleVoList) {
                        vo.getArticleVo().setSalesVolume((Integer)salesVolumeMap.get(vo.getArticleId()));
                    }
                }
            }
        }
        return doctorArticleVoList;
    }

    public HyDoctorArticleVo findVoById(String id) {
        HyDoctorArticleVo vo = null;
        if (id == null || id.trim().length() == 0) {
            return vo;
        }
        HyDoctorArticleExample example = new HyDoctorArticleExample();
        HyDoctorArticleExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        criteria.andDelFlagEqualTo("0");
        Page<HyDoctorArticleVo> page = this.findVoByPage((Page<HyDoctorArticleVo>)new Page(1, 1), example, null);
        if (page != null && page.getList() != null && page.getList().size() > 0) {
            vo = (HyDoctorArticleVo)page.getList().get(0);
        }
        return vo;
    }

    public HyDoctorArticle findById(String id) {
        return this.hyDoctorArticleDao.selectByPrimaryKey(id);
    }

    public List<HyDoctorArticle> findByExample(HyDoctorArticleExample example) {
        return this.hyDoctorArticleDao.selectByExample(example);
    }

    public Page<ArticleVo> findArticleVoByPage(Page<ArticleVo> page, HyDoctorArticleExample example, CmsArticleExample eArticle, String userId) {
        Page<ArticleVo> articleVoPage = this.hyDoctorArticleDao.selectArticleVoByPage(page, example, eArticle);
        if (articleVoPage != null && articleVoPage.getList() != null && articleVoPage.getList().size() > 0) {
            this.fillArticleVoStatisticsData(articleVoPage.getList(), userId);
        }
        return articleVoPage;
    }

    public Page<ArticleVo> findArticleVoByPageDoctorId(Page<ArticleVo> page, String userId, String doctorId) {
        Page<ArticleVo> articleVoPage = this.hyDoctorArticleDao.findArticleByDoctorId(page, doctorId);
        if (articleVoPage != null && articleVoPage.getList() != null && articleVoPage.getList().size() > 0) {
            this.fillArticleVoStatisticsData(articleVoPage.getList(), userId);
        }
        for (ArticleVo articleVo : articleVoPage.getList()) {
            if (this.hyDoctorArticleDao.getBuyByUserIdAndArticleId(SpUserInfo.getUserId(), articleVo.getId()) <= 0L) continue;
            articleVo.setHasBuy(true);
        }
        return articleVoPage;
    }

    private void fillArticleVoStatisticsData(List<ArticleVo> list, String userId) {
        if (list == null || list.size() == 0) {
            return;
        }
        ArrayList<String> articleList = new ArrayList<String>();
        ArrayList<String> allArticleList = new ArrayList<String>();
        for (ArticleVo vo : list) {
            if (vo.getDoctorArticleId() != null && vo.getDoctorArticleId().trim().length() > 0) {
                articleList.add(vo.getId());
            }
            allArticleList.add(vo.getId());
        }
        HashedMap userCollectMap = new HashedMap();
        if (userId != null && userId.trim().length() > 0 && allArticleList.size() > 0) {
            HyArticleCollectExample collectExample = new HyArticleCollectExample();
            HyArticleCollectExample.Criteria collectExampleCriteria = collectExample.createCriteria();
            collectExampleCriteria.andArticleIdIn(allArticleList);
            collectExampleCriteria.andUserIdEqualTo(userId);
            List<HyArticleCollect> collectList = this.hyArticleCollectDao.selectByExample(collectExample);
            if (collectList != null && collectList.size() > 0) {
                for (HyArticleCollect collect : collectList) {
                    userCollectMap.put(collect.getArticleId(), collect.getUserId());
                }
            }
        }
        HashedMap salesVolumeMap = new HashedMap();
        HashedMap userBuyMap = new HashedMap();
        if (articleList != null && articleList.size() > 0) {
            HyArticleBuyExample articleBuyExample = new HyArticleBuyExample();
            HyArticleBuyExample.Criteria articleBuyExampleCriteria = articleBuyExample.createCriteria();
            articleBuyExampleCriteria.andArticleIdIn(articleList);
            articleBuyExampleCriteria.andStatusEqualTo("10");
            List<HyArticleBuy> articleBuyList = this.hyArticleBuyDao.selectByExample(articleBuyExample);
            if (articleBuyList != null && articleBuyList.size() > 0) {
                for (HyArticleBuy hyArticleBuy : articleBuyList) {
                    Integer volume = 0;
                    if (salesVolumeMap.containsKey(hyArticleBuy.getArticleId())) {
                        volume = (Integer)salesVolumeMap.get(hyArticleBuy.getArticleId());
                    }
                    volume = volume + 1;
                    salesVolumeMap.put(hyArticleBuy.getArticleId(), volume);
                    if (userId == null || userId.trim().length() <= 0 || !hyArticleBuy.getUserId().equals(userId)) continue;
                    userBuyMap.put(hyArticleBuy.getArticleId(), userId);
                }
            }
        }
        for (ArticleVo vo : list) {
            if (vo.getArticleData() != null && vo.getArticleData().getContent() != null && vo.getArticleData().getContent().trim().length() > 0) {
                vo.getArticleData().setContent(vo.getArticleData().getContent().replaceAll("&quot;", "'"));
            }
            vo.setSalesVolume((Integer)salesVolumeMap.get(vo.getId()));
            if (userBuyMap != null && userBuyMap.containsKey(vo.getId())) {
                vo.setHasBuy(true);
            }
            if (userCollectMap != null && userCollectMap.containsKey(vo.getId())) {
                vo.setHasCollect(true);
            }
            if (vo.getDoctorVo() == null || vo.getDoctorVo().getSysUserId() == null || !vo.getDoctorVo().getSysUserId().equals(userId)) continue;
            vo.setSelfArticle(true);
        }
    }

    public List<ArticleVo> findArticleVoList(HyDoctorArticleExample doctorArticleExample, CmsArticleExample articleExample, String userId) {
        List<ArticleVo> articleVoList = this.hyDoctorArticleDao.selectArticleVoList(doctorArticleExample, articleExample);
        if (articleVoList != null && articleVoList.size() > 0) {
            this.fillArticleVoStatisticsData(articleVoList, userId);
        }
        return articleVoList;
    }

    public ArticleVo findArticleVoById(String articleId, String userId) {
        CmsArticleExample cmsArticleExample = new CmsArticleExample();
        CmsArticleExample.Criteria cmsArticleExampleCriteria = cmsArticleExample.createCriteria();
        cmsArticleExampleCriteria.andIdEqualTo(articleId);
        List<ArticleVo> articleVoList = this.findArticleVoList(null, cmsArticleExample, userId);
        if (articleVoList == null || articleVoList.size() == 0) {
            return null;
        }
        return articleVoList.get(0);
    }

    public boolean update(HyDoctorArticle record) {
        if (record == null || record.getId() == null || record.getId().trim().length() == 0) {
            return false;
        }
        record.setUpdateDate(new Date());
        int updateFlag = 0;
        updateFlag = this.hyDoctorArticleDao.updateByPrimaryKeySelective(record);
        return updateFlag != 0;
    }

    public boolean delete(String id) {
        if (id == null || id.trim().length() == 0) {
            return false;
        }
        int updateFlag = 0;
        updateFlag = this.hyDoctorArticleDao.deleteByPrimaryKey(id);
        return updateFlag != 0;
    }

    public boolean saveOrUpdate(HyDoctorArticleVo vo) {
        if (vo == null) {
            return false;
        }
        this.articleService.saveExcludePermitted((Article)vo.getArticleVo());
        vo.setArticleId(vo.getArticleVo().getId());
        Date currentDate = new Date();
        if (vo.getId() == null || vo.getId().trim().length() == 0) {
            vo.setCreateDate(currentDate);
            vo.setAddTime(currentDate);
            vo.setId(IdGen.vestaId());
            this.hyDoctorArticleDao.insertSelective((HyDoctorArticle)vo);
        } else {
            vo.setUpdateDate(currentDate);
            this.hyDoctorArticleDao.updateByPrimaryKeySelective((HyDoctorArticle)vo);
        }
        return vo.getArticleVo() == null;
    }

    public boolean saveOrUpdate(HyDoctorArticle vo) {
        if (vo == null) {
            return false;
        }
        Date currentDate = new Date();
        if (vo.getId() == null || vo.getId().trim().length() == 0) {
            vo.setCreateDate(currentDate);
            vo.setAddTime(currentDate);
            vo.setId(IdGen.vestaId());
            this.hyDoctorArticleDao.insertSelective(vo);
        } else {
            vo.setUpdateDate(currentDate);
            this.hyDoctorArticleDao.updateByPrimaryKeySelective(vo);
        }
        return false;
    }

    public List<ArticleVo> findRecommendArticle(String userId) {
        List<ArticleVo> articleVoList;
        CmsArticleExample.Criteria articleExampleCriteria;
        Object articleExample;
        ArrayList<String> categoryIdList;
        List categoryList;
        HyUserYunStatusVo yunStatusVo;
        ArrayList<ArticleVo> result = new ArrayList<ArticleVo>();
        HashSet<String> articleIdSet = new HashSet<String>();
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("hy_sp_recommend_article");
        boolean yunStatusflag = false;
        if (userId != null && userId.trim().length() > 0 && (yunStatusVo = this.hyUserYunStatusService.queryHyUserYunStatusVo(userId)) != null && yunStatusVo.getStatusId() != null && yunStatusVo.getStatusId().trim().length() > 0) {
            HyCategoryYunStatusRelationExample relationExample = new HyCategoryYunStatusRelationExample();
            relationExample.createCriteria().andDelFlagEqualTo("0").andSubYunStatusIdEqualTo(yunStatusVo.getStatusId());
            List<HyCategoryYunStatusRelation> list = this.hyCategoryYunStatusRelationDao.selectByExample(relationExample);
            if (list != null && list.size() > 0) {
                ArrayList<String> categoryIdList2 = new ArrayList<String>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    HyCategoryYunStatusRelation relation = (HyCategoryYunStatusRelation)iterator.next();
                    categoryIdList2.add(relation.getSubCategoryId());
                }
                CmsArticleExample articleExample2 = new CmsArticleExample();
                CmsArticleExample.Criteria articleExampleCriteria2 = articleExample2.createCriteria();
                articleExampleCriteria2.andCategoryIdIn(categoryIdList2);
                List<ArticleVo> articleVoList2 = this.findArticleVoList(null, articleExample2, SpUserInfo.getUserId());
                if (articleVoList2 != null) {
                    if (articleVoList2.size() > 2) {
                        while (articleIdSet.size() < 2) {
                            int index = (int)(Math.random() * (double)articleVoList2.size());
                            if (!articleIdSet.add(articleVoList2.get(index).getId())) continue;
                            result.add(articleVoList2.get(index));
                        }
                        yunStatusflag = true;
                    } else if (articleVoList2.size() > 0) {
                        for (ArticleVo vo : articleVoList2) {
                            if (!articleIdSet.add(vo.getId())) continue;
                            result.add(vo);
                        }
                        yunStatusflag = true;
                    }
                }
            }
        }
        if (!yunStatusflag && mongoDictionary != null) {
            if (mongoDictionary.getStr1() != null && mongoDictionary.getStr1().trim().length() > 0) {
                int index;
                categoryList = this.categoryService.findByParentId(mongoDictionary.getStr1(), null);
                categoryIdList = new ArrayList<String>();
                if (categoryList != null && categoryList.size() > 0) {
                    for (Category category : categoryList) {
                        categoryIdList.add(category.getId());
                    }
                }
                articleExample = new CmsArticleExample();
                articleExampleCriteria = articleExample.createCriteria();
                articleExampleCriteria.andDelFlagEqualTo("0");
                if (articleIdSet.size() > 0) {
                    articleExampleCriteria.andIdNotIn(new ArrayList(articleIdSet));
                }
                if (categoryIdList.size() > 0) {
                    articleExampleCriteria.andCategoryIdIn(categoryIdList);
                }
                if ((articleVoList = this.findArticleVoList(null, (CmsArticleExample)articleExample, SpUserInfo.getUserId())) != null && articleVoList.size() > 0 && articleIdSet.add(articleVoList.get(index = (int)(Math.random() * (double)articleVoList.size())).getId())) {
                    result.add(articleVoList.get(index));
                }
            }
            if (mongoDictionary.getStr2() != null && mongoDictionary.getStr2().trim().length() > 0) {
                int index;
                categoryList = this.categoryService.findByParentId(mongoDictionary.getStr2(), null);
                categoryIdList = new ArrayList();
                if (categoryList != null && categoryList.size() > 0) {
                    for (Category category : categoryList) {
                        categoryIdList.add(category.getId());
                    }
                }
                articleExample = new CmsArticleExample();
                articleExampleCriteria = articleExample.createCriteria();
                articleExampleCriteria.andDelFlagEqualTo("0");
                if (articleIdSet.size() > 0) {
                    articleExampleCriteria.andIdNotIn(new ArrayList(articleIdSet));
                }
                if (categoryIdList.size() > 0) {
                    articleExampleCriteria.andCategoryIdIn(categoryIdList);
                }
                if ((articleVoList = this.findArticleVoList(null, (CmsArticleExample)articleExample, SpUserInfo.getUserId())) != null && articleVoList.size() > 0 && articleIdSet.add(articleVoList.get(index = (int)(Math.random() * (double)articleVoList.size())).getId())) {
                    result.add(articleVoList.get(index));
                }
            }
        }
        if (mongoDictionary != null && mongoDictionary.getStr3() != null && mongoDictionary.getStr3().trim().length() > 0) {
            int index;
            categoryList = this.categoryService.findByParentId(mongoDictionary.getStr3(), null);
            categoryIdList = new ArrayList();
            if (categoryList != null && categoryList.size() > 0) {
                for (Category category : categoryList) {
                    categoryIdList.add(category.getId());
                }
            }
            articleExample = new CmsArticleExample();
            articleExampleCriteria = articleExample.createCriteria();
            articleExampleCriteria.andDelFlagEqualTo("0");
            if (articleIdSet.size() > 0) {
                articleExampleCriteria.andIdNotIn(new ArrayList(articleIdSet));
            }
            if (categoryIdList.size() > 0) {
                articleExampleCriteria.andCategoryIdIn(categoryIdList);
            }
            if ((articleVoList = this.findArticleVoList(null, (CmsArticleExample)articleExample, SpUserInfo.getUserId())) != null && articleVoList.size() > 0 && articleIdSet.add(articleVoList.get(index = (int)(Math.random() * (double)articleVoList.size())).getId())) {
                result.add(articleVoList.get(index));
            }
        }
        return result;
    }

    public List<ArticleVo> findYunStatusArticle(String userId) {
        HyUserYunStatusVo yunStatusVo;
        ArrayList<ArticleVo> result = null;
        if (userId != null && userId.trim().length() > 0 && (yunStatusVo = this.hyUserYunStatusService.queryHyUserYunStatusVo(userId)) != null && yunStatusVo.getStatusId() != null && yunStatusVo.getStatusId().trim().length() > 0) {
            HyCategoryYunStatusRelationExample relationExample = new HyCategoryYunStatusRelationExample();
            relationExample.createCriteria().andDelFlagEqualTo("0").andSubYunStatusIdEqualTo(yunStatusVo.getStatusId());
            List<HyCategoryYunStatusRelation> list = this.hyCategoryYunStatusRelationDao.selectByExample(relationExample);
            if (list != null && list.size() > 0) {
                ArrayList<String> categoryIdList = new ArrayList<String>();
                for (HyCategoryYunStatusRelation relation : list) {
                    categoryIdList.add(relation.getSubCategoryId());
                }
                CmsArticleExample articleExample = new CmsArticleExample();
                CmsArticleExample.Criteria articleExampleCriteria = articleExample.createCriteria();
                articleExampleCriteria.andCategoryIdIn(categoryIdList);
                List<ArticleVo> articleVoList = this.findArticleVoList(null, articleExample, SpUserInfo.getUserId());
                if (articleVoList != null && articleVoList.size() > 0) {
                    result = new ArrayList<ArticleVo>();
                    if (articleVoList.size() <= 5) {
                        return articleVoList;
                    }
                    HashSet<String> articleIdSet = new HashSet<String>();
                    while (articleIdSet.size() < 5) {
                        int index = (int)(Math.random() * (double)articleVoList.size());
                        if (!articleIdSet.add(articleVoList.get(index).getId())) continue;
                        result.add(articleVoList.get(index));
                    }
                }
            }
        }
        return result;
    }
}

