/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyDoctorManageOrderBean;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyDoctorManageOrderCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyUserYunStatusVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.UserDetailVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyDoctorManageOrderDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserAccountDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserAccountDetailDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDoctorManageOrder;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyLabelSubCategory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyScheme;
import com.cxqm.xiaoerke.modules.haoyun.entity.HySchemeDoctor;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyYunSubStatus;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserAccount;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserAccountDetail;
import com.cxqm.xiaoerke.modules.haoyun.enums.GraphicOrderStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.HyDoctorManageOrderEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.HyDoctorManageOrderRefundStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.example.HyDoctorManageOrderExample;
import com.cxqm.xiaoerke.modules.haoyun.example.SysUserAccountDetailExample;
import com.cxqm.xiaoerke.modules.haoyun.example.SysUserAccountExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorManageOrderService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorManagePlanService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyLabelSubCategoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HySchemeDoctorService;
import com.cxqm.xiaoerke.modules.haoyun.service.HySchemeService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserLabelService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserYunStatusService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyYunSubStatusService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountDetailService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyDoctorManageOrderServiceImpl
implements HyDoctorManageOrderService {
    @Autowired
    HyDoctorManageOrderDao hyDoctorManageOrderDao;
    @Autowired
    HyDoctorManagePlanService hyDoctorManagePlanService;
    @Autowired
    HySchemeService hySchemeService;
    @Autowired
    HyUserLabelService hyUserLabelService;
    @Autowired
    UserInfoService userInfoService;
    @Autowired
    HyUserYunStatusService hyUserYunStatusService;
    @Autowired
    HyYunSubStatusService hyYunSubStatusService;
    @Autowired
    HySchemeDoctorService hySchemeDoctorService;
    @Autowired
    HyLabelSubCategoryService hyLabelSubCategoryService;
    @Autowired
    SysUserAccountDetailDao sysUserAccountDetailDao;
    @Autowired
    SysUserAccountDao sysUserAccountDao;
    @Autowired
    SysUserAccountDetailService sysUserAccountDetailService;

    public void refundOrder(String id, String userId) {
        HyDoctorManageOrder hyDoctorManageOrder = new HyDoctorManageOrder();
        Date date = new Date();
        hyDoctorManageOrder.setId(id);
        hyDoctorManageOrder.setUpdateBy(new User(userId));
        hyDoctorManageOrder.setUpdateDate(date);
        hyDoctorManageOrder.setOperationTime(date);
        hyDoctorManageOrder.setRefundStatus(HyDoctorManageOrderRefundStatusEnum.AGREE_REFUND.getCode());
        hyDoctorManageOrder.setOrderStatus(HyDoctorManageOrderEnum.ORDER_REFUND.getCode());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(hyDoctorManageOrder);
    }

    public void refuseRefundOrder(String id, String userId, String refundReason) {
        HyDoctorManageOrder hyDoctorManageOrder = new HyDoctorManageOrder();
        Date date = new Date();
        hyDoctorManageOrder.setId(id);
        hyDoctorManageOrder.setUpdateBy(new User(userId));
        hyDoctorManageOrder.setUpdateDate(date);
        hyDoctorManageOrder.setOperationTime(date);
        hyDoctorManageOrder.setRefundReason(refundReason);
        hyDoctorManageOrder.setRefundStatus(HyDoctorManageOrderRefundStatusEnum.REFUSE_REFUND.getCode());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(hyDoctorManageOrder);
    }

    public void applyRefundOrder(String id, String userId, String refundReason) {
        HyDoctorManageOrder hyDoctorManageOrder = new HyDoctorManageOrder();
        Date date = new Date();
        hyDoctorManageOrder.setId(id);
        hyDoctorManageOrder.setUpdateBy(new User(userId));
        hyDoctorManageOrder.setUpdateDate(date);
        hyDoctorManageOrder.setOperationTime(date);
        hyDoctorManageOrder.setRefundReason(refundReason);
        hyDoctorManageOrder.setRefundStatus(HyDoctorManageOrderRefundStatusEnum.APPLY_REFUND_WAITING.getCode());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(hyDoctorManageOrder);
    }

    public List<User> queryUserList() {
        return this.hyDoctorManageOrderDao.queryUserList();
    }

    public List<User> queryDoctorList() {
        return this.hyDoctorManageOrderDao.queryDoctorList();
    }

    public Page<HyDoctorManageOrderBean> queryAlreadyPaidPage(Page<HyDoctorManageOrderBean> page, HyDoctorManageOrderBean hyDoctorManageOrderBean) {
        hyDoctorManageOrderBean = hyDoctorManageOrderBean == null ? new HyDoctorManageOrderBean() : hyDoctorManageOrderBean;
        hyDoctorManageOrderBean.setAlreadyPaid(true);
        return this.hyDoctorManageOrderDao.queryPage(page, hyDoctorManageOrderBean);
    }

    public Page<HyDoctorManageOrderBean> queryApplyRefundPage(Page<HyDoctorManageOrderBean> page, HyDoctorManageOrderBean hyDoctorManageOrderBean) {
        hyDoctorManageOrderBean = hyDoctorManageOrderBean == null ? new HyDoctorManageOrderBean() : hyDoctorManageOrderBean;
        hyDoctorManageOrderBean.setRefundStatus(HyDoctorManageOrderRefundStatusEnum.APPLY_REFUND_WAITING.getCode());
        return this.hyDoctorManageOrderDao.queryPage(page, hyDoctorManageOrderBean);
    }

    public void payOrderInvalid(String orderId) {
        HyDoctorManageOrder order = this.queryById(orderId);
        if (order.getOrderStatus().equals(HyDoctorManageOrderEnum.DOCTOR_AGREE.getCode()) || order.getOrderStatus().equals(HyDoctorManageOrderEnum.WAIT_USER_AGREE.getCode())) {
            order.setOrderStatus(HyDoctorManageOrderEnum.ORDER_PAY_INVALID.getCode());
            order.setOperationTime(new Date());
            this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
        }
    }

    public boolean currentOrderIsExist(String doctorUserId, String userId) {
        HyDoctorManageOrderExample example = new HyDoctorManageOrderExample();
        HyDoctorManageOrderExample example1 = new HyDoctorManageOrderExample();
        HyDoctorManageOrderExample example2 = new HyDoctorManageOrderExample();
        HyDoctorManageOrderExample example3 = new HyDoctorManageOrderExample();
        example.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andUserIdEqualTo(userId).andOrderStatusEqualTo(HyDoctorManageOrderEnum.WAIT_DOTOC_AGREE.getCode());
        example1.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andUserIdEqualTo(userId).andOrderStatusEqualTo(HyDoctorManageOrderEnum.DOCTOR_AGREE.getCode());
        example2.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andUserIdEqualTo(userId).andOrderStatusEqualTo(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode());
        example3.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andUserIdEqualTo(userId).andOrderStatusEqualTo(HyDoctorManageOrderEnum.WAIT_USER_AGREE.getCode());
        example.or(example1.createCriteria());
        example.or(example2.createCriteria());
        example.or(example3.createCriteria());
        List<HyDoctorManageOrder> list = this.hyDoctorManageOrderDao.selectByExample(example);
        return list != null && list.size() != 0;
    }

    public HyDoctorManageOrder queryManageOrderByOrderId(String id) {
        return this.hyDoctorManageOrderDao.selectByPrimaryKey(id);
    }

    public HyDoctorManageOrder queryByOrderNo(String orderNo) {
        HyDoctorManageOrderExample example = new HyDoctorManageOrderExample();
        example.createCriteria().andOrderNoEqualTo(orderNo);
        List<HyDoctorManageOrder> list = this.hyDoctorManageOrderDao.selectByExample(example);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public void doctorInviteInvalid(String orderId) {
        HyDoctorManageOrder order = this.queryById(orderId);
        if (order.getOrderStatus().equals(HyDoctorManageOrderEnum.WAIT_USER_AGREE.getCode())) {
            order.setOrderStatus(HyDoctorManageOrderEnum.DOCTOR_INVITATION_INVALID.getCode());
            order.setOperationTime(new Date());
            this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
        }
    }

    public void userInviteInvalid(String orderId) {
        HyDoctorManageOrder order = this.queryById(orderId);
        if (order.getOrderStatus().equals(HyDoctorManageOrderEnum.WAIT_DOTOC_AGREE.getCode())) {
            order.setOrderStatus(HyDoctorManageOrderEnum.USER_INVITATION_INVALID.getCode());
            order.setOperationTime(new Date());
            this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
        }
    }

    public void orderInvalid(String orderId) {
        HyDoctorManageOrder order = this.queryById(orderId);
        if (order.getOrderStatus().equals(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode())) {
            order.setOrderStatus(HyDoctorManageOrderEnum.ORDER_END.getCode());
            order.setOperationTime(new Date());
            this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
        }
    }

    public HyDoctorManageOrder createOrderByUserId(String userId, String schemeId, String doctorId, String price) {
        HyDoctorManageOrder order = new HyDoctorManageOrder();
        order.setId(IdGen.vestaId());
        order.setOrderNo(IdGen.vestaId());
        order.setPrice(Integer.valueOf((int)(Double.parseDouble(price) * 100.0)));
        order.setOrderStatus(HyDoctorManageOrderEnum.WAIT_USER_AGREE.getCode());
        order.setHySchemeId(schemeId);
        order.setUserId(userId);
        order.setDoctorUserId(doctorId);
        order.setCreateBy(new User(doctorId));
        order.setCreateDate(new Date());
        order.setOperationTime(new Date());
        order.setDelFlag("0");
        this.hyDoctorManageOrderDao.insertSelective(order);
        return order;
    }

    public HyDoctorManageOrder createOrder(String doctorId, String schemeId, String userId, String price) {
        HyDoctorManageOrder order = new HyDoctorManageOrder();
        order.setId(IdGen.vestaId());
        order.setOrderNo(IdGen.vestaId());
        order.setPrice(Integer.valueOf((int)(Double.parseDouble(price) * 100.0)));
        order.setOrderStatus(HyDoctorManageOrderEnum.WAIT_DOTOC_AGREE.getCode());
        order.setHySchemeId(schemeId);
        order.setUserId(userId);
        order.setDoctorUserId(doctorId);
        order.setCreateBy(new User(userId));
        order.setCreateDate(new Date());
        order.setOperationTime(new Date());
        order.setDelFlag("0");
        HySchemeDoctor hySchemeDoctor = this.hySchemeDoctorService.querySchemeByDoctorUserIdAndSchemeId(doctorId, schemeId);
        int actualPrice = 0;
        if (hySchemeDoctor != null && hySchemeDoctor.getPrice() != null) {
            actualPrice = (int)(hySchemeDoctor.getPrice() * 100.0);
        }
        order.setOriginalPrice(Integer.valueOf(actualPrice));
        this.hyDoctorManageOrderDao.insertSelective(order);
        return order;
    }

    public int queryMyDoctorNumber(String userId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setOrderStatus(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode());
        condition.setUserId(userId);
        return this.hyDoctorManageOrderDao.queryMyDoctorNumber(condition);
    }

    public void updatePayOrderStatus(String orderId, String price, String buyTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HyDoctorManageOrder order = this.queryById(orderId);
        order.setActualPrice(Integer.valueOf(Integer.parseInt(price)));
        order.setEndTime(endTime);
        try {
            order.setBuyTime(sdf.parse(buyTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        order.setOperationTime(new Date());
        order.setOrderStatus(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
    }

    public int queryOrderNumber(String doctorId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setDoctorUserId(doctorId);
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyDoctorManageOrderEnum.ORDER_END.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_NOT_EVALUATE.getCode().toString());
        condition.setOrderStatusCondition(list);
        return this.hyDoctorManageOrderDao.queryOrderNumber(condition);
    }

    public void userEvaluateDoctor(String orderId, String content, Integer key, Integer key2, Integer key3) {
        HyDoctorManageOrder order = this.queryById(orderId);
        order.setEvaluateMajorNum(key);
        order.setEvaluateReplyNum(key2);
        order.setEvaluateServiceNum(key3);
        order.setUpdateBy(new User(order.getUserId()));
        order.setUpdateDate(new Date());
        order.setRemarks(content);
        order.setOperationTime(new Date());
        order.setOrderStatus(HyDoctorManageOrderEnum.USER_EVALUATE.getCode());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
    }

    public Page<HyDoctorManageOrderBean> queryMyOrderHistory(Page<HyDoctorManageOrderBean> page, String userId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setUserId(userId);
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyDoctorManageOrderEnum.ORDER_END.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_NOT_EVALUATE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.ORDER_REFUND.getCode().toString());
        list.add(HyDoctorManageOrderEnum.ORDER_PAY_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.ORDER_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_REFUSE.getCode().toString());
        condition.setOrderStatusCondition(list);
        return this.hyDoctorManageOrderDao.queryDoctorHistoryPage(page, condition);
    }

    public Page<HyDoctorManageOrderBean> queryMyOrder(Page<HyDoctorManageOrderBean> page, String userId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setUserId(userId);
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyDoctorManageOrderEnum.WAIT_DOTOC_AGREE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.DOCTOR_AGREE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.WAIT_USER_AGREE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode().toString());
        condition.setOrderStatusCondition(list);
        return this.hyDoctorManageOrderDao.queryDoctorHistoryPage(page, condition);
    }

    public Page<HyDoctorManageOrderBean> queryManageDoctor(Page<HyDoctorManageOrder> page, String userId, String name) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setUserId(userId);
        condition.setVagueName(name);
        return this.hyDoctorManageOrderDao.queryManageDoctor(page, condition);
    }

    public Page<HyDoctorManageOrderBean> queryExecutionOrder(Page<HyDoctorManageOrder> page, String doctorId, String status, String scheme, String label) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setDoctorUserId(doctorId);
        if (label != null && !"".equals(label == null ? "" : label.trim())) {
            String[] labels = label.split(",");
            ArrayList<String> labelList = new ArrayList<String>();
            for (String l : labels) {
                labelList.add(l);
            }
            condition.setLabelList(labelList);
        }
        if (scheme != null && !"".equals(scheme == null ? "" : scheme.trim())) {
            String[] schemes = scheme.split(",");
            ArrayList<String> schemeList = new ArrayList<String>();
            for (String l : schemes) {
                schemeList.add(l);
            }
            condition.setSchemeList(schemeList);
        }
        if (status != null && !"".equals(status == null ? "" : status.trim())) {
            String[] statuss = status.split(",");
            ArrayList<String> statusList = new ArrayList<String>();
            for (String l : statuss) {
                statusList.add(l);
            }
            condition.setStatusList(statusList);
        }
        condition.setOrderStatus(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode());
        return this.hyDoctorManageOrderDao.queryExecutionOrder(page, condition);
    }

    public UserDetailVo queryUserDetail(String userId, String orderId) {
        User user = this.userInfoService.getUserById(userId);
        UserDetailVo userDetailVo = new UserDetailVo();
        this.packageUser(userDetailVo, user);
        List list = this.hyLabelSubCategoryService.queryByUserId(orderId);
        userDetailVo.setLabelList(list);
        HyYunSubStatus status = this.hyYunSubStatusService.queryStatusByUserId(user.getId());
        userDetailVo.setStatusName(status == null ? "" : status.getName());
        return userDetailVo;
    }

    public Page<HyDoctorManageOrderBean> queryApplying(Page<HyDoctorManageOrder> page, String doctorId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setDoctorUserId(doctorId);
        condition.setOrderStatus(HyDoctorManageOrderEnum.WAIT_DOTOC_AGREE.getCode());
        return this.hyDoctorManageOrderDao.queryApplying(page, condition);
    }

    public Page<HyDoctorManageOrderBean> queryNotPayment(Page<HyDoctorManageOrder> page, String doctorId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setDoctorUserId(doctorId);
        condition.setOrderStatus(HyDoctorManageOrderEnum.DOCTOR_AGREE.getCode());
        return this.hyDoctorManageOrderDao.queryNotPayment(page, condition);
    }

    public List<HyLabelSubCategory> queryManageDistinctLabel(String doctorId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setDoctorUserId(doctorId);
        condition.setOrderStatus(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode());
        return this.hyDoctorManageOrderDao.queryHistoryDistinctLabel(condition);
    }

    public List<HyScheme> queryManageDistinctScheme(String doctorId) {
        List schemeDoctorList = this.hySchemeDoctorService.querySchemeList(doctorId);
        if (schemeDoctorList == null || schemeDoctorList.size() == 0) {
            return null;
        }
        ArrayList<HyScheme> list = new ArrayList<HyScheme>();
        for (HySchemeDoctor hySchemeDoctor : schemeDoctorList) {
            list.add(hySchemeDoctor.getHyScheme());
        }
        return list;
    }

    public List<HyLabelSubCategory> queryHistoryDistinctLabel(String doctorId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyDoctorManageOrderEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_REFUSE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.ORDER_END.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_NOT_EVALUATE.getCode().toString());
        condition.setOrderStatusCondition(list);
        condition.setDoctorUserId(doctorId);
        return this.hyDoctorManageOrderDao.queryHistoryDistinctLabel(condition);
    }

    public List<HyLabelSubCategory> queryManageLabel(String doctorId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode().toString());
        condition.setOrderStatusCondition(list);
        condition.setDoctorUserId(doctorId);
        return this.hyDoctorManageOrderDao.queryHistoryDistinctLabel(condition);
    }

    public List<HyScheme> queryHistoryDistinctScheme(String doctorId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setDoctorUserId(doctorId);
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyDoctorManageOrderEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_REFUSE.getCode().toString());
        condition.setOrderStatusCondition(list);
        return this.hyDoctorManageOrderDao.queryHistoryDistinctScheme(condition);
    }

    public Page<HyDoctorManageOrderBean> queryDoctorHistoryPageByDoctorId(Page<HyDoctorManageOrderBean> page, String doctorId, String status, String scheme, String label) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setDoctorUserId(doctorId);
        if (label != null && !"".equals(label == null ? "" : label.trim())) {
            String[] labels = label.split(",");
            ArrayList<String> labelList = new ArrayList<String>();
            for (String l : labels) {
                labelList.add(l);
            }
            condition.setLabelList(labelList);
        }
        if (scheme != null && !"".equals(scheme == null ? "" : scheme.trim())) {
            String[] schemes = scheme.split(",");
            ArrayList<String> schemeList = new ArrayList<String>();
            for (String l : schemes) {
                schemeList.add(l);
            }
            condition.setSchemeList(schemeList);
        }
        if (status != null && !"".equals(status == null ? "" : status.trim())) {
            String[] statuss = status.split(",");
            ArrayList<String> statusList = new ArrayList<String>();
            for (String l : statuss) {
                statusList.add(l);
            }
            condition.setStatusList(statusList);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyDoctorManageOrderEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_EVALUATE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_REFUSE.getCode().toString());
        list.add(HyDoctorManageOrderEnum.ORDER_END.getCode().toString());
        list.add(HyDoctorManageOrderEnum.ORDER_REFUND.getCode().toString());
        list.add(HyDoctorManageOrderEnum.ORDER_PAY_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.ORDER_INVALID.getCode().toString());
        list.add(HyDoctorManageOrderEnum.USER_NOT_EVALUATE.getCode().toString());
        condition.setOrderStatusCondition(list);
        Page<HyDoctorManageOrderBean> orderBeanPage = this.hyDoctorManageOrderDao.queryDoctorHistoryPage(page, condition);
        List orderBeanList = orderBeanPage.getList();
        if (orderBeanList == null || orderBeanList.size() == 0) {
            return null;
        }
        for (HyDoctorManageOrderBean bean : orderBeanList) {
            bean.setStatusName(HyDoctorManageOrderEnum.parseStatus((Integer)bean.getOrderStatus()).getValue());
        }
        orderBeanPage.setList(orderBeanList);
        return orderBeanPage;
    }

    public HyDoctorManageOrder queryById(String id) {
        HyDoctorManageOrderExample example = new HyDoctorManageOrderExample();
        example.createCriteria().andIdEqualTo(id);
        List<HyDoctorManageOrder> list = this.hyDoctorManageOrderDao.selectByExample(example);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public UserDetailVo packageUserDetailVo(String doctorUserId, String orderId) {
        HyDoctorManageOrder hyDoctorManageOrder = this.queryById(orderId);
        User user = this.userInfoService.getUserById(hyDoctorManageOrder.getUserId());
        UserDetailVo userDetailVo = new UserDetailVo();
        Page currentPlanList = this.hyDoctorManagePlanService.queryCurrentPlanByDoctorUserIdAndUserId(new Page(1, 10), doctorUserId, user.getId());
        Page historyPlanList = this.hyDoctorManagePlanService.queryHistoryPlanByDoctorUserIdAndUserId(new Page(1, 10), doctorUserId, user.getId());
        HyUserYunStatusVo hyUserYunStatusVo = this.hyUserYunStatusService.queryHyUserYunStatusVo(user.getId());
        userDetailVo.setCurrentPlanList(currentPlanList);
        userDetailVo.setHistoryPlanList(historyPlanList);
        if (hyUserYunStatusVo != null && hyUserYunStatusVo.getHyYunSubStatusVo() != null) {
            userDetailVo.setStatusName(hyUserYunStatusVo.getHyYunSubStatusVo().getName());
        }
        List list = this.hyLabelSubCategoryService.queryByUserId(orderId);
        userDetailVo.setLabelList(list);
        this.packageUser(userDetailVo, user);
        return userDetailVo;
    }

    private void packageUser(UserDetailVo userDetailVo, User user) {
        userDetailVo.setId(user.getId());
        userDetailVo.setName(user.getName());
        userDetailVo.setBuckter(user.getBuckter());
        userDetailVo.setMarketer(user.getMarketer());
        userDetailVo.setPhoto(user.getPhoto());
        userDetailVo.setSex(user.getSex());
        userDetailVo.setDetailedAddress(user.getDetailedAddress());
        userDetailVo.setHeight(user.getHeight());
        userDetailVo.setWeight(user.getWeight());
        userDetailVo.setBirthDate(user.getBirthDate());
        userDetailVo.setRegion(user.getRegion());
    }

    public void selectedUser(String userId, String planId, String currentUserId) {
        HyDoctorManageOrder hyDoctorManageOrder = new HyDoctorManageOrder();
        hyDoctorManageOrder.setId(IdGen.vestaId());
        hyDoctorManageOrder.setDoctorUserId(currentUserId);
        hyDoctorManageOrder.setUserId(userId);
        hyDoctorManageOrder.setOrderNo(IdGen.vestaId());
        hyDoctorManageOrder.setCreateBy(new User(currentUserId));
        hyDoctorManageOrder.setCreateDate(new Date());
        hyDoctorManageOrder.setHySchemeId(planId);
        hyDoctorManageOrder.setDelFlag("0");
        hyDoctorManageOrder.setOrderStatus(HyDoctorManageOrderEnum.WAIT_USER_AGREE.getCode());
        hyDoctorManageOrder.setOperationTime(new Date());
        this.hyDoctorManageOrderDao.insertSelective(hyDoctorManageOrder);
    }

    public void agreeManage(String doctorUserId, String orderId) {
        HyDoctorManageOrderExample example = new HyDoctorManageOrderExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<HyDoctorManageOrder> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        HyDoctorManageOrder order = list.get(0);
        order.setOrderStatus(HyDoctorManageOrderEnum.DOCTOR_AGREE.getCode());
        order.setUpdateBy(new User(doctorUserId));
        order.setUpdateDate(new Date());
        order.setOperationTime(new Date());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
    }

    public void refuseManage(String doctorUserId, String orderId) {
        HyDoctorManageOrderExample example = new HyDoctorManageOrderExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<HyDoctorManageOrder> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        HyDoctorManageOrder order = list.get(0);
        order.setOrderStatus(HyDoctorManageOrderEnum.DOCTOR_REFUSE.getCode());
        order.setUpdateBy(new User(doctorUserId));
        order.setUpdateDate(new Date());
        order.setOperationTime(new Date());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
    }

    public void userEndManage(String orderId) {
        HyDoctorManageOrderExample example = new HyDoctorManageOrderExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<HyDoctorManageOrder> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        HyDoctorManageOrder order = list.get(0);
        order.setOrderStatus(HyDoctorManageOrderEnum.ORDER_END.getCode());
        order.setUpdateBy(new User(order.getUserId()));
        order.setUpdateDate(new Date());
        order.setOperationTime(new Date());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
    }

    public void userRefuseManage(String orderId) {
        HyDoctorManageOrderExample example = new HyDoctorManageOrderExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<HyDoctorManageOrder> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        HyDoctorManageOrder order = list.get(0);
        order.setOrderStatus(HyDoctorManageOrderEnum.DOCTOR_REFUSE.getCode());
        order.setUpdateBy(new User(order.getUserId()));
        order.setUpdateDate(new Date());
        order.setOperationTime(new Date());
        this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(order);
    }

    public Page<HyDoctorManageOrderBean> queryPageByDoctorUserId(Page<HyDoctorManageOrderBean> page, String userId) {
        HyDoctorManageOrderBean bean = new HyDoctorManageOrderBean();
        bean.setDoctorUserId(userId);
        return this.hyDoctorManageOrderDao.queryPage(page, bean);
    }

    public Page<HyDoctorManageOrderBean> queryPageByUserId(Page<HyDoctorManageOrderBean> page, String userId) {
        HyDoctorManageOrderBean bean = new HyDoctorManageOrderBean();
        bean.setUserId(userId);
        return this.hyDoctorManageOrderDao.queryPage(page, bean);
    }

    public void selectedDoctor(String doctorUserId, String userId) {
        HyDoctorManageOrder hyDoctorManageOrder = new HyDoctorManageOrder();
        hyDoctorManageOrder.setId(IdGen.vestaId());
        hyDoctorManageOrder.setDoctorUserId(doctorUserId);
        hyDoctorManageOrder.setUserId(userId);
        hyDoctorManageOrder.setOrderNo(IdGen.vestaId());
        hyDoctorManageOrder.setCreateBy(new User(userId));
        hyDoctorManageOrder.setCreateDate(new Date());
        hyDoctorManageOrder.setDelFlag("0");
        hyDoctorManageOrder.setOrderStatus(HyDoctorManageOrderEnum.WAIT_DOTOC_AGREE.getCode());
        hyDoctorManageOrder.setOperationTime(new Date());
        this.hyDoctorManageOrderDao.insertSelective(hyDoctorManageOrder);
    }

    public int doctorManageCount(String doctorUserId) {
        HyDoctorManageOrderExample query = new HyDoctorManageOrderExample();
        query.createCriteria().andDoctorUserIdEqualTo(doctorUserId).andOrderStatusEqualTo(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode());
        return this.hyDoctorManageOrderDao.countByExample(query);
    }

    public int update(HyDoctorManageOrder record) {
        return this.hyDoctorManageOrderDao.updateByPrimaryKeySelective(record);
    }

    public void ManageOrderAdmission(Date date) {
        if (date == null) {
            date = new Date();
        }
        boolean haveNext = true;
        int pageNo = 1;
        int pageSize = 200;
        HyDoctorManageOrder query = new HyDoctorManageOrder();
        query.setOperationTime(date);
        query.setOrderStatus(HyDoctorManageOrderEnum.USER_PAY_SUCCESS.getCode());
        while (haveNext) {
            Page<HyDoctorManageOrder> page = this.hyDoctorManageOrderDao.queryPages((Page<HyDoctorManageOrder>)new Page(pageNo, pageSize), query);
            if (page.isLastPage()) {
                haveNext = false;
            }
            pageNo = page.getNext();
            for (int i = 0; i < page.getList().size(); ++i) {
                HyDoctorManageOrder hyDoctorManageOrder = (HyDoctorManageOrder)page.getList().get(i);
                this.admission(hyDoctorManageOrder, date);
            }
        }
    }

    public void admission(HyDoctorManageOrder hyDoctorManageOrder, Date date) {
        SysUserAccountExample sysUserAccountExample = new SysUserAccountExample();
        sysUserAccountExample.createCriteria().andSysUserIdEqualTo(hyDoctorManageOrder.getDoctorUserId());
        List<SysUserAccount> accountlist = this.sysUserAccountDao.selectByExample(sysUserAccountExample);
        SysUserAccount account = null;
        if (accountlist != null && accountlist.size() > 0) {
            account = accountlist.get(0);
        }
        if (account != null) {
            Date orderEnd;
            int unAdmissionDays;
            SysUserAccountDetailExample query = new SysUserAccountDetailExample();
            query.createCriteria().andSysUserAccountIdEqualTo(account.getId()).andSpare3EqualTo(hyDoctorManageOrder.getId());
            query.setOrderByClause(" this_time desc ");
            List<SysUserAccountDetail> list = this.sysUserAccountDetailDao.selectByExample(query);
            Date lastAdmission = hyDoctorManageOrder.getBuyTime();
            if (list != null && list.size() > 0) {
                lastAdmission = list.get(0).getThisTime();
            }
            if ((unAdmissionDays = HyDoctorManageOrderServiceImpl.daysBetween(lastAdmission, orderEnd = hyDoctorManageOrder.getEndTime())) > 0) {
                int doctorGet = hyDoctorManageOrder.getDoctorGet();
                int yidakuan = 0;
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        yidakuan += list.get(i).getPrice().intValue();
                    }
                }
                int ruzhang = 0;
                if (HyDoctorManageOrderServiceImpl.daysBetween(date, orderEnd) <= 0) {
                    ruzhang = doctorGet - yidakuan;
                } else {
                    int currentDays = HyDoctorManageOrderServiceImpl.daysBetween(lastAdmission, date);
                    int unAdmissionPrice = doctorGet - yidakuan;
                    ruzhang = (int)((float)unAdmissionPrice / (float)unAdmissionDays * (float)currentDays);
                }
                String spare1 = null;
                Integer allActualPrice = null;
                if (list != null && list.size() > 0) {
                    spare1 = list.get(0).getSpare1();
                    String temp = list.get(0).getSpare2();
                    if (temp != null && temp.trim().length() > 0) {
                        allActualPrice = Integer.parseInt(temp);
                    }
                }
                this.sysUserAccountDetailService.saveDoctorManageUserAccountDetail(account.getSysUserId(), Integer.valueOf(ruzhang), allActualPrice, date, spare1, hyDoctorManageOrder.getUserId(), hyDoctorManageOrder.getId());
            }
        }
    }

    public static int daysBetween(Date smdate, Date bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    private List<HyDoctorManageOrder> queryList(HyDoctorManageOrderExample example) {
        return this.hyDoctorManageOrderDao.selectByExample(example);
    }

    public List<String> getOverdueOrderId(String userId) {
        return this.hyDoctorManageOrderDao.getOverdueOrderId(userId, GraphicOrderStatusEnum.END.getValue());
    }
}

