/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyDoctorManagePlanBean;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyDoctorManagePlanCondition;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyDoctorManagePlanDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDoctorManageOrder;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDoctorManagePlan;
import com.cxqm.xiaoerke.modules.haoyun.enums.HyDoctorManagePlanEnum;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorManageOrderService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorManagePlanService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyPlanUserService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import com.zthzinfo.delaytask.service.DelayTaskService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyDoctorManagePlanServiceImpl
implements HyDoctorManagePlanService {
    @Autowired
    HyDoctorManagePlanDao hyDoctorManagePlanDao;
    @Autowired
    HyPlanUserService hyPlanUserService;
    @Autowired
    DelayTaskService delayTaskService;
    @Autowired
    HyDoctorManageOrderService hyDoctorManageOrderService;
    @Autowired
    UserInfoService userInfoService;

    public void deleteById(String id) {
        HyDoctorManagePlan plan = this.hyDoctorManagePlanDao.selectByPrimaryKey(id);
        this.hyDoctorManagePlanDao.deleteByPrimaryKey(id);
        if (plan != null) {
            if (plan.getStartTaskId() != null && plan.getStartTaskId().trim().length() > 0) {
                try {
                    this.delayTaskService.delQuartzTask("angel", plan.getStartTaskId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (plan.getEndTaskId() != null && plan.getEndTaskId().trim().length() > 0) {
                try {
                    this.delayTaskService.delQuartzTask("angel", plan.getEndTaskId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void stopPlanById(String planId, String userId) {
        HyDoctorManagePlan plan = this.hyDoctorManagePlanDao.selectByPrimaryKey(planId);
        if (plan != null) {
            plan.setPlanStatus(HyDoctorManagePlanEnum.PLAN_STOP.getCode());
            plan.setUpdateDate(new Date());
            plan.setUpdateBy(new User(userId));
            this.hyDoctorManagePlanDao.updateByPrimaryKeySelective(plan);
            if (plan.getStartTaskId() != null && plan.getStartTaskId().trim().length() > 0) {
                try {
                    this.delayTaskService.delQuartzTask("angel", plan.getStartTaskId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (plan.getEndTaskId() != null && plan.getEndTaskId().trim().length() > 0) {
                try {
                    this.delayTaskService.delQuartzTask("angel", plan.getEndTaskId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Page<HyDoctorManagePlan> queryCurrentPlanByOrderId(Page<HyDoctorManagePlan> page, String orderId) {
        HyDoctorManageOrder hyDoctorManageOrder = this.hyDoctorManageOrderService.queryById(orderId);
        User user = this.userInfoService.getUserById(hyDoctorManageOrder.getUserId());
        if (hyDoctorManageOrder == null || user == null) {
            return null;
        }
        return this.queryCurrentPlanByDoctorUserIdAndUserId(page, hyDoctorManageOrder.getDoctorUserId(), user.getId());
    }

    public Page<HyDoctorManagePlan> queryHistoryPlanByOrderId(Page<HyDoctorManagePlan> page, String orderId) {
        HyDoctorManageOrder hyDoctorManageOrder = this.hyDoctorManageOrderService.queryById(orderId);
        User user = this.userInfoService.getUserById(hyDoctorManageOrder.getUserId());
        if (hyDoctorManageOrder == null || user == null) {
            return null;
        }
        return this.queryHistoryPlanByDoctorUserIdAndUserId(page, hyDoctorManageOrder.getDoctorUserId(), user.getId());
    }

    public Page<HyDoctorManagePlan> queryCurrentPlanByDoctorUserIdAndUserId(Page<HyDoctorManagePlan> page, String doctorUserId, String userId) {
        if (doctorUserId == null || doctorUserId.trim().equals("")) {
            return null;
        }
        if (userId == null || userId.trim().equals("")) {
            return null;
        }
        HyDoctorManagePlanCondition condition = new HyDoctorManagePlanCondition();
        condition.setUserId(userId);
        condition.setDoctorUserId(doctorUserId);
        ArrayList<String> list = new ArrayList<String>();
        list.add(HyDoctorManagePlanEnum.WAIT_EXECUTE_PLAN.getCode().toString());
        list.add(HyDoctorManagePlanEnum.EXECUTE_PLAN.getCode().toString());
        condition.setStatusList(list);
        return this.hyDoctorManagePlanDao.queryCurrentPlanByDoctorUserIdAndUserId(page, condition);
    }

    public Page<HyDoctorManagePlan> queryHistoryPlanByDoctorUserIdAndUserId(Page<HyDoctorManagePlan> page, String doctorUserId, String userId) {
        if (doctorUserId == null || doctorUserId.trim().equals("")) {
            return null;
        }
        if (userId == null || userId.trim().equals("")) {
            return null;
        }
        HyDoctorManagePlanCondition condition = new HyDoctorManagePlanCondition();
        condition.setUserId(userId);
        condition.setDoctorUserId(doctorUserId);
        condition.setPlanStatus(HyDoctorManagePlanEnum.PLAN_END.getCode());
        return this.hyDoctorManagePlanDao.queryHistoryPlanByDoctorUserIdAndUserId(page, condition);
    }

    public List<HyDoctorManagePlan> queryByDoctorUserIdAndUserId(String doctorUserId, String userId) {
        if (doctorUserId == null || doctorUserId.trim().equals("")) {
            return null;
        }
        if (userId == null || userId.trim().equals("")) {
            return null;
        }
        HyDoctorManagePlanCondition condition = new HyDoctorManagePlanCondition();
        condition.setUserId(userId);
        condition.setDoctorUserId(doctorUserId);
        List<HyDoctorManagePlan> list = this.hyDoctorManagePlanDao.queryDoctorManageListByCondition(condition);
        return list;
    }

    public HyDoctorManagePlanBean queryById(String id) {
        return this.hyDoctorManagePlanDao.queryById(id);
    }

    public List<HyDoctorManagePlan> queryDoctorManagePlanList(Date startTime, Date endTime, String userId) {
        return this.hyDoctorManagePlanDao.queryDoctorManagePlanList(startTime, endTime, userId);
    }

    public HyDoctorManagePlan selectByPrimaryKey(String id) {
        return this.hyDoctorManagePlanDao.selectByPrimaryKey(id);
    }

    public void update(HyDoctorManagePlan record) {
        this.hyDoctorManagePlanDao.updateByPrimaryKeySelective(record);
    }

    public Page<HyDoctorManagePlanBean> queryPageByUserId(Page<HyDoctorManagePlan> page, String currentUserId) {
        HyDoctorManagePlanCondition condition = new HyDoctorManagePlanCondition();
        condition.setUserId(currentUserId);
        return this.hyDoctorManagePlanDao.queryPage(page, condition);
    }

    public Page<HyDoctorManagePlanBean> queryPage(Page<HyDoctorManagePlan> page, String currentUserId, String status, String time) {
        Page<HyDoctorManagePlanBean> planBeanPage;
        List list;
        HyDoctorManagePlanCondition condition = new HyDoctorManagePlanCondition();
        condition.setDoctorUserId(currentUserId);
        if (status != null && !"".equals(status == null ? "" : status.trim())) {
            condition.setStatus(status);
        }
        if (time != null && !"".equals(time == null ? "" : time.trim())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                condition.setTime(sdf.parse(time));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((list = (planBeanPage = this.hyDoctorManagePlanDao.queryPage(page, condition)).getList()) == null || list.size() == 0) {
            return null;
        }
        for (HyDoctorManagePlanBean bean : list) {
            List users = this.hyPlanUserService.queryUserListByPlanId(bean.getId());
            bean.setUsers(users);
        }
        planBeanPage.setList(list);
        return planBeanPage;
    }

    public void update(String id, String title, String user_ids, String start_time, String end_time, String content, String address, String considerations, String current_user_id) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HyDoctorManagePlan hyDoctorManagePlan = new HyDoctorManagePlan();
        hyDoctorManagePlan.setId(id);
        hyDoctorManagePlan.setTitle(title);
        hyDoctorManagePlan.setAddress(address);
        hyDoctorManagePlan.setDoctorUserId(current_user_id);
        try {
            hyDoctorManagePlan.setStartTime(sdf.parse(start_time));
            hyDoctorManagePlan.setEndTime(sdf.parse(end_time));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        hyDoctorManagePlan.setContent(content);
        hyDoctorManagePlan.setConsiderations(considerations);
        hyDoctorManagePlan.setPlanStatus(HyDoctorManagePlanEnum.WAIT_EXECUTE_PLAN.getCode());
        hyDoctorManagePlan.setUpdateBy(new User(current_user_id));
        hyDoctorManagePlan.setUpdateDate(new Date());
        hyDoctorManagePlan.setDelFlag("0");
        this.hyDoctorManagePlanDao.updateByPrimaryKeySelective(hyDoctorManagePlan);
        this.updatePlanTask(hyDoctorManagePlan, user_ids);
        this.hyPlanUserService.deleteByPlanId(id);
        this.hyPlanUserService.save(user_ids, id, current_user_id, current_user_id);
    }

    private void updatePlanTask(HyDoctorManagePlan hyDoctorManagePlan, String user_ids) {
        if ((hyDoctorManagePlan = this.queryById(hyDoctorManagePlan.getId())) == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (hyDoctorManagePlan.getStartTaskId() != null && hyDoctorManagePlan.getStartTaskId().trim().length() > 0) {
            this.delayTaskService.delQuartzTask("angel", hyDoctorManagePlan.getStartTaskId());
        }
        if (hyDoctorManagePlan.getEndTaskId() != null && hyDoctorManagePlan.getEndTaskId().trim().length() > 0) {
            this.delayTaskService.delQuartzTask("angel", hyDoctorManagePlan.getEndTaskId());
        }
        try {
            Date startTime = sdf.parse(sdf.format(hyDoctorManagePlan.getStartTime()));
            Date currentDate = new Date();
            GregorianCalendar calendar1 = new GregorianCalendar();
            calendar1.setTime(currentDate);
            ((Calendar)calendar1).add(5, 1);
            calendar1.set(11, 0);
            calendar1.set(12, 0);
            calendar1.set(13, 0);
            calendar1.set(14, 0);
            Date startReferenceTime = calendar1.getTime();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)hyDoctorManagePlan.getId());
            String jsonresult = jsonObject.toString();
            String startUrl = "http://" + Global.getConfig((String)"baseUrl") + "/hy/doctorspweb/plan/remind_start";
            String startTaskId = null;
            if (!startTime.before(startReferenceTime)) {
                GregorianCalendar calendar2 = new GregorianCalendar();
                calendar2.setTime(startTime);
                ((Calendar)calendar1).add(5, -1);
                calendar2.set(11, 12);
                calendar2.set(12, 0);
                calendar2.set(13, 0);
                calendar2.set(14, 0);
                startTaskId = this.delayTaskService.genQuartzTask("angel", startUrl, jsonresult, calendar2.getTime());
            } else {
                startTaskId = this.delayTaskService.genQuartzTask("angel", startUrl, jsonresult, 0L);
            }
            hyDoctorManagePlan.setStartTaskId(startTaskId);
            Date endTime = sdf.parse(sdf.format(hyDoctorManagePlan.getEndTime()));
            GregorianCalendar calendar3 = new GregorianCalendar();
            calendar3.setTime(endTime);
            calendar3.set(11, 12);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            String endUrl = "http://" + Global.getConfig((String)"baseUrl") + "/hy/doctorspweb/plan/remind_end";
            String endTaskId = this.delayTaskService.genQuartzTask("angel", endUrl, jsonresult, calendar3.getTime());
            hyDoctorManagePlan.setEndTaskId(endTaskId);
            this.update(hyDoctorManagePlan);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public HyDoctorManagePlan save(String title, String user_ids, String start_time, String end_time, String content, String address, String considerations, String current_user_id) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HyDoctorManagePlan hyDoctorManagePlan = new HyDoctorManagePlan();
        hyDoctorManagePlan.setId(IdGen.vestaId());
        hyDoctorManagePlan.setTitle(title);
        hyDoctorManagePlan.setAddress(address);
        hyDoctorManagePlan.setDoctorUserId(current_user_id);
        try {
            hyDoctorManagePlan.setStartTime(sdf.parse(start_time));
            hyDoctorManagePlan.setEndTime(sdf.parse(end_time));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        hyDoctorManagePlan.setContent(content);
        hyDoctorManagePlan.setConsiderations(considerations);
        hyDoctorManagePlan.setPlanStatus(HyDoctorManagePlanEnum.WAIT_EXECUTE_PLAN.getCode());
        hyDoctorManagePlan.setCreateBy(new User(current_user_id));
        hyDoctorManagePlan.setCreateDate(new Date());
        hyDoctorManagePlan.setDelFlag("0");
        this.hyDoctorManagePlanDao.insertSelective(hyDoctorManagePlan);
        this.hyPlanUserService.save(user_ids, hyDoctorManagePlan.getId(), current_user_id, current_user_id);
        return hyDoctorManagePlan;
    }
}

