/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyDoctorRankingDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.DoctorRanking;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorRankingService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HyDoctorRankingServiceImpl
implements HyDoctorRankingService {
    public static final String DOCTORRANKING = "DOCTORRANKING";
    public static final String all_graphic_doctor_num = "all_graphic_doctor_num";
    public static final String all_graphic_doctor_ids = "all_graphic_doctor_ids";
    public static final String graphic = "graphic";
    public static final String all_order_doctor_num = "all_order_doctor_num";
    public static final String all_order_doctor_ids = "all_order_doctor_ids";
    public static final String order = "order";
    @Autowired
    private HyDoctorRankingDao hyDoctorRankingDao;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public List<DoctorRanking> lookgraphicRankingList() {
        JSONArray jsonArray = (JSONArray)this.redisTemplate.opsForValue().get((Object)all_graphic_doctor_ids);
        if (jsonArray == null) {
            this.tongjiGraphicFenshu();
            jsonArray = (JSONArray)this.redisTemplate.opsForValue().get((Object)all_graphic_doctor_ids);
        }
        ArrayList<DoctorRanking> list = new ArrayList<DoctorRanking>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            String redais_key = jsonArray.getString(i) + graphic;
            DoctorRanking doctorRanking = this.queryDoctorRankingById(redais_key);
            if (doctorRanking == null) continue;
            list.add(doctorRanking);
        }
        return list;
    }

    public List<DoctorRanking> lookmanageRankingList() {
        JSONArray jsonArray = (JSONArray)this.redisTemplate.opsForValue().get((Object)all_order_doctor_ids);
        if (jsonArray == null) {
            this.tongjiOrderFenshu();
            jsonArray = (JSONArray)this.redisTemplate.opsForValue().get((Object)all_order_doctor_ids);
        }
        ArrayList<DoctorRanking> list = new ArrayList<DoctorRanking>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            String redais_key = jsonArray.getString(i) + order;
            DoctorRanking doctorRanking = this.queryDoctorRankingById(redais_key);
            if (doctorRanking == null) continue;
            list.add(doctorRanking);
        }
        return list;
    }

    public int jiSuanOrder(String doctorId) {
        String redais_key = doctorId + order;
        DoctorRanking doctorRanking = this.queryDoctorRankingById(redais_key);
        int allnum = this.redisTemplate.opsForValue().get((Object)all_order_doctor_num) == null ? 0 : (Integer)this.redisTemplate.opsForValue().get((Object)all_order_doctor_num);
        if (doctorRanking == null) {
            this.tongjiOrderFenshu();
            doctorRanking = this.queryDoctorRankingById(redais_key);
            allnum = (Integer)this.redisTemplate.opsForValue().get((Object)all_order_doctor_num);
        }
        double offset = 20 / allnum;
        if (doctorRanking == null) {
            return 0;
        }
        int rank = doctorRanking.getRank();
        int tuijianzi = (int)(100.0 - (double)rank / offset);
        return tuijianzi;
    }

    public int jiSuanGraphic(String doctorId) {
        String redais_key = doctorId + graphic;
        DoctorRanking doctorRanking = this.queryDoctorRankingById(redais_key);
        int allnum = this.redisTemplate.opsForValue().get((Object)all_graphic_doctor_num) == null ? 0 : (Integer)this.redisTemplate.opsForValue().get((Object)all_graphic_doctor_num);
        if (doctorRanking == null) {
            this.tongjiGraphicFenshu();
            doctorRanking = this.queryDoctorRankingById(redais_key);
            allnum = (Integer)this.redisTemplate.opsForValue().get((Object)all_graphic_doctor_num);
        }
        double offset = 20 / allnum;
        if (doctorRanking == null) {
            return 0;
        }
        int rank = doctorRanking.getRank();
        int tuijianzi = (int)(100.0 - (double)rank / offset);
        return tuijianzi;
    }

    public void tongjiGraphicFenshu() {
        List<DoctorRanking> list = this.hyDoctorRankingDao.findGraphicRankingList();
        if (list != null && list.size() > 0) {
            JSONArray ids = new JSONArray();
            this.redisTemplate.opsForValue().set((Object)all_graphic_doctor_num, (Object)list.size());
            for (int i = 0; i < list.size(); ++i) {
                DoctorRanking doctorRanking = list.get(i);
                doctorRanking.setRank(i);
                double score = 0.0;
                if (doctorRanking.getAvgStart() != null) {
                    score = Math.pow(doctorRanking.getAvgStart() * 2.0, 4.0) * (double)doctorRanking.getOrderNum().intValue();
                }
                ids.add((Object)doctorRanking.getId());
                doctorRanking.setScore(score);
                this.redisTemplate.opsForValue().set((Object)(doctorRanking.getId() + graphic), (Object)doctorRanking);
            }
            this.redisTemplate.opsForValue().set((Object)all_graphic_doctor_ids, (Object)ids);
        }
    }

    public void tongjiOrderFenshu() {
        List<DoctorRanking> list = this.hyDoctorRankingDao.findOrderRankingList();
        if (list != null && list.size() > 0) {
            JSONArray ids = new JSONArray();
            this.redisTemplate.opsForValue().set((Object)all_order_doctor_num, (Object)list.size());
            for (int i = 0; i < list.size(); ++i) {
                DoctorRanking doctorRanking = list.get(i);
                doctorRanking.setRank(i);
                double score = 0.0;
                if (doctorRanking.getAvgStart() != null) {
                    score = Math.pow(doctorRanking.getAvgStart() * 2.0, 4.0) * (double)doctorRanking.getOrderNum().intValue();
                }
                doctorRanking.setScore(score);
                ids.add((Object)doctorRanking.getId());
                this.redisTemplate.opsForValue().set((Object)(doctorRanking.getId() + order), (Object)doctorRanking);
            }
            this.redisTemplate.opsForValue().set((Object)all_order_doctor_ids, (Object)ids);
        }
    }

    public DoctorRanking findDoctorRankingById(String id) {
        return this.hyDoctorRankingDao.findDoctorRankingById(id);
    }

    public Boolean addDoctorRankingRedis(DoctorRanking doctorRanking, String score) {
        if (doctorRanking != null) {
            return this.redisTemplate.opsForZSet().add((Object)DOCTORRANKING, (Object)doctorRanking, Double.parseDouble(score));
        }
        return false;
    }

    public DoctorRanking queryDoctorRankingById(String id) {
        DoctorRanking doctorRanking = (DoctorRanking)this.redisTemplate.opsForValue().get((Object)id);
        if (doctorRanking != null) {
            return doctorRanking;
        }
        return null;
    }

    public void addDoctorRankingById(DoctorRanking doctorRanking) {
        this.redisTemplate.opsForValue().set((Object)doctorRanking.getId(), (Object)doctorRanking);
    }

    public Double lookDoctorScore(DoctorRanking doctorRanking) {
        return this.redisTemplate.opsForZSet().score((Object)DOCTORRANKING, (Object)doctorRanking);
    }

    public long lookDoctorRanking(DoctorRanking doctorRanking) {
        return this.redisTemplate.opsForZSet().rank((Object)DOCTORRANKING, (Object)doctorRanking);
    }

    public Double editDoctorRaning(DoctorRanking doctorRanking, String score) {
        return this.redisTemplate.opsForZSet().incrementScore((Object)DOCTORRANKING, (Object)doctorRanking, Double.parseDouble(score));
    }

    public long removeDoctorRaning(DoctorRanking doctorRanking) {
        return this.redisTemplate.opsForZSet().remove((Object)DOCTORRANKING, new Object[]{doctorRanking});
    }

    public void deleteDoctorRaning() {
        this.redisTemplate.delete((Object)DOCTORRANKING);
    }
}

