/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.queue.RedisDelayQueue;
import com.cxqm.xiaoerke.common.queue.RedisDelayQueueTiming;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.account.service.AccountService;
import com.cxqm.xiaoerke.modules.consult.entity.ConsultRecordMongoVo;
import com.cxqm.xiaoerke.modules.consult.entity.Message;
import com.cxqm.xiaoerke.modules.consult.enums.MessageStatus;
import com.cxqm.xiaoerke.modules.consult.event.SendMsgEvent;
import com.cxqm.xiaoerke.modules.consult.event.UnReadEvent;
import com.cxqm.xiaoerke.modules.consult.service.GraphicChatService;
import com.cxqm.xiaoerke.modules.consult.service.impl.ConsultRecordMongoDBServiceImpl;
import com.cxqm.xiaoerke.modules.consult.service.impl.GraphicChatServiceImpl;
import com.cxqm.xiaoerke.modules.coupon.entity.CouponBusinessEnum;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyGraphicOrderCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyGraphicOrderVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.SpMessageQuery;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyGraphicOrderDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyGraphicOrder;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyGraphicOrderDoctor;
import com.cxqm.xiaoerke.modules.haoyun.entity.PayUrlRecordSmallProgram;
import com.cxqm.xiaoerke.modules.haoyun.entity.QuickGraphic;
import com.cxqm.xiaoerke.modules.haoyun.entity.QuickGraphicCondition;
import com.cxqm.xiaoerke.modules.haoyun.entity.SpMessage;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserOpenid;
import com.cxqm.xiaoerke.modules.haoyun.enums.DoctorGraphicOrderEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.GraphicOrderInputStepEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.GraphicOrderStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.queue.GraphicOrderDelayQueueEntity;
import com.cxqm.xiaoerke.modules.haoyun.service.HyGraphicOrderDoctorService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyGraphicOrderService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountDetailService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserOpenidService;
import com.cxqm.xiaoerke.modules.payinterface.service.PayUrlRecordSmallProgramInterfaceService;
import com.cxqm.xiaoerke.modules.sys.beans.DoctorVoBeans;
import com.cxqm.xiaoerke.modules.sys.dao.PayCouponRecordMapper;
import com.cxqm.xiaoerke.modules.sys.entity.DoctorVo;
import com.cxqm.xiaoerke.modules.sys.entity.HospitalVo;
import com.cxqm.xiaoerke.modules.sys.entity.PayCoupon;
import com.cxqm.xiaoerke.modules.sys.entity.PayCouponRecord;
import com.cxqm.xiaoerke.modules.sys.entity.PayCouponRecordExample;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.CouponService;
import com.cxqm.xiaoerke.modules.sys.service.DoctorInfoService;
import com.cxqm.xiaoerke.modules.sys.service.PayCouponService;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import com.cxqm.xiaoerke.modules.sys.utils.TokenKeyUtil;
import com.cxqm.xiaoerke.modules.sys.utils.UserUtils;
import com.cxqm.xiaoerke.modules.wechat.push.AngelSpPushService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class HyGraphicOrderServiceImpl
implements HyGraphicOrderService {
    private static Logger log = LoggerFactory.getLogger(HyGraphicOrderServiceImpl.class);
    @Autowired
    private GraphicChatService graphicChatService;
    @Autowired
    SysUserOpenidService sysUserOpenidService;
    @Autowired
    private HyGraphicOrderDao hyGraphicOrderDao;
    @Autowired
    PayCouponRecordMapper payCouponRecordMapper;
    @Autowired
    RedisDelayQueue delayQueue;
    @Autowired
    PayCouponService payCouponService;
    @Autowired
    private DoctorInfoService doctorInfoService;
    @Autowired
    private ConsultRecordMongoDBServiceImpl consultRecordMongoDBService;
    @Autowired
    private GraphicChatServiceImpl graphicChatServiceImpl;
    @Autowired
    PayUrlRecordSmallProgramInterfaceService payUrlRecordSmallProgramInterfaceService;
    @Autowired
    UserInfoService userInfoServiceImpl;
    @Autowired
    private AccountService accountService;
    @Autowired
    AngelSpPushService angelSpPushService;
    @Autowired
    CouponService couponService;
    @Autowired
    MongoDictionaryService mongoDictionaryService;
    @Autowired
    SysUserAccountDetailService sysUserAccountDetailService;
    @Autowired
    HyGraphicOrderDoctorService hyGraphicOrderDoctorService;

    public HyGraphicOrder finishOrder(String orderId) {
        HyGraphicOrder allOrder = this.findByPrimaryKey(orderId);
        if (allOrder.getOrderStatus() == GraphicOrderStatusEnum.PAYED.getValue()) {
            HyGraphicOrder hyGraphicOrder = new HyGraphicOrder();
            hyGraphicOrder.setId(orderId);
            hyGraphicOrder.setOrderStatus(GraphicOrderStatusEnum.END.getValue());
            this.updateOrderByPrimaryKeySelective(hyGraphicOrder);
            int price = 0;
            if (allOrder.getIsFastGraphic() != null && allOrder.getIsFastGraphic() == 1) {
                int orderAmount;
                int doctorPrice;
                int hongbao_branch;
                long offset = allOrder.getUpdateDate().getTime() - allOrder.getPayTime().getTime();
                int min = (int)(offset / 1000L / 60L);
                DoctorVo doctorVo = this.doctorInfoService.findDoctorDetailById(allOrder.getDoctor().getId());
                Float hongbao = Float.valueOf(0.0f);
                if (allOrder.minute15price != null && allOrder.minute15price.floatValue() > 0.0f && min < 15) {
                    hongbao = allOrder.minute15price;
                }
                if (allOrder.minute30price != null && allOrder.minute30price.floatValue() > 0.0f && hongbao.floatValue() <= 0.0f && min < 30) {
                    hongbao = allOrder.minute30price;
                }
                if (allOrder.minute60price != null && allOrder.minute60price.floatValue() > 0.0f && hongbao.floatValue() <= 0.0f && min < 60) {
                    hongbao = allOrder.minute60price;
                }
                if ((price = (hongbao_branch = (int)(hongbao.floatValue() * 100.0f)) + (doctorPrice = (int)(doctorVo.getGraphicPrice() == null ? 0.0 : doctorVo.getGraphicPrice() * 100.0))) > (orderAmount = (int)(allOrder.getOrderAmount().floatValue() * 100.0f))) {
                    price = orderAmount;
                }
                int backprice = orderAmount - price;
                log.info("\u6700\u540e\u8ba1\u7b97\u9000\u8fd8\u7ed9\u7528\u6237\u7684\u603b\u91d1\u989d=" + backprice + "\u5206");
                if (backprice > 0) {
                    int discount = (int)(allOrder.getDiscountAmount().floatValue() * 100.0f);
                    int backRMB = 0;
                    int backYHJ = 0;
                    if (discount > 0) {
                        if (backprice > discount) {
                            backRMB = backprice - discount;
                            backYHJ = discount;
                        } else {
                            backYHJ = backprice;
                        }
                    } else {
                        backRMB = backprice;
                    }
                    if (backRMB > 0) {
                        try {
                            int payAmountFee = (int)(allOrder.getPayAmount().floatValue() * 100.0f);
                            SimpleDateFormat sdf = new SimpleDateFormat("SSSyyMMddHHmmss");
                            String partner_trade_no = sdf.format(new Date()) + (10 + (int)(Math.random() * 90.0));
                            this.accountService.hySpUserReturnPayNo(backRMB, allOrder.getOrderNo(), payAmountFee, partner_trade_no);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.info("orderId=" + orderId + ";\u9000\u6b3e\u7ed9\u7528\u6237" + allOrder.getUser().getId() + ";\u53d1\u751f\u5f02\u5e38\u3002\u9000\u6b3e\u91d1\u989d=" + backRMB);
                        }
                    }
                    if (backYHJ > 0) {
                        log.info("\u5feb\u901f\u95ee\u8bca\u8ba2\u5355\u5b8c\u6210\uff0c\u9700\u8981\u9000\u6b3e\u7528\u6237\u4f18\u60e0\u5238==" + backYHJ);
                        this.couponService.createCoupon(String.valueOf(backYHJ), "haoyun", "0", allOrder.getUser().getId(), "", allOrder.getDoctor().getId(), "", "1", "tuikuan_quick");
                    }
                    log.info("\u6700\u540e\u8ba1\u7b97\u9000\u8fd8\u4eba\u6c11\u5e01=" + backRMB + "\uff1b\u9000\u8fd8\u4f18\u60e0\u5238=" + backYHJ);
                }
            } else {
                price = (int)(allOrder.getOrderAmount().floatValue() * 100.0f);
            }
            try {
                this.sysUserAccountDetailService.saveWenDaUserAccountDetail(allOrder, new Date(), Integer.valueOf(price));
            }
            catch (Exception e) {
                log.info("\u56fe\u6587\u54a8\u8be2\u5165\u8d26\u5f02\u5e38\uff01\uff01\uff01");
                e.printStackTrace();
            }
        }
        return allOrder;
    }

    public float findIncome(String doctorId) {
        HyGraphicOrder query = new HyGraphicOrder();
        query.setOrderStatus(GraphicOrderStatusEnum.END.getValue());
        query.setOrderSource(Integer.valueOf(1));
        DoctorVo vo = new DoctorVo();
        vo.setId(doctorId);
        query.setDoctor(vo);
        Float income = this.hyGraphicOrderDao.findIncome(query);
        if (income == null) {
            income = Float.valueOf(0.0f);
        }
        return income.floatValue();
    }

    public DoctorGraphicOrderEnum checkDoctorStatus(DoctorVoBeans doctorVoBeans) {
        if (doctorVoBeans == null) {
            return DoctorGraphicOrderEnum.NULLCOUPON_OR_UNUSE;
        }
        if (doctorVoBeans.getOrderId() != null && doctorVoBeans.getOrderId().trim().length() > 0) {
            return DoctorGraphicOrderEnum.EXIST_ORDER;
        }
        if (doctorVoBeans.getCouponId() != null && doctorVoBeans.getCouponId().length() > 0 && doctorVoBeans.getSurplus() != null && doctorVoBeans.getSurplus() > 0) {
            return DoctorGraphicOrderEnum.BIND_DOCTORCOUPON;
        }
        return DoctorGraphicOrderEnum.NULLCOUPON_OR_UNUSE;
    }

    public DoctorVoBeans checkDoctorStatusById(String doctorId, String userId) {
        Page page = new Page(1, 1);
        DoctorVo query = new DoctorVo();
        query.setId(doctorId);
        query.setSysUserId(userId);
        Page dataList = this.doctorInfoService.findAskDoctorList(page, query);
        DoctorVoBeans doctorVoBeans = null;
        if (dataList != null && dataList.getList().size() > 0) {
            doctorVoBeans = (DoctorVoBeans)dataList.getList().get(0);
            DoctorGraphicOrderEnum doctorGraphicOrderEnum = this.checkDoctorStatus(doctorVoBeans);
            doctorVoBeans.setDoctorGraphicOrderEnum(doctorGraphicOrderEnum.getValue());
        }
        return doctorVoBeans;
    }

    public int graphicOrderNum(String doctorId) {
        return this.hyGraphicOrderDao.queryAllOrder(doctorId);
    }

    public String genListLog(HyGraphicOrder hyGraphicOrder) {
        String textMsg = hyGraphicOrder.getQuestionDesc();
        ConsultRecordMongoVo consultRecordMongoVo = this.genLog(hyGraphicOrder, textMsg, hyGraphicOrder.getUserfirstask());
        try {
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new SendMsgEvent(consultRecordMongoVo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String casestr = hyGraphicOrder.getCaseInfo();
        if (casestr != null && casestr.trim().length() > 0) {
            String[] cases = casestr.split(";");
            for (int i = 0; i < cases.length; ++i) {
                if (cases[i].trim().length() <= 0) continue;
                String msg = "repic[0*" + cases[i] + "]";
                this.genLog(hyGraphicOrder, msg, null);
            }
        }
        return consultRecordMongoVo.getId();
    }

    public void removeMongoLog(String orderId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"orderno").is((Object)orderId));
        this.consultRecordMongoDBService.findAllAndRemove(query);
    }

    private ConsultRecordMongoVo genLog(HyGraphicOrder hyGraphicOrder, String msg, String id) {
        ConsultRecordMongoVo consultRecordMongoVo = new ConsultRecordMongoVo();
        if (id == null) {
            consultRecordMongoVo.setId(IdGen.vestaId());
        } else {
            consultRecordMongoVo.setId(hyGraphicOrder.getUserfirstask());
        }
        consultRecordMongoVo.setIsRead(MessageStatus.UNREAD.getValue());
        consultRecordMongoVo.setAcceptId(hyGraphicOrder.getDoctor().getSysUserId());
        consultRecordMongoVo.setSenderId(hyGraphicOrder.getUser().getId());
        consultRecordMongoVo.setMessage(msg);
        consultRecordMongoVo.setOrderno(hyGraphicOrder.getId());
        consultRecordMongoVo.setTimestamp(System.currentTimeMillis());
        this.consultRecordMongoDBService.insert(consultRecordMongoVo);
        return consultRecordMongoVo;
    }

    public List<QuickGraphic> getQuickGraphic(QuickGraphicCondition quickGraphicCondition) {
        int i;
        List<HyGraphicOrder> hyGraphicOrders = this.hyGraphicOrderDao.finListByQuickGraphicCondition(quickGraphicCondition);
        ArrayList<QuickGraphic> res = new ArrayList<QuickGraphic>();
        Page dataList = this.doctorInfoService.findAskDoctorList(new Page(0, 400), new DoctorVo());
        HashMap<String, DoctorVoBeans> beanmap = new HashMap<String, DoctorVoBeans>();
        for (i = 0; i < dataList.getList().size(); ++i) {
            DoctorVoBeans vo = (DoctorVoBeans)dataList.getList().get(i);
            beanmap.put(vo.getId(), vo);
        }
        for (i = 0; i < hyGraphicOrders.size(); ++i) {
            HyGraphicOrder order = hyGraphicOrders.get(i);
            QuickGraphic quickGraphic = new QuickGraphic();
            quickGraphic.setOrderId(order.getId());
            quickGraphic.setPayTime(order.getPayTime());
            quickGraphic.setMinute15price(order.getMinute15price());
            quickGraphic.setMinute30price(order.getMinute30price());
            quickGraphic.setMinute60price(order.getMinute60price());
            quickGraphic.setIsFastGraphic(order.getIsFastGraphic());
            quickGraphic.setQuestionTitle(order.getQuestionTitle());
            quickGraphic.setQuestionDesc(order.getQuestionDesc());
            quickGraphic.setCaseInfo(order.getCaseInfo());
            quickGraphic.setCurrentTime(new Date());
            String userid = order.getUser().getId();
            User user = this.userInfoServiceImpl.getUserById(userid);
            quickGraphic.setUserName(user.getName());
            quickGraphic.setUserPhoto(user.getFullPhoto());
            List list = this.hyGraphicOrderDoctorService.selectByOrderId(order.getId(), true);
            ArrayList<DoctorVoBeans> doctors = new ArrayList<DoctorVoBeans>();
            for (int j = 0; j < list.size(); ++j) {
                HyGraphicOrderDoctor temp = (HyGraphicOrderDoctor)list.get(j);
                DoctorVoBeans vo = (DoctorVoBeans)beanmap.get(temp.getSysDoctorId());
                Integer del = Integer.parseInt(temp.getDelFlag());
                vo.setIsQuickDel(del);
                doctors.add(vo);
            }
            quickGraphic.setDoctors(doctors);
            res.add(quickGraphic);
        }
        return res;
    }

    public Page<SpMessage> selectUserMessage(Integer pageNo, Integer pageSize, SpMessageQuery spMessageQuery) {
        return this.hyGraphicOrderDao.selectUserMessage((Page<SpMessage>)new Page(pageNo.intValue(), pageSize.intValue()), spMessageQuery);
    }

    public Page<SpMessage> selectNewMessage(Integer pageNo, Integer pageSize, SpMessageQuery spMessageQuery) {
        return this.hyGraphicOrderDao.selectNewMessage((Page<SpMessage>)new Page(pageNo.intValue(), pageSize.intValue()), spMessageQuery);
    }

    public Page<SpMessage> selectmyAnswer(Integer pageNo, Integer pageSize, SpMessageQuery spMessageQuery) {
        return this.hyGraphicOrderDao.selectmyAnswer((Page<SpMessage>)new Page(pageNo.intValue(), pageSize.intValue()), spMessageQuery);
    }

    public HyGraphicOrder createOrder(DoctorVo doctor, User user, String fask, String imgsUrl) {
        if (doctor == null || doctor.getId() == null || user == null || user.getId() == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.USERID_NOT_NULL);
        }
        HyGraphicOrderCondition query = new HyGraphicOrderCondition();
        query.setOrderStatus(GraphicOrderStatusEnum.PAYED.getValue());
        query.setDoctor(doctor);
        query.setUser(user);
        List<HyGraphicOrder> list = this.hyGraphicOrderDao.findListUserinfoByCondition(query);
        if (list != null && list.size() > 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_EXIST);
        }
        HyGraphicOrder order = new HyGraphicOrder();
        order.setId(IdGen.vestaId());
        order.setOrderNo(IdGen.orderNo());
        float orderAmount = 0.0f;
        if (doctor.getGraphicPrice() != null) {
            orderAmount = doctor.getGraphicPrice().floatValue();
        }
        order.setQuestionDesc(fask);
        order.setCaseInfo(imgsUrl);
        order.setOrderAmount(Float.valueOf(orderAmount));
        order.setDoctor(doctor);
        order.setUser(user);
        order.setInputStep(GraphicOrderInputStepEnum.SELECT_PATIENT.getValue());
        order.setOrderStatus(GraphicOrderStatusEnum.WAIT_PAY.getValue());
        order.setIsConfirm(GraphicOrderStatusEnum.UNCONFIRMTMP.getValue());
        order.setOrderSource(Integer.valueOf(1));
        order.setDelFlag("0");
        order.setCreateBy(user);
        order.setCreateDate(new Date());
        this.hyGraphicOrderDao.insert(order);
        this.delayQueue.addByAfterSecond((RedisDelayQueueTiming)new GraphicOrderDelayQueueEntity(order.getId()), 900L);
        return order;
    }

    public HyGraphicOrder saveOrUpdate(HyGraphicOrder record, User user) {
        if (record == null) {
            return null;
        }
        if (record.getId() != null) {
            if (record.getCreateBy() == null && user != null) {
                record.setUpdateBy(user);
            }
            if (record.getUpdateDate() == null) {
                record.setUpdateDate(new Date());
            }
            this.hyGraphicOrderDao.updateByPrimaryKeySelective(record);
        } else {
            record.setId(IdGen.vestaId());
            record.setDelFlag("0");
            if (user != null) {
                record.setCreateBy(user);
            }
            record.setIsConfirm(GraphicOrderStatusEnum.UNCONFIRMTMP.getValue());
            record.setCreateDate(new Date());
            record.setOrderNo(IdGen.orderNo());
            if (record.getOrderStatus() == null) {
                record.setOrderStatus(GraphicOrderStatusEnum.WAIT_PAY.getValue());
            }
            this.hyGraphicOrderDao.insert(record);
        }
        return this.hyGraphicOrderDao.findByPrimaryKey(record.getId());
    }

    public void updateFinishPayQuickOrder(HyGraphicOrder record) {
    }

    public List<HyGraphicOrder> findListByCondtion(HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findListByCondition(condition);
    }

    public List<HyGraphicOrder> findListUserinfoByCondition(HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findListUserinfoByCondition(condition);
    }

    public List<HyGraphicOrder> findListByStatusCondition(HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findListByStatusCondition(condition);
    }

    public Page<HyGraphicOrder> findPageByCondtion(Page<HyGraphicOrder> page, HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findPageByCondtion(page, condition);
    }

    public int delete(String id) {
        return this.hyGraphicOrderDao.deleteByPrimaryKey(id);
    }

    public HyGraphicOrder findByPrimaryKey(String id) {
        return this.hyGraphicOrderDao.findByPrimaryKey(id);
    }

    public String getCaseImgJsonurls(HyGraphicOrder hyGraphicOrder) {
        String[] filenames;
        String jsonurl = "";
        if (hyGraphicOrder != null && hyGraphicOrder.getCaseInfo() != null && hyGraphicOrder.getCaseInfo().length() > 0 && (filenames = hyGraphicOrder.getCaseInfo().split(";")) != null && filenames.length > 0) {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < filenames.length; ++i) {
                jsonArray.add((Object)OSSObjectTool.getUrl((String)filenames[i], (String)OSSObjectTool.BUCKET_CASE_PIC));
            }
            jsonurl = jsonArray.toString();
        }
        return jsonurl;
    }

    public void payedOrder(String id) {
    }

    public void stopOrder(String orderId, User user) {
        this.finishOrder(orderId);
    }

    public Page<HyGraphicOrderVo> findCurrentUserorder(int pageNo, int pageSize, int orderstatus, User user) {
        HyGraphicOrderCondition graphicOrderCondition = new HyGraphicOrderCondition();
        if ("user".equals(user.getUserType())) {
            graphicOrderCondition.setUser(user);
        } else if ("doctor".equals(user.getUserType())) {
            DoctorVo doctorCondtion = new DoctorVo();
            doctorCondtion.setSysUserId(user.getId());
            graphicOrderCondition.setDoctor(doctorCondtion);
        }
        if (orderstatus != 0) {
            graphicOrderCondition.setOrderStatus(Integer.valueOf(orderstatus));
        }
        graphicOrderCondition.setOrder(Integer.valueOf(1));
        Page pageCondition = new Page(pageNo, pageSize);
        Page<HyGraphicOrder> page = this.hyGraphicOrderDao.findPageByCondtion((Page<HyGraphicOrder>)pageCondition, graphicOrderCondition);
        ArrayList<HyGraphicOrderVo> hyGraphicOrderVos = new ArrayList<HyGraphicOrderVo>();
        if (page != null && page.getList() != null && page.getList().size() > 0) {
            for (HyGraphicOrder order : page.getList()) {
                HyGraphicOrderVo vo = new HyGraphicOrderVo(order);
                hyGraphicOrderVos.add(vo);
            }
        }
        Page pagevo = new Page(page.getPageNo(), page.getPageSize(), page.getCount(), hyGraphicOrderVos);
        return pagevo;
    }

    public void confirmTmp(String orderId) {
        HyGraphicOrder hyGraphicOrder = this.hyGraphicOrderDao.findByPrimaryKey(orderId);
        if (hyGraphicOrder.getIsConfirm() == GraphicOrderStatusEnum.UNCONFIRMTMP.getValue()) {
            hyGraphicOrder.setIsConfirm(GraphicOrderStatusEnum.CONFIRMTMP.getValue());
            this.saveOrUpdate(hyGraphicOrder, MUserInfo.getUserInfoValue());
            ConsultRecordMongoVo consultRecordMongoVo = new ConsultRecordMongoVo();
            consultRecordMongoVo.setIsRead(MessageStatus.UNREAD.getValue());
            consultRecordMongoVo.setAcceptId(hyGraphicOrder.getDoctor().getSysUserId());
            consultRecordMongoVo.setSenderId(hyGraphicOrder.getUser().getId());
            consultRecordMongoVo.setMessage("");
            consultRecordMongoVo.setOrderno(hyGraphicOrder.getId());
            consultRecordMongoVo.setTimestamp(hyGraphicOrder.getCreateDate().getTime());
            this.consultRecordMongoDBService.insert(consultRecordMongoVo);
        }
        User user_allinfo = this.userInfoServiceImpl.getUserById(hyGraphicOrder.getUser().getId());
        Message message = new Message();
        message.setSendname(user_allinfo.getName());
        message.setBinglxq();
        message.setUserId(hyGraphicOrder.getDoctor().getSysUserId());
        message.setFromAccount(hyGraphicOrder.getUser().getId());
        message.setUserHeard(user_allinfo.getFullPhoto());
        message.setOrderid(orderId);
        message.setOpenurl(orderId, Boolean.valueOf(true));
        message.setSendusertype(user_allinfo.getUserType());
        int feednum = this.graphicChatServiceImpl.queryCount(orderId, hyGraphicOrder.getDoctor().getSysUserId());
        int pushnum = this.graphicChatServiceImpl.queryCount(null, hyGraphicOrder.getDoctor().getSysUserId());
        message.setFeedcount(String.valueOf(feednum + 1));
        message.setPushcount(String.valueOf(pushnum + 1));
        try {
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new UnReadEvent(message));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refundOrder(String orderId) {
        HyGraphicOrder hyGraphicOrder = this.findByPrimaryKey(orderId);
        PayCouponRecordExample payCouponRecordExample = new PayCouponRecordExample();
        payCouponRecordExample.createCriteria().andOrderNoEqualTo(orderId);
        List payCouponRecords = this.payCouponRecordMapper.selectByExample(payCouponRecordExample);
        if (payCouponRecords != null && payCouponRecords.size() > 0) {
            int youhuijuan = 0;
            for (int i = 0; i < payCouponRecords.size(); ++i) {
                youhuijuan += ((PayCouponRecord)payCouponRecords.get(i)).getUsePrice().intValue();
            }
            PayCoupon payCoupon = this.payCouponService.selectById(((PayCouponRecord)payCouponRecords.get(0)).getCouponId());
            if (payCoupon.getBusinessType() == CouponBusinessEnum.COUNTTUWEN.getValue()) {
                this.couponService.createCoupon("30", "haoyun", "0", hyGraphicOrder.getUser().getId(), "", hyGraphicOrder.getDoctor().getId(), "", "1", "tuikuan");
                log.info("\u7528\u6237\u4f7f\u7528\u4e86\u4f18\u60e0\u5238\u9000\u56de\u4f18\u60e0\u5238\uff0c\u9000\u56de\u4e00\u6b21\u4f7f\u7528\u5377\uff01\uff01\uff01\uff01");
            } else {
                this.couponService.createCoupon(String.valueOf(youhuijuan), CouponBusinessEnum.all, payCoupon.getCondition3(), hyGraphicOrder.getUser().getId(), "tuikuan");
                log.info("\u7528\u6237\u4f7f\u7528\u4e86\u4f18\u60e0\u5238\u9000\u56de\u4f18\u60e0\u5238\uff0c\u9000\u56de\u91d1\u989d\uff01\uff01\uff01\uff01" + youhuijuan);
            }
        }
        log.info("\u56fe\u6587\u54a8\u8be2\u8ba2\u5355orderId=" + orderId + ";\u8ba2\u5355\u7684\u652f\u4ed8\u91d1\u989d=" + hyGraphicOrder.getPayAmount());
        if (hyGraphicOrder.getPayAmount().floatValue() > 0.0f) {
            if (hyGraphicOrder.getOrderStatus() == GraphicOrderStatusEnum.END.getValue()) {
                log.info("\u8ba2\u5355\u5df2\u5165\u8d26\uff0c\u6263\u9664\u533b\u751f\u8d26\u6237\u91d1\u989d\u540e\u9000\u5355");
                if (hyGraphicOrder.getOrderSource() == 2) {
                    this.sysUserAccountDetailService.doctorManageRefundByOrderId(orderId, UserUtils.getUser().getId(), hyGraphicOrder.getUser().getId());
                }
                this.tuiqian(hyGraphicOrder);
            } else if (hyGraphicOrder.getOrderStatus() == GraphicOrderStatusEnum.PAYED.getValue() || hyGraphicOrder.getOrderStatus() == GraphicOrderStatusEnum.RECEIPT.getValue() || hyGraphicOrder.getOrderStatus() == GraphicOrderStatusEnum.KEFU.getValue() || hyGraphicOrder.getOrderStatus() == GraphicOrderStatusEnum.ORDER.getValue()) {
                log.info("\u8ba2\u5355\u672a\u5165\u8d26\u533b\u751f\uff0c\u76f4\u63a5\u53d1\u751f\u9000\u6b3e\u3002\u3002");
                this.tuiqian(hyGraphicOrder);
            }
        }
        hyGraphicOrder.setRefundStatus(GraphicOrderStatusEnum.TONGYITUIKUAN.getValue());
        hyGraphicOrder.setRefundCommitTime(new Date());
        hyGraphicOrder.setExamineRemark("\u7cfb\u7edf\u540c\u610f\u9000\u6b3e\uff01");
        this.updateOrderByPrimaryKeySelective(hyGraphicOrder);
        if (hyGraphicOrder.getOrderSource() == 2) {
            SysUserOpenid sysUserOpenid = this.sysUserOpenidService.queryByUserId(hyGraphicOrder.getUser().getId());
            MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("spRefundTemplate");
            String tsmsg = "";
            String price = hyGraphicOrder.getPayAmount().toString() + "\u5143";
            tsmsg = hyGraphicOrder.getPayAmount().floatValue() == 0.0f ? mongoDictionary.getStr6() : mongoDictionary.getStr4();
            SimpleDateFormat yyyysdf = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date();
            Map map = this.payUrlRecordSmallProgramInterfaceService.queryOrInsertRecord(hyGraphicOrder.getOrderNo(), "");
            PayUrlRecordSmallProgram payUrlRecordSmallProgram = (PayUrlRecordSmallProgram)JSON.parseObject((String)map.get("payUrlRecord").toString(), (TypeReference)new TypeReference<PayUrlRecordSmallProgram>(){}, (Feature[])new Feature[0]);
            this.angelSpPushService.pushByOpenId(sysUserOpenid.getOpenid(), mongoDictionary.getStr1(), mongoDictionary.getStr3(), hyGraphicOrder.getOrderNo(), price, yyyysdf.format(date), tsmsg, TokenKeyUtil.wechat_sp_appid_user, payUrlRecordSmallProgram.getWxOrderNo());
        }
    }

    private void tuiqian(HyGraphicOrder hyGraphicOrder) {
        if (hyGraphicOrder.getOldOrderId() != null && hyGraphicOrder.getOldOrderId().trim().length() > 0) {
            HyGraphicOrder oldorder = this.findByPrimaryKey(hyGraphicOrder.getOldOrderId());
            Integer jine = (int)(oldorder.getPayAmount().floatValue() * 100.0f);
            this.oneorder(jine, oldorder.getOrderNo(), jine);
            Integer currentPrice = (int)(hyGraphicOrder.getPayAmount().floatValue() * 100.0f);
            int offset = currentPrice - jine;
            if (offset > 0) {
                this.oneorder(offset, hyGraphicOrder.getOrderNo(), offset);
            }
        } else {
            Integer jine = (int)(hyGraphicOrder.getPayAmount().floatValue() * 100.0f);
            this.oneorder(jine, hyGraphicOrder.getOrderNo(), jine);
        }
    }

    private void oneorder(int returnMoney, String order_no, int amountPay) {
        log.info("\u9000\u6b3e\u7ed9\u7528\u6237\u3002\u3002\u5355\u53f7" + order_no + "\u9000\u6b3e\u91d1\u989d==" + returnMoney);
        SimpleDateFormat sdf = new SimpleDateFormat("SSSyyMMddHHmmss");
        String returnNo = sdf.format(new Date()) + (10 + (int)(Math.random() * 90.0));
        this.accountService.hySpUserReturnPayNo(returnMoney, order_no, amountPay, returnNo);
    }

    public void updateOrderByPrimaryKeySelective(HyGraphicOrder hyGraphicOrder) {
        this.hyGraphicOrderDao.updateByPrimaryKeySelective(hyGraphicOrder);
    }

    public List<HyGraphicOrder> findListSource(HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findListSource(condition);
    }

    public List<HospitalVo> getHospitalList() {
        return this.hyGraphicOrderDao.getHospitalList();
    }

    public List<String> getOverdueOrderId(String userId) {
        return this.hyGraphicOrderDao.getIdBySysUserIdWithOrderStatus(userId, GraphicOrderStatusEnum.END.getValue());
    }
}

