/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.modules.haoyun.beans.FamilyPatient;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyGravidityHistoryCondition;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyGravidityHistoryDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyGravidityHistory;
import com.cxqm.xiaoerke.modules.haoyun.service.HyGravidityHistoryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyGravidityHistoryServiceImpl
implements HyGravidityHistoryService {
    @Autowired
    private HyGravidityHistoryDao hyGravidityHistoryDao;

    public FamilyPatient<HyGravidityHistory> findFamilyGravidities(String maleId, String femaleId) {
        if (maleId == null && femaleId == null) {
            return null;
        }
        ArrayList<String> idIn = new ArrayList<String>();
        if (maleId != null) {
            idIn.add(maleId);
        }
        if (femaleId != null) {
            idIn.add(femaleId);
        }
        HyGravidityHistoryCondition condition = new HyGravidityHistoryCondition();
        condition.setPatientIdIn(idIn);
        List<HyGravidityHistory> list = this.hyGravidityHistoryDao.selectListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        FamilyPatient result = new FamilyPatient();
        for (HyGravidityHistory hyGravidityHistory : list) {
            if (maleId != null && maleId.equals(hyGravidityHistory.getPatient().getId())) {
                result.setMale((Object)hyGravidityHistory);
            }
            if (femaleId == null || !femaleId.equals(hyGravidityHistory.getPatient().getId())) continue;
            result.setFemale((Object)hyGravidityHistory);
        }
        return result;
    }

    public HyGravidityHistory findGravidities(String patientId) {
        if (patientId == null) {
            return null;
        }
        HyGravidityHistoryCondition condition = new HyGravidityHistoryCondition();
        condition.setPatientIdIn(Arrays.asList(patientId));
        List<HyGravidityHistory> list = this.hyGravidityHistoryDao.selectListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public void update(HyGravidityHistory hyGravidityHistory) {
        this.hyGravidityHistoryDao.updateByPrimaryKey(hyGravidityHistory);
    }

    public void insert(HyGravidityHistory hyGravidityHistory) {
        this.hyGravidityHistoryDao.insert(hyGravidityHistory);
    }
}

