/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.consult.service.core.IPadChannelGroups;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.beans.IOSMeetingAdminLeftException;
import com.cxqm.xiaoerke.modules.haoyun.beans.IOSMeetingRoom;
import com.cxqm.xiaoerke.modules.haoyun.beans.IOSMeetingRoomUser;
import com.cxqm.xiaoerke.modules.haoyun.service.HyIOSMeetingService;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class HyIOSMeetingServiceImpl
implements HyIOSMeetingService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ROOM_SESSIONID_KEY = "hyzs.merm.roomid";
    private RedisTemplate<String, Object> redisTemplate = (RedisTemplate)SpringContextHolder.getBean((String)"redisTemplate");

    public IOSMeetingRoom createRoom(String createById, String createByName) {
        IOSMeetingRoom room = new IOSMeetingRoom();
        room.setId("MERM_" + IdGen.vestaId());
        room.setCreateById(createById);
        room.setCreateByName(createByName);
        room.setCreateTime(Long.valueOf(new Date().getTime()));
        this.redisTemplate.opsForHash().put((Object)ROOM_SESSIONID_KEY, (Object)room.getId(), (Object)room);
        this.logger.info(String.format("\u3010\u89c6\u9891\u4f1a\u8bae\u3011\u521b\u5efa\u623f\u95f4(%s) by %s/%s", room.getId(), room.getCreateById(), room.getCreateByName()));
        return room;
    }

    public IOSMeetingRoom getRoom(String roomId) {
        Object roomObj = this.redisTemplate.opsForHash().get((Object)ROOM_SESSIONID_KEY, (Object)roomId);
        if (roomObj == null) {
            return null;
        }
        if (!(roomObj instanceof IOSMeetingRoom)) {
            return null;
        }
        return (IOSMeetingRoom)roomObj;
    }

    public IOSMeetingRoomUser joinRoom(String roomId, String userId, String userName, boolean admin, String memberType) {
        IOSMeetingRoom room = this.getRoom(roomId);
        if (room == null) {
            this.logger.info(String.format("\u3010\u89c6\u9891\u4f1a\u8bae\u3011\u52a0\u5165\u623f\u95f4\u5931\u8d25\uff0c\u623f\u95f4\u4e0d\u5b58\u5728(%s) by %s/%s %s", roomId, userId, userName, admin ? "admin" : "user"));
            throw new BusinessException((IErrorInfo)HaoyunErrors.MEETING_JOIN_FAILED);
        }
        if (room.getUsers() == null) {
            room.setUsers(new ArrayList());
        }
        for (int i = 0; i < room.getUsers().size(); ++i) {
            IOSMeetingRoomUser user = (IOSMeetingRoomUser)room.getUsers().get(i);
            if (!user.getUserId().equals(userId)) continue;
            room.getUsers().remove(i--);
        }
        IOSMeetingRoomUser user = new IOSMeetingRoomUser();
        user.setAdmin(admin);
        user.setJoinTime(Long.valueOf(new Date().getTime()));
        user.setUserId(userId);
        user.setUserName(userName);
        user.setMemberType(memberType);
        room.getUsers().add(user);
        this.logger.info(String.format("\u3010\u89c6\u9891\u4f1a\u8bae\u3011\u52a0\u5165\u623f\u95f4(%s) by %s/%s %s", roomId, userId, userName, admin ? "admin" : "user"));
        this.redisTemplate.opsForHash().put((Object)ROOM_SESSIONID_KEY, (Object)room.getId(), (Object)room);
        return user;
    }

    public IOSMeetingRoomUser leaveRoom(String roomId, String userId) throws IOSMeetingAdminLeftException {
        IOSMeetingRoom room = this.getRoom(roomId);
        if (room == null) {
            this.logger.info(String.format("\u3010\u89c6\u9891\u4f1a\u8bae\u3011\u79bb\u5f00\u623f\u95f4\u5931\u8d25\uff0c\u623f\u95f4\u4e0d\u5b58\u5728(%s) by %s", roomId, userId));
            throw new BusinessException((IErrorInfo)HaoyunErrors.MEETING_LEAVE_FAILED);
        }
        if (room.getUsers() == null) {
            room.setUsers(new ArrayList());
        }
        IOSMeetingRoomUser removed = null;
        boolean isAdminExit = false;
        for (int i = 0; i < room.getUsers().size(); ++i) {
            IOSMeetingRoomUser user = (IOSMeetingRoomUser)room.getUsers().get(i);
            if (!user.getUserId().equals(userId)) continue;
            if (user.isAdmin()) {
                isAdminExit = true;
            }
            removed = (IOSMeetingRoomUser)room.getUsers().remove(i--);
            break;
        }
        if (removed == null) {
            return null;
        }
        if (isAdminExit && room.getUsers().size() != 0) {
            this.logger.info(String.format("\u3010\u89c6\u9891\u4f1a\u8bae\u3011\u7ba1\u7406\u5458\u5df2\u9000\u51fa\uff0c\u4e14\u8fd8\u6709\u7528\u6237", new Object[0]));
            room.getUsers().clear();
            this.redisTemplate.opsForHash().put((Object)ROOM_SESSIONID_KEY, (Object)room.getId(), (Object)room);
            throw new IOSMeetingAdminLeftException(room.getId(), removed);
        }
        this.redisTemplate.opsForHash().put((Object)ROOM_SESSIONID_KEY, (Object)room.getId(), (Object)room);
        this.logger.info(String.format("\u3010\u89c6\u9891\u4f1a\u8bae\u3011\u9000\u51fa\u623f\u95f4(%s) by %s/%s %s", room.getId(), removed.getUserId(), removed.getUserName(), removed.isAdmin() ? "admin" : "user"));
        return removed;
    }

    public void removeRoom(String roomId, String closeReason) {
        if (roomId == null) {
            return;
        }
        this.logger.info(String.format("\u5173\u95ed\u623f\u95f4(%s)", roomId));
        this.redisTemplate.opsForHash().delete((Object)ROOM_SESSIONID_KEY, new Object[]{roomId});
        JSONObject json = new JSONObject();
        json.put("stype", (Object)"A3");
        JSONObject content = new JSONObject();
        content.put("reason", (Object)(closeReason == null ? "\u623f\u95f4\u88ab\u5173\u95ed" : closeReason));
        json.put("content", (Object)content);
        TextWebSocketFrame resultFrame = new TextWebSocketFrame(json.toJSONString());
        IPadChannelGroups.broadcast((String)roomId, (Object)resultFrame.retain());
    }
}

