/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyLabelSubCategoryDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyLabelSubCategory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyUserLabel;
import com.cxqm.xiaoerke.modules.haoyun.enums.HyLableOperatorTypeEnum;
import com.cxqm.xiaoerke.modules.haoyun.example.HyLabelSubCategoryExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyLabelSubCategoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserLabelService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyLabelSubCategoryServiceImpl
implements HyLabelSubCategoryService {
    @Autowired
    HyLabelSubCategoryDao hyLabelSubCategoryDao;
    @Autowired
    HyUserLabelService hyUserLabelService;
    @Autowired
    private MongoDictionaryService mongoDictionaryService;

    public List<HyLabelSubCategory> queryByUserId(String orderId) {
        return this.hyLabelSubCategoryDao.queryUserLabelByOrderId(orderId);
    }

    public void deleteById(String id) {
        this.hyLabelSubCategoryDao.deleteByPrimaryKey(id);
    }

    public void updateUserLabel(String orderId, String userId, List<HyLabelSubCategory> labelSubCategoryList) {
        if (orderId == null || orderId.trim().equals("") || userId == null || userId.trim().equals("") || labelSubCategoryList == null || labelSubCategoryList.size() == 0) {
            return;
        }
        this.hyUserLabelService.deleteByOrderId(orderId);
        for (int i = 0; i < labelSubCategoryList.size(); ++i) {
            new JSONObject();
            JSONObject obj = JSONObject.fromObject((Object)labelSubCategoryList.get(i));
            HyLabelSubCategory hyLabelSubCategory = (HyLabelSubCategory)JSONObject.toBean((JSONObject)obj, HyLabelSubCategory.class);
            String[] ids = hyLabelSubCategory.getId().split("new_");
            if (ids.length > 1) {
                hyLabelSubCategory.setId(IdGen.vestaId());
                hyLabelSubCategory.setCode(IdGen.vestaId());
                hyLabelSubCategory.setOperatorType(HyLableOperatorTypeEnum.DOCTOR_OPERATE.getCode());
                hyLabelSubCategory.setBelongUserId(userId);
                hyLabelSubCategory.setCreateBy(new User(userId));
                hyLabelSubCategory.setCreateDate(new Date());
                hyLabelSubCategory.setDelFlag("0");
                this.hyLabelSubCategoryDao.insertSelective(hyLabelSubCategory);
            }
            HyUserLabel hyUserLabel = new HyUserLabel();
            hyUserLabel.setLabelId(hyLabelSubCategory.getId());
            hyUserLabel.setOrderId(orderId);
            hyUserLabel.setOperatorId(userId);
            hyUserLabel.setCreateBy(new User(userId));
            hyUserLabel.setCreateDate(new Date());
            hyUserLabel.setDelFlag("0");
            this.hyUserLabelService.save(hyUserLabel);
        }
    }

    public List<HyLabelSubCategory> findByExample(HyLabelSubCategoryExample example) {
        return this.hyLabelSubCategoryDao.selectByExample(example);
    }

    public HyLabelSubCategory findById(String id) {
        return this.hyLabelSubCategoryDao.selectByPrimaryKey(id);
    }

    public boolean save(HyLabelSubCategory record) {
        if (record == null || record.getName() == null || record.getName().trim().length() == 0 || record.getOperatorType() == null || record.getOperatorType().trim().length() == 0) {
            return false;
        }
        MongoDictionary customLabelDic = this.mongoDictionaryService.queryDictionary("SP_CUSTOM_LABEL");
        if ((record.getTopLabelId() == null || record.getTopLabelId().trim().length() == 0) && customLabelDic != null && customLabelDic.getStr1() != null && customLabelDic.getStr1().trim().length() > 0) {
            record.setTopLabelId(customLabelDic.getStr1());
        }
        if (record.getTopLabelId() == null || record.getTopLabelId().trim().length() == 0) {
            return false;
        }
        if ((record.getSort() == null || record.getSort().trim().length() == 0) && customLabelDic != null && customLabelDic.getStr2() != null && customLabelDic.getStr2().trim().length() > 0) {
            record.setSort(customLabelDic.getStr2());
        }
        record.setId(IdGen.vestaId());
        record.setCode(IdGen.vestaId());
        record.setCreateDate(new Date());
        int saveFlag = this.hyLabelSubCategoryDao.insertSelective(record);
        return saveFlag == 1;
    }
}

