/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.StringUtils;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyMessageVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyMessageDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyMessage;
import com.cxqm.xiaoerke.modules.haoyun.example.HyMessageExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyMessageService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyMessageServiceImpl
implements HyMessageService {
    @Autowired
    private HyMessageDao hyMessageDao;

    public Page<HyMessageVo> findByPage(Page<HyMessageVo> page, HyMessageExample example) {
        Page<HyMessageVo> result = this.hyMessageDao.findByPage(page, example);
        List messageVoList = result.getList();
        if (messageVoList != null && messageVoList.size() > 0) {
            for (int i = 0; i < messageVoList.size(); ++i) {
                Map contentMap = null;
                Map titleMap = null;
                Map msgUrlMap = null;
                try {
                    titleMap = (Map)JSONObject.parse((String)((HyMessageVo)messageVoList.get(i)).getTitleJson());
                    contentMap = (Map)JSONObject.parse((String)((HyMessageVo)messageVoList.get(i)).getContentJson());
                    msgUrlMap = (Map)JSONObject.parse((String)((HyMessageVo)messageVoList.get(i)).getMsgUrlJson());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                String content = StringUtils.replaceTemplate((String)((HyMessageVo)messageVoList.get(i)).getTemplateContent(), contentMap);
                String title = StringUtils.replaceTemplate((String)((HyMessageVo)messageVoList.get(i)).getTemplateTitle(), (Map)titleMap);
                String msgUrl = StringUtils.replaceTemplate((String)((HyMessageVo)messageVoList.get(i)).getTemplateMsgUrl(), (Map)msgUrlMap);
                ((HyMessageVo)messageVoList.get(i)).setContent(content);
                ((HyMessageVo)messageVoList.get(i)).setTitle(title);
                ((HyMessageVo)messageVoList.get(i)).setMsgUrl(msgUrl);
            }
        }
        return result;
    }

    public List<HyMessageVo> findVoByExample(HyMessageExample example) {
        List<HyMessageVo> messageVoList = this.hyMessageDao.selectVoByExample(example);
        if (messageVoList != null && messageVoList.size() > 0) {
            for (int i = 0; i < messageVoList.size(); ++i) {
                Map contentMap = null;
                Map titleMap = null;
                Map msgUrlMap = null;
                try {
                    titleMap = (Map)JSONObject.parse((String)messageVoList.get(i).getTitleJson());
                    contentMap = (Map)JSONObject.parse((String)messageVoList.get(i).getContentJson());
                    msgUrlMap = (Map)JSONObject.parse((String)messageVoList.get(i).getMsgUrlJson());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                String content = StringUtils.replaceTemplate((String)messageVoList.get(i).getTemplateContent(), contentMap);
                String title = StringUtils.replaceTemplate((String)messageVoList.get(i).getTemplateTitle(), (Map)titleMap);
                String msgUrl = StringUtils.replaceTemplate((String)messageVoList.get(i).getTemplateMsgUrl(), (Map)msgUrlMap);
                messageVoList.get(i).setContent(content);
                messageVoList.get(i).setTitle(title);
                messageVoList.get(i).setMsgUrl(msgUrl);
            }
        }
        return messageVoList;
    }

    public boolean deleteById(String id) {
        if (id == null || id.trim().length() == 0) {
            return false;
        }
        int deleteFlag = this.hyMessageDao.deleteByPrimaryKey(id);
        return deleteFlag == 1;
    }

    public boolean save(HyMessage record) {
        if (record == null) {
            return false;
        }
        Date currentDate = new Date();
        if (record.getCreateDate() == null) {
            record.setCreateDate(currentDate);
        }
        if (record.getEventTime() == null) {
            record.setEventTime(currentDate);
        }
        record.setId(IdGen.vestaId());
        int saveFlag = this.hyMessageDao.insertSelective(record);
        return saveFlag == 1;
    }

    public boolean update(HyMessage record) {
        int updateFlag;
        if (record == null || record.getId() == null || record.getId().trim().length() == 0) {
            return false;
        }
        if (record.getUpdateDate() == null) {
            record.setUpdateDate(new Date());
        }
        return (updateFlag = this.hyMessageDao.updateByPrimaryKeySelective(record)) == 1;
    }
}

