/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.filter.LoadProjectPath;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.modules.consult.service.SessionRedisCache;
import com.cxqm.xiaoerke.modules.haoyun.beans.ApiOrderVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.DoctorHospitalRelationCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.FamilyPatient;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyConsultationOrderCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.IOSMeetingRoom;
import com.cxqm.xiaoerke.modules.haoyun.beans.MWebOrderVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyConsultationOrderDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyOrderProposalDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyProposalDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HySubShiftScheduleDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyConsultationOrder;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDochelperHospitalRelation;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyOrderProposal;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyPatient;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyProposal;
import com.cxqm.xiaoerke.modules.haoyun.entity.HySubShiftSchedule;
import com.cxqm.xiaoerke.modules.haoyun.enums.OrderStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.RoomStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDochelperHospitalRelationService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyIOSMeetingService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyMeetingroomOrderService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyOrderService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyPatientService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserService;
import com.cxqm.xiaoerke.modules.haoyun.web.ApiUserInfo;
import com.cxqm.xiaoerke.modules.sys.dao.DoctorDao;
import com.cxqm.xiaoerke.modules.sys.dao.DoctorHospitalRelationDao;
import com.cxqm.xiaoerke.modules.sys.entity.DoctorHospitalRelationVo;
import com.cxqm.xiaoerke.modules.sys.entity.DoctorVo;
import com.cxqm.xiaoerke.modules.sys.entity.SysPropertyVoWithBLOBsVo;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.DoctorInfoService;
import com.cxqm.xiaoerke.modules.sys.service.SysPropertyServiceImpl;
import com.cxqm.xiaoerke.modules.sys.utils.WechatMessageUtil;
import com.zthzinfo.sdks.netease.im.service.NEIMChatroomService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyOrderServiceImpl
implements HyOrderService {
    @Autowired
    private HyIOSMeetingService hyIOSMeetingService;
    @Autowired
    private HyConsultationOrderDao hyConsultationOrderDao;
    @Autowired
    private NEIMChatroomService neimChatroomService;
    @Autowired
    private HySubShiftScheduleDao hySubShiftScheduleDao;
    @Autowired
    private HyMeetingroomOrderService hyMeetingroomOrderService;
    @Autowired
    HyPatientService hyPatientService;
    @Autowired
    DoctorInfoService doctorInfoService;
    @Autowired
    HyOrderProposalDao hyOrderProposalDao;
    @Autowired
    HyProposalDao hyProposalDao;
    @Autowired
    HyDochelperHospitalRelationService hyDochelperHospitalRelationService;
    @Autowired
    SysPropertyServiceImpl sysPropertyService;
    @Autowired
    private DoctorHospitalRelationDao doctorHospitalRelationDao;
    @Autowired
    private SessionRedisCache sessionRedisCache;
    @Autowired
    private DoctorDao doctorDao;
    @Autowired
    private HyUserService hyUserService;

    public List<OrderStatusEnum> getStatusCondition(String status) {
        if (status == null) {
            return null;
        }
        if (status.equals("0")) {
            return null;
        }
        if (status.equals("1")) {
            return new ArrayList<OrderStatusEnum>(Arrays.asList(OrderStatusEnum.PAYED));
        }
        if (status.equals("2")) {
            return new ArrayList<OrderStatusEnum>(Arrays.asList(OrderStatusEnum.END));
        }
        if (status.equals("3")) {
            return new ArrayList<OrderStatusEnum>(Arrays.asList(OrderStatusEnum.WAIT_PAY));
        }
        return null;
    }

    public List<HyConsultationOrder> findExpiredMeetingRoom() {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        condition.setMeetingExpiredTime(new Date());
        condition.setIs_cancel("NO");
        List<HyConsultationOrder> list = this.hyConsultationOrderDao.findOrderListByCondition(condition);
        return list;
    }

    public static void main(String[] args) throws ParseException {
        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2017-02-17 21:21:53");
        System.out.println(date.getTime());
    }

    public List<HyConsultationOrder> findCreateExpiredMeetingRoom(Long timeoutSecondForCreateRoom) {
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        condition.setIs_cancel("NO");
        condition.setCreateExpiredTime(timeoutSecondForCreateRoom);
        List<HyConsultationOrder> list = this.hyConsultationOrderDao.findOrderListByCondition(condition);
        return list;
    }

    public List<ApiOrderVo> transData(List<HyConsultationOrder> list, String id, String type, Boolean isFormatMobile) {
        List<ApiOrderVo> list4api = this.convertOrderForApi(list);
        list4api = this.fillDoctorHelpInfo(list4api);
        list4api = this.fillRole(list4api, id, type);
        if (isFormatMobile.booleanValue()) {
            for (int i = 0; i < list4api.size(); ++i) {
                String roleCode = list4api.get(i).getRoleCode();
                if (roleCode != null && roleCode.equals("30") || null == list4api.get(i).getMobile() || list4api.get(i).getMobile() == "") continue;
                String number = list4api.get(i).getMobile().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
                list4api.get(i).setMobile(number);
            }
        }
        return list4api;
    }

    public HyConsultationOrder findLatelyHistoryByCondition(HyConsultationOrderCondition condition) {
        return this.hyConsultationOrderDao.findLatelyHistoryByCondition(condition);
    }

    public Page<HyConsultationOrder> findByPage(Page<HyConsultationOrder> page, HyConsultationOrderCondition condition) {
        Page<HyConsultationOrder> result = this.hyConsultationOrderDao.findOrderListByPage(page, condition);
        List list = result.getList();
        if (list == null || list.size() == 0) {
            return new Page();
        }
        String[] orderIds = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            orderIds[i] = ((HyConsultationOrder)list.get(i)).getId();
        }
        HyOrderProposal order = new HyOrderProposal();
        order.setOrderIds(orderIds);
        List<HyOrderProposal> hyOrderProposalList = this.hyOrderProposalDao.findListByOrderId(order);
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < hyOrderProposalList.size(); ++j) {
                if (!((HyConsultationOrder)list.get(i)).getId().equals(hyOrderProposalList.get(j).getOrderId())) continue;
                if (((HyConsultationOrder)list.get(i)).getProposalName() != null) {
                    ((HyConsultationOrder)list.get(i)).setProposalName(((HyConsultationOrder)list.get(i)).getProposalName() + " " + hyOrderProposalList.get(j).getProposalName());
                    continue;
                }
                ((HyConsultationOrder)list.get(i)).setProposalName(hyOrderProposalList.get(j).getProposalName());
            }
        }
        result.setList(list);
        return result;
    }

    public List<HyConsultationOrder> findOrderList(HyConsultationOrderCondition condition) {
        List<HyConsultationOrder> result = this.hyConsultationOrderDao.findOrderListByCondition(condition);
        List<HyConsultationOrder> list = result;
        if (list == null || list.size() == 0) {
            return new ArrayList<HyConsultationOrder>();
        }
        String[] orderIds = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            orderIds[i] = list.get(i).getId();
        }
        HyOrderProposal order = new HyOrderProposal();
        order.setOrderIds(orderIds);
        List<HyOrderProposal> hyOrderProposalList = this.hyOrderProposalDao.findListByOrderId(order);
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < hyOrderProposalList.size(); ++j) {
                if (!list.get(i).getId().equals(hyOrderProposalList.get(j).getOrderId())) continue;
                if (list.get(i).getProposalName() != null) {
                    list.get(i).setProposalName(list.get(i).getProposalName() + " " + hyOrderProposalList.get(j).getProposalName());
                    continue;
                }
                list.get(i).setProposalName(hyOrderProposalList.get(j).getProposalName());
            }
        }
        return result;
    }

    public Page<MWebOrderVo> findByMWebOrderVoPage(Page<MWebOrderVo> page, HyConsultationOrderCondition condition) {
        Page pageCondition = new Page(page.getPageNo(), page.getPageSize());
        if (page != null && page.getOrderBy() != null) {
            pageCondition.setOrderBy(page.getOrderBy());
        }
        Page<HyConsultationOrder> orderPage = this.hyConsultationOrderDao.findOrderListByPage((Page<HyConsultationOrder>)pageCondition, condition);
        ArrayList<MWebOrderVo> voList = new ArrayList<MWebOrderVo>();
        if (orderPage != null && orderPage.getList() != null && orderPage.getList().size() > 0) {
            for (HyConsultationOrder order : orderPage.getList()) {
                MWebOrderVo vo = new MWebOrderVo(order);
                voList.add(vo);
            }
        }
        return new Page(orderPage.getPageNo(), orderPage.getPageSize(), orderPage.getCount(), voList);
    }

    public HyConsultationOrder findById(String id) {
        if (id == null) {
            return null;
        }
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        condition.setId(id);
        condition.setIs_cancel("yes");
        List<HyConsultationOrder> list = this.hyConsultationOrderDao.findOrderListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public HyConsultationOrder findByRoomId(String roomId) {
        if (roomId == null) {
            return null;
        }
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        condition.setRoomId(roomId);
        List<HyConsultationOrder> list = this.hyConsultationOrderDao.findOrderListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public HyConsultationOrder update(HyConsultationOrder order) {
        if (order == null) {
            return null;
        }
        this.hyConsultationOrderDao.updateByPrimaryKey(order);
        return order;
    }

    public HyConsultationOrder insert(HyConsultationOrder order) {
        if (order == null) {
            return null;
        }
        this.hyConsultationOrderDao.insert(order);
        return order;
    }

    public HyConsultationOrder createRoom(String orderId, String createUserId, String createUserLoginName, String name) {
        HyConsultationOrder orderByRoomId = this.findById(orderId);
        if (orderByRoomId == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_ERROR);
        }
        if (orderByRoomId.getRoomIsDisabled()) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_DISABLED);
        }
        if (orderByRoomId.getRoomCreateBy() != null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_REPEAT);
        }
        if (orderByRoomId.getRoomStatus() != RoomStatusEnum.WAIT_CREATE.getValue()) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_CREATING);
        }
        Integer overtimeMeeting = Global.getMeetingExpiredSecond();
        if (orderByRoomId.getMeetingSecond() != null && orderByRoomId.getMeetingSecond() > (long)overtimeMeeting.intValue()) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.OVERTIME_MEETING_ERROR);
        }
        IOSMeetingRoom room = this.hyIOSMeetingService.createRoom(createUserLoginName, name);
        User user = new User();
        user.setId(createUserId);
        Date timeNow = new Date();
        orderByRoomId.setRoomCreateBy(createUserId);
        orderByRoomId.setRoomCreateTime(timeNow);
        orderByRoomId.setUpdateBy(user);
        orderByRoomId.setRoomCreateByAccid(createUserLoginName);
        orderByRoomId.setUpdateDate(timeNow);
        orderByRoomId.setRoomStatus(RoomStatusEnum.CREATEING.getValue());
        orderByRoomId.setRoomId(room.getId() + "");
        this.update(orderByRoomId);
        this.hyMeetingroomOrderService.createMeetingroom(orderByRoomId.getId(), room.getId() + "", createUserLoginName);
        return orderByRoomId;
    }

    public HyConsultationOrder createRoomSuccess(String orderId, String createUserId) {
        HyConsultationOrder orderByRoomId = this.findById(orderId);
        if (orderByRoomId == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_ERROR);
        }
        if (orderByRoomId.getRoomStatus() != RoomStatusEnum.CREATEING.getValue()) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_NOT_CREATE);
        }
        if (!orderByRoomId.getRoomCreateBy().equals(ApiUserInfo.getUserId())) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.USER_NOT_MATCH);
        }
        User user = new User();
        user.setId(createUserId);
        Date timeNow = new Date();
        orderByRoomId.setUpdateBy(user);
        orderByRoomId.setUpdateDate(timeNow);
        Integer overtimeMeeting = Global.getMeetingExpiredSecond();
        orderByRoomId.setRoomExpiredTime(new Date(timeNow.getTime() + 1000L * ((long)overtimeMeeting.intValue() - (orderByRoomId.getMeetingSecond() == null ? 0L : orderByRoomId.getMeetingSecond()))));
        orderByRoomId.setRoomStatus(RoomStatusEnum.READY.getValue());
        this.update(orderByRoomId);
        this.hyMeetingroomOrderService.createSuccessMeetingroom(orderId, orderByRoomId.getRoomId(), timeNow);
        return orderByRoomId;
    }

    public HyConsultationOrder createRoomFailed(String orderId, String createUserId, String createUserLoginName) {
        HyConsultationOrder orderByRoomId = this.findById(orderId);
        if (orderByRoomId == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_ERROR);
        }
        if (orderByRoomId.getRoomStatus() != RoomStatusEnum.CREATEING.getValue()) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_NOT_CREATE);
        }
        if (!orderByRoomId.getRoomCreateBy().equals(ApiUserInfo.getUserId())) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.USER_NOT_MATCH);
        }
        try {
            this.hyIOSMeetingService.removeRoom(orderByRoomId.getRoomId(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerFactory.getLogger(this.getClass()).error("\u5173\u95ed\u623f\u95f4\u5931\u8d25B[" + orderByRoomId.getRoomId() + "/" + createUserLoginName + "]", (Throwable)e);
        }
        Date timeNow = new Date();
        this.hyMeetingroomOrderService.closeMeetingroom(orderId, orderByRoomId.getRoomId(), timeNow);
        User user = new User();
        user.setId(createUserId);
        orderByRoomId.setUpdateBy(user);
        orderByRoomId.setUpdateDate(timeNow);
        orderByRoomId.setRoomCreateBy(null);
        orderByRoomId.setRoomCreateByAccid(null);
        orderByRoomId.setRoomCreateTime(null);
        orderByRoomId.setRoomExpiredTime(null);
        orderByRoomId.setRoomId(null);
        orderByRoomId.setRoomStatus(RoomStatusEnum.WAIT_CREATE.getValue());
        this.update(orderByRoomId);
        return orderByRoomId;
    }

    public HyConsultationOrder closeTimeoutRoom(HyConsultationOrder orderByRoomId, String createUserId, String createUserLoginName, boolean byMe) {
        if (orderByRoomId == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_ERROR);
        }
        if (byMe && orderByRoomId.getRoomCreateBy() != null && !orderByRoomId.getRoomCreateBy().equals(createUserId)) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.USER_ROLE_ERROR);
        }
        if (createUserId == null || createUserId.equals("0")) {
            this.hyIOSMeetingService.removeRoom(orderByRoomId.getRoomId(), "\u623f\u95f4\u65f6\u95f4\u5df2\u7528\u5c3d");
        } else {
            this.hyIOSMeetingService.removeRoom(orderByRoomId.getRoomId(), "\u623f\u95f4\u5df2\u5173\u95ed");
        }
        Date timeNow = new Date();
        this.hyMeetingroomOrderService.closeMeetingroom(orderByRoomId.getId(), orderByRoomId.getRoomId(), timeNow);
        User user = new User();
        user.setId(createUserId);
        int meeting_second = (int)(timeNow.getTime() - orderByRoomId.getRoomCreateTime().getTime()) / 1000;
        orderByRoomId.setRoomCreateBy(null);
        orderByRoomId.setRoomCreateByAccid(null);
        orderByRoomId.setRoomCreateTime(null);
        orderByRoomId.setRoomExpiredTime(null);
        orderByRoomId.setRoomStatus(RoomStatusEnum.WAIT_CREATE.getValue());
        orderByRoomId.setUpdateBy(user);
        orderByRoomId.setUpdateDate(timeNow);
        orderByRoomId.setRoomId(null);
        orderByRoomId.setMeetingSecond(Long.valueOf((orderByRoomId.getMeetingSecond() == null ? 0L : orderByRoomId.getMeetingSecond()) + (long)meeting_second));
        this.update(orderByRoomId);
        return orderByRoomId;
    }

    public HyConsultationOrder closeRoom(String orderId, String createUserId, String createUserLoginName, boolean byMe) {
        HyConsultationOrder orderByRoomId = this.findById(orderId);
        this.closeTimeoutRoom(orderByRoomId, createUserId, createUserLoginName, byMe);
        return orderByRoomId;
    }

    public List<ApiOrderVo> convertOrderForApi(List<HyConsultationOrder> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ApiOrderVo> result = new ArrayList<ApiOrderVo>();
        for (HyConsultationOrder order : list) {
            result.add(new ApiOrderVo(order));
        }
        return result;
    }

    public List<ApiOrderVo> fillRole(List<ApiOrderVo> list, String userId, String roleCode) {
        if (list == null || list.size() == 0) {
            return list;
        }
        if (userId == null || userId.trim().length() == 0) {
            return null;
        }
        if (roleCode == null || roleCode.trim().length() == 0) {
            return null;
        }
        if (roleCode.equals("doctor")) {
            this.fillRoleDoctor(list, userId);
        } else if (roleCode.equals("doctorHelper")) {
            this.fillRoleDoctorHelp(list, userId);
        } else {
            for (ApiOrderVo apiOrderVo : list) {
                apiOrderVo.setRoleCode("40");
            }
        }
        return list;
    }

    private List<ApiOrderVo> fillRoleDoctorHelp(List<ApiOrderVo> list, String userId) {
        if (list == null || userId == null || list.size() == 0 || userId.trim().length() == 0) {
            return list;
        }
        List hyDochelperHospitalRelations = this.hyDochelperHospitalRelationService.selectListByUserId(userId);
        for (ApiOrderVo apiOrderVo : list) {
            for (HyDochelperHospitalRelation hyDochelperHospitalRelation : hyDochelperHospitalRelations) {
                if (apiOrderVo.getRequestHospitalId() == null || !apiOrderVo.getRequestHospitalId().equals(hyDochelperHospitalRelation.getHospital().getId())) continue;
                apiOrderVo.setRoleCode("30");
                break;
            }
            if (apiOrderVo.getRoleCode() != null) continue;
            apiOrderVo.setRoleCode("40");
        }
        return list;
    }

    private List<ApiOrderVo> fillDoctorHelpInfo(List<ApiOrderVo> list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ArrayList<String> hospitalIds = new ArrayList<String>();
        for (ApiOrderVo apiOrderVo : list) {
            if (apiOrderVo.getRequestHospitalId() == null || apiOrderVo.getRequestHospitalId().equals("")) continue;
            hospitalIds.add(apiOrderVo.getRequestHospitalId());
        }
        List hyDochelperHospitalRelationList = this.hyDochelperHospitalRelationService.selectFirstListByHospitalIds(hospitalIds);
        if (hyDochelperHospitalRelationList != null && hyDochelperHospitalRelationList.size() > 0) {
            HashMap<String, HyDochelperHospitalRelation> relationMap = new HashMap<String, HyDochelperHospitalRelation>();
            for (HyDochelperHospitalRelation relation : hyDochelperHospitalRelationList) {
                if (relation.getHospital() == null || relation.getHospital().getId() == null || relation.getHospital().getId().equals("")) continue;
                relationMap.put(relation.getHospital().getId(), relation);
            }
            for (ApiOrderVo apiOrderVo : list) {
                if (apiOrderVo.getRequestHospitalId() == null || apiOrderVo.getRequestHospitalId().equals("")) continue;
                HyDochelperHospitalRelation relation = (HyDochelperHospitalRelation)relationMap.get(apiOrderVo.getRequestHospitalId());
                apiOrderVo.setRequestDoctorHelper(relation.getUser().getRealName());
                apiOrderVo.setRequestDoctorHelperId(relation.getUser().getId());
                apiOrderVo.setRequestDoctorHelperMobile(relation.getUser().getMobile());
            }
        }
        return list;
    }

    private List<ApiOrderVo> fillRoleDoctor(List<ApiOrderVo> list, String userId) {
        if (list == null || userId == null || list.size() == 0 || userId.trim().length() == 0) {
            return list;
        }
        DoctorVo doctorCondition = new DoctorVo();
        doctorCondition.setSysUserId(userId);
        List doctorDetailInfo = this.doctorInfoService.findDoctorDetailInfo(doctorCondition);
        for (ApiOrderVo apiOrderVo : list) {
            for (DoctorVo doctorVo : doctorDetailInfo) {
                if (doctorVo.getId() != null && doctorVo.getId().equals(apiOrderVo.getRequestDoctorId())) {
                    apiOrderVo.setRoleCode("20");
                    break;
                }
                if (doctorVo.getId() == null || !doctorVo.getId().equals(apiOrderVo.getPlanDoctorId())) continue;
                apiOrderVo.setRoleCode("10");
                break;
            }
            if (apiOrderVo.getRoleCode() != null) continue;
            apiOrderVo.setRoleCode("40");
        }
        return list;
    }

    public Map<String, List<HySubShiftSchedule>> selectScheduleMapAfterToday(String dhrId) {
        HySubShiftSchedule condition = new HySubShiftSchedule();
        condition.setDhRelation(new DoctorHospitalRelationVo());
        condition.getDhRelation().setId(dhrId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_new = new SimpleDateFormat("HHmm");
        condition.setTemporaryDate(Integer.valueOf(sdf_new.format(new Date())));
        List<HySubShiftSchedule> schedules = this.hySubShiftScheduleDao.selectSchedulesAfterTodayByDoctorId(condition);
        LinkedHashMap<String, List<HySubShiftSchedule>> scheduleMap = new LinkedHashMap<String, List<HySubShiftSchedule>>();
        for (HySubShiftSchedule schedule : schedules) {
            String dateKey = sdf.format(schedule.getShiftDate());
            ArrayList<HySubShiftSchedule> list = (ArrayList<HySubShiftSchedule>)scheduleMap.get(dateKey);
            if (list == null) {
                list = new ArrayList<HySubShiftSchedule>();
                scheduleMap.put(dateKey, list);
            }
            list.add(schedule);
        }
        return scheduleMap;
    }

    public Map<String, List<HySubShiftSchedule>> selectScheduleMapAfterTodayByDoctor(String dhrId, String subHospitalId) {
        HySubShiftSchedule condition = new HySubShiftSchedule();
        condition.setDhRelation(new DoctorHospitalRelationVo());
        condition.getDhRelation().setId(dhrId);
        condition.setSubHospitalId(subHospitalId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_new = new SimpleDateFormat("HHmm");
        condition.setTemporaryDate(Integer.valueOf(sdf_new.format(new Date())));
        List<HySubShiftSchedule> schedules = this.hySubShiftScheduleDao.selectSchedulesAfterToday(condition);
        LinkedHashMap<String, List<HySubShiftSchedule>> scheduleMap = new LinkedHashMap<String, List<HySubShiftSchedule>>();
        for (HySubShiftSchedule schedule : schedules) {
            String dateKey = sdf.format(schedule.getShiftDate());
            ArrayList<HySubShiftSchedule> list = (ArrayList<HySubShiftSchedule>)scheduleMap.get(dateKey);
            if (list == null) {
                list = new ArrayList<HySubShiftSchedule>();
                scheduleMap.put(dateKey, list);
            }
            list.add(schedule);
        }
        return scheduleMap;
    }

    public HyConsultationOrder getHyConsultationOrderById(String id) {
        FamilyPatient familyPatients;
        HyConsultationOrder order = this.hyConsultationOrderDao.selectByPrimaryKey(id);
        String maleId = null;
        String femaleId = null;
        if (order.getMalePatient() != null && !order.getMalePatient().equals((Object)"")) {
            maleId = order.getMalePatient().getId();
        }
        if (order.getFemalePatient() != null && !order.getFemalePatient().equals((Object)"")) {
            femaleId = order.getFemalePatient().getId();
        }
        if ((familyPatients = this.hyPatientService.findFamilyPatients(maleId, femaleId)) != null) {
            if (familyPatients.getMale() != null) {
                order.setMalePatient((HyPatient)familyPatients.getMale());
            }
            if (familyPatients.getFemale() != null) {
                order.setFemalePatient((HyPatient)familyPatients.getFemale());
            }
        }
        return order;
    }

    public HySubShiftSchedule findHySubShiftSchedulById(String id) {
        return this.hySubShiftScheduleDao.selectByPrimaryKey(id);
    }

    public void updateHySubShiftSchedule(HySubShiftSchedule hySubShiftSchedule) {
        this.hySubShiftScheduleDao.updateByPrimaryKey(hySubShiftSchedule);
    }

    public HyConsultationOrder selectByOrderNo(String orderNO) {
        return this.hyConsultationOrderDao.selectByOrderNo(orderNO);
    }

    public void updateThreeMinuteOrderStatus(HyConsultationOrderCondition condition) {
        this.hyConsultationOrderDao.updateThreeMinuteOrderStatus(condition);
    }

    public void updateHySubShiftScheduleByOrderItem(HyConsultationOrderCondition condition) {
        this.hyConsultationOrderDao.updateHySubShiftScheduleByOrderItem(condition);
    }

    public List<HyConsultationOrder> findThreeMinuteOrderStatus() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HyConsultationOrderCondition condition = new HyConsultationOrderCondition();
        condition.setCurrentDate(sdf.format(new Date()));
        return this.hyConsultationOrderDao.findThreeMinuteOrderStatus(condition);
    }

    public void saveOrderProposal(HyOrderProposal orderProposal) {
        this.hyOrderProposalDao.insert(orderProposal);
    }

    public HyProposal findProposalById(String id) {
        return this.hyProposalDao.selectByPrimaryKey(id);
    }

    public List<HyProposal> findProposalList() {
        return this.hyProposalDao.findProposalList();
    }

    public void deleteOrderProposalByOrderId(String orderId) {
        this.hyOrderProposalDao.deleteByOrderId(orderId);
    }

    public void sendWechatOrderSummary(String openid, HyConsultationOrder order) {
        Map wechatParam = this.sessionRedisCache.getAngelParam();
        String token = wechatParam == null ? "" : (String)wechatParam.get("token");
        SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo = this.sysPropertyService.querySysProperty();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        WechatMessageUtil.templateModel((String)sysPropertyVoWithBLOBsVo.getOrderSummaryModelFirst(), (String)sysPropertyVoWithBLOBsVo.getOrderSummaryModelKeyword1().replaceAll("\\{\\s*women\\s*\\}", order.getFemalePatient().getName()).replaceAll("\\{\\s*men\\s*\\}", "    " + order.getMalePatient().getName()), (String)sysPropertyVoWithBLOBsVo.getOrderSummaryModelKeyword2().replaceAll("\\{\\s*time\\s*\\}", sdf.format(new Date())), (String)sysPropertyVoWithBLOBsVo.getOrderSummaryModelKeyword3(), (String)"", (String)"", (String)token, (String)(LoadProjectPath.getBaseurl(null) + Global.getConfig((String)"haoyun.mweb_path") + "/myorder/summary_detail.do?order_id=" + order.getId()), (String)openid, (String)sysPropertyVoWithBLOBsVo.getOrderSummaryModelId());
    }

    public void sendWechatOrderReturnPaySuccess(String openid, MWebOrderVo order) {
        Map doctorWechatParam = this.sessionRedisCache.getWeChatParamFromRedis("doctor");
        if (doctorWechatParam != null) {
            String docToken = (String)doctorWechatParam.get("token");
            SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo = this.sysPropertyService.querySysProperty();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String token = docToken;
            WechatMessageUtil.templateModel((String)sysPropertyVoWithBLOBsVo.getReturnPaymentAmountFirst(), (String)sysPropertyVoWithBLOBsVo.getReturnPaymentAmountKeyword1().replaceAll("\\{\\s*keyword1\\s*\\}", order.getPlanHospital()), (String)sysPropertyVoWithBLOBsVo.getReturnPaymentAmountKeyword2().replaceAll("\\{\\s*keyword2\\s*\\}", String.valueOf(order.getRefundAmount())), (String)"", (String)"", (String)"", (String)token, (String)(LoadProjectPath.getBaseurl(null) + Global.getConfig((String)"haoyun.mweb_path") + "/myorder/refund_success.do?order_id=" + order.getId()), (String)openid, (String)sysPropertyVoWithBLOBsVo.getReturnPaymentAmountSuccessId());
        }
    }

    public void sendWechatOrderReturnPayFailed(String openid, MWebOrderVo order) {
        Map doctorWechatParam = this.sessionRedisCache.getWeChatParamFromRedis("doctor");
        if (doctorWechatParam != null) {
            String docToken = (String)doctorWechatParam.get("token");
            SysPropertyVoWithBLOBsVo sysPropertyVoWithBLOBsVo = this.sysPropertyService.querySysProperty();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String token = docToken;
            WechatMessageUtil.templateModel((String)order.getPlanHospital(), (String)sysPropertyVoWithBLOBsVo.getReturnPaymentAmountKeyword1().replaceAll("\\{\\s*keyword1\\s*\\}", order.getOrderNo()), (String)sysPropertyVoWithBLOBsVo.getReturnPaymentAmountKeyword2().replaceAll("\\{\\s*keyword2\\s*\\}", order.getRefundAmount().toString()), (String)order.getRefundReanson(), (String)"", (String)"", (String)token, (String)(LoadProjectPath.getBaseurl(null) + Global.getConfig((String)"haoyun.mweb_path") + "/myorder/refund_failed.do?order_id=" + order.getId()), (String)openid, (String)sysPropertyVoWithBLOBsVo.getReturnPaymentAmountFailedId());
        }
    }

    public HyOrderProposal findHyOrderProposalByOrderId(String orderId) {
        return this.hyOrderProposalDao.findHyOrderProposalByOrderId(orderId);
    }

    public List<HyOrderProposal> findHyOrderProposalListByOrderId(String[] orderIds) {
        if (orderIds == null || orderIds.length == 0) {
            return null;
        }
        HyOrderProposal order = new HyOrderProposal();
        order.setOrderIds(orderIds);
        return this.hyOrderProposalDao.findListByOrderId(order);
    }

    public List<DoctorHospitalRelationVo> selectDoctorByHospitalId(DoctorHospitalRelationCondition condition) {
        return this.doctorHospitalRelationDao.selectDoctorByHospitalId(condition);
    }

    public List<HyConsultationOrder> findContactsListByOrder(HyConsultationOrderCondition condition) {
        return this.hyConsultationOrderDao.findContactsListByOrder(condition);
    }

    public Integer findWaitPayNumByUserId(String userId) {
        return this.hyConsultationOrderDao.findWaitPayNumByUserId(userId);
    }
}

