/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyPlanUserDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyDoctorUser;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyPlanUser;
import com.cxqm.xiaoerke.modules.haoyun.example.HyPlanUserExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyPlanUserService;
import com.cxqm.xiaoerke.modules.haoyun.util.HyDoctorUserQueueUtils;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyPlanUserServiceImpl
implements HyPlanUserService {
    @Autowired
    HyPlanUserDao hyPlanUserDao;

    public List<User> queryUserListByPlanId(String planId) {
        return this.hyPlanUserDao.queryUserListByPlanId(planId);
    }

    public void deleteByPlanId(String plan_id) {
        HyPlanUserExample example = new HyPlanUserExample();
        example.createCriteria().andHyDoctorManagePlanIdEqualTo(plan_id);
        this.hyPlanUserDao.deleteByExample(example);
    }

    public void save(String userIds, String planId, String currentUserId, String doctorUserId) {
        if (userIds == null || userIds.trim().equals("") || planId == null || planId.trim().equals("") || currentUserId == null || currentUserId.trim().equals("")) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.PARAM_ERROR);
        }
        String[] userIdArr = userIds.split(",");
        Date date = new Date();
        for (String userId : userIdArr) {
            if (userId == null || userId.trim().equals("")) break;
            HyPlanUser hyPlanUser = new HyPlanUser();
            hyPlanUser.setId(IdGen.vestaId());
            hyPlanUser.setHyDoctorManagePlanId(planId);
            hyPlanUser.setUserId(userId);
            hyPlanUser.setCreateBy(new User(currentUserId));
            hyPlanUser.setCreateDate(date);
            hyPlanUser.setDelFlag("0");
            this.hyPlanUserDao.insertSelective(hyPlanUser);
            HyDoctorUser hyDoctorUser = new HyDoctorUser();
            hyDoctorUser.setDoctorUserId(currentUserId);
            hyDoctorUser.setUserId(userId);
            HyDoctorUserQueueUtils.pushToPublicQueue(hyDoctorUser);
        }
    }
}

