/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.modules.haoyun.service.HyScavengingLoginService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class HyScavengingLoginServiceImpl
implements HyScavengingLoginService {
    private static final String HYZS_SCAN_LOGIN_SID_UUID_KEY = "hyzs.scan.login.sid.uuid.";
    private static final String HYZS_SCAN_LOGIN_UUID_SID_KEY = "hyzs.scan.login.uuid.sid.";
    private static final Integer HYZS_SCAN_LOGIN_QRCODE_TIMEOUT_SECONDS = 300;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public String getSid(String uuid) {
        if (uuid == null || uuid.trim().length() == 0) {
            return null;
        }
        String sid = (String)this.redisTemplate.opsForValue().get((Object)(HYZS_SCAN_LOGIN_UUID_SID_KEY + uuid));
        return sid;
    }

    public boolean setSid(String uuid, String sid) {
        if (uuid == null || uuid.trim().length() == 0 || sid == null || sid.trim().length() == 0) {
            return false;
        }
        String newSid = (String)this.redisTemplate.opsForValue().get((Object)(HYZS_SCAN_LOGIN_UUID_SID_KEY + uuid));
        if (newSid != null) {
            return false;
        }
        this.redisTemplate.opsForValue().set((Object)(HYZS_SCAN_LOGIN_UUID_SID_KEY + uuid), (Object)sid);
        return true;
    }

    public String getUuid(String sid) {
        if (sid == null || sid.trim().length() == 0) {
            return null;
        }
        String uuid = (String)this.redisTemplate.opsForValue().get((Object)(HYZS_SCAN_LOGIN_SID_UUID_KEY + sid));
        return uuid;
    }

    public boolean setUuid(String sid, String uuid) {
        this.redisTemplate.opsForValue().set((Object)(HYZS_SCAN_LOGIN_SID_UUID_KEY + sid), (Object)uuid);
        this.redisTemplate.expire((Object)(HYZS_SCAN_LOGIN_SID_UUID_KEY + sid), (long)HYZS_SCAN_LOGIN_QRCODE_TIMEOUT_SECONDS.intValue(), TimeUnit.SECONDS);
        return true;
    }

    public void clear(String sid) {
        if (sid == null || sid.trim().length() == 0) {
            return;
        }
        this.redisTemplate.delete((Object)(HYZS_SCAN_LOGIN_SID_UUID_KEY + sid));
        String uuid = (String)this.redisTemplate.opsForValue().get((Object)(HYZS_SCAN_LOGIN_SID_UUID_KEY + sid));
        if (uuid == null || uuid.trim().length() == 0) {
            return;
        }
        this.redisTemplate.delete((Object)(HYZS_SCAN_LOGIN_UUID_SID_KEY + uuid));
    }

    public String validate(String sid) {
        if (sid == null || sid.trim().length() == 0) {
            return null;
        }
        String uuid = (String)this.redisTemplate.opsForValue().get((Object)(HYZS_SCAN_LOGIN_SID_UUID_KEY + sid));
        if (uuid == null) {
            return null;
        }
        String newSid = (String)this.redisTemplate.opsForValue().get((Object)(HYZS_SCAN_LOGIN_UUID_SID_KEY + uuid));
        if (newSid == null || newSid.trim().length() == 0 || !newSid.equals(sid)) {
            return null;
        }
        return uuid;
    }
}

