/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyPatientLabelVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyUserLabelVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyUserLabelDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyUserLabel;
import com.cxqm.xiaoerke.modules.haoyun.example.HyLabelSubCategoryExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyLabelTopCategoryExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyUserLabelExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyLabelSubCategoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserLabelService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyUserLabelServiceImpl
implements HyUserLabelService {
    @Autowired
    HyUserLabelDao hyUserLabelDao;
    @Autowired
    HyLabelSubCategoryService hyLabelSubCategoryService;

    public void deleteByOrderId(String orderId) {
        HyUserLabelExample example = new HyUserLabelExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        List<HyUserLabel> list = this.hyUserLabelDao.selectByExample(example);
        if (list == null || list.size() == 0) {
            return;
        }
        for (HyUserLabel hyUserLabel : list) {
            this.hyUserLabelDao.deleteByPrimaryKey(hyUserLabel.getId());
        }
    }

    public List<HyUserLabelVo> queryUserStatusByOrderId(String orderId, String doctorUserId) {
        HyUserLabelExample userLabelExample = new HyUserLabelExample();
        HyUserLabelExample.Criteria userLabelExampleCriteria = userLabelExample.createCriteria();
        userLabelExampleCriteria.andOrderIdEqualTo(orderId);
        ArrayList<String> operatorIdList = new ArrayList<String>();
        operatorIdList.add(orderId);
        operatorIdList.add(doctorUserId);
        userLabelExampleCriteria.andOperatorIdIn(operatorIdList);
        HyLabelTopCategoryExample topCategoryExample = new HyLabelTopCategoryExample();
        topCategoryExample.setOrderByClause(" topLabel.sort asc ");
        HyLabelSubCategoryExample subCategoryExample = new HyLabelSubCategoryExample();
        subCategoryExample.setOrderByClause(" subLabel.sort asc  ");
        return this.findVoByExample(userLabelExample, topCategoryExample, subCategoryExample);
    }

    public List<HyUserLabel> findByExample(HyUserLabelExample example) {
        return this.hyUserLabelDao.selectByExample(example);
    }

    public List<HyUserLabelVo> findVoByExample(HyUserLabelExample eUserLabel, HyLabelTopCategoryExample eTopLabel, HyLabelSubCategoryExample eSubLabel) {
        return this.hyUserLabelDao.selectVoByExample(eUserLabel, eTopLabel, eSubLabel);
    }

    public boolean save(HyUserLabel hyUserLabel) {
        List<HyUserLabel> userLabelList;
        if (hyUserLabel == null) {
            return false;
        }
        if (hyUserLabel.getOrderId() == null || hyUserLabel.getOrderId().trim().length() == 0 || hyUserLabel.getLabelId() == null || hyUserLabel.getLabelId().trim().length() == 0) {
            return false;
        }
        HyUserLabelExample example = new HyUserLabelExample();
        HyUserLabelExample.Criteria criteria = example.createCriteria();
        criteria.andDelFlagEqualTo("0");
        criteria.andOrderIdEqualTo(hyUserLabel.getOrderId());
        criteria.andLabelIdEqualTo(hyUserLabel.getLabelId());
        if (hyUserLabel.getOperatorId() != null && hyUserLabel.getOperatorId().trim().length() > 0) {
            criteria.andOperatorIdEqualTo(hyUserLabel.getOperatorId());
        }
        if ((userLabelList = this.hyUserLabelDao.selectByExample(example)) != null && userLabelList.size() > 0) {
            return false;
        }
        hyUserLabel.setId(IdGen.vestaId());
        hyUserLabel.setCreateDate(new Date());
        int saveFlag = this.hyUserLabelDao.insertSelective(hyUserLabel);
        return saveFlag == 1;
    }

    public boolean remove(HyUserLabel hyUserLabel) {
        if (hyUserLabel == null || hyUserLabel.getId() == null || hyUserLabel.getId().trim().length() == 0) {
            return false;
        }
        hyUserLabel.setDelFlag("1");
        hyUserLabel.setUpdateDate(new Date());
        int updateFlag = this.hyUserLabelDao.updateByPrimaryKeySelective(hyUserLabel);
        return updateFlag == 1;
    }

    public HyUserLabel findById(String id) {
        return this.hyUserLabelDao.selectByPrimaryKey(id);
    }

    public List<HyPatientLabelVo> selectLabelPatient(String userId, HyUserLabelExample eUserLabel, HyLabelTopCategoryExample eTopLabel, HyLabelSubCategoryExample eSubLabel) {
        return this.hyUserLabelDao.selectLabelPatient(userId, eUserLabel, eTopLabel, eSubLabel);
    }
}

