/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyTubeStepVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyUserTubeDataVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyTubeStepDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyUserTubeDataDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyTubeStep;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyUserTubeData;
import com.cxqm.xiaoerke.modules.haoyun.example.HyTubeStepExample;
import com.cxqm.xiaoerke.modules.haoyun.example.HyUserTubeDataExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserTubeDataService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyUserTubeDataServiceImpl
implements HyUserTubeDataService {
    @Autowired
    HyUserTubeDataDao hyUserTubeDataDao;
    @Autowired
    HyTubeStepDao hyTubeStepDao;

    public List<HyUserTubeData> findByExample(HyUserTubeDataExample example) {
        return this.hyUserTubeDataDao.selectByExample(example);
    }

    public HyUserTubeDataVo findByUserId(String userId) {
        if (userId == null || userId.trim().length() == 0) {
            return null;
        }
        HyUserTubeDataExample example = new HyUserTubeDataExample();
        HyUserTubeDataExample.Criteria exampleCriteria = example.createCriteria();
        exampleCriteria.andDelFlagEqualTo("0");
        exampleCriteria.andUserIdEqualTo(userId);
        List<HyUserTubeDataVo> userTubeDataList = this.hyUserTubeDataDao.selectVoByExample(example);
        if (userTubeDataList == null || userTubeDataList.size() == 0) {
            return null;
        }
        HyUserTubeDataVo vo = userTubeDataList.get(0);
        this.fillHyTubeStepVo(vo);
        return vo;
    }

    public boolean saveOrUpdate(HyUserTubeData record) {
        if (record == null) {
            return false;
        }
        int saveOrUpdateFlag = 0;
        if (record.getId() == null || record.getId().trim().length() == 0) {
            record.setId(IdGen.vestaId());
            record.setCreateDate(new Date());
            saveOrUpdateFlag = this.hyUserTubeDataDao.insertSelective(record);
        } else {
            record.setUpdateDate(new Date());
            saveOrUpdateFlag = this.hyUserTubeDataDao.updateById(record);
        }
        return saveOrUpdateFlag == 1;
    }

    private void fillHyTubeStepVo(HyUserTubeDataVo vo) {
        if (vo == null) {
            return;
        }
        HyTubeStepExample stepExample = new HyTubeStepExample();
        stepExample.setOrderByClause(" sort asc ");
        HyTubeStepExample.Criteria stepExampleCriteria = stepExample.createCriteria();
        stepExampleCriteria.andDelFlagEqualTo("0");
        List<HyTubeStep> hyTubeStepList = this.hyTubeStepDao.selectByExampleWithBLOBs(stepExample);
        if (hyTubeStepList != null && hyTubeStepList.size() > 0) {
            HyTubeStep step;
            int i;
            ArrayList<HyTubeStepVo> hyTubeStepVoList = new ArrayList<HyTubeStepVo>();
            int currentStepIndex = 0;
            for (i = hyTubeStepList.size() - 1; i >= 0; --i) {
                step = hyTubeStepList.get(i);
                boolean breakFlag = false;
                if (vo.getTubeStepId() != null && vo.getTubeStepId().trim().length() > 0) {
                    String[] tubeStepIdArray;
                    for (String tubeStepId : tubeStepIdArray = vo.getTubeStepId().split(",")) {
                        if (!tubeStepId.equals(step.getId())) continue;
                        currentStepIndex = i;
                        breakFlag = true;
                        break;
                    }
                }
                if (breakFlag) break;
            }
            for (i = 0; i < hyTubeStepList.size(); ++i) {
                step = hyTubeStepList.get(i);
                HyTubeStepVo tubeStepVo = new HyTubeStepVo();
                tubeStepVo.setId(step.getId());
                tubeStepVo.setName(step.getName());
                tubeStepVo.setCode(step.getCode());
                tubeStepVo.setSort(step.getSort());
                tubeStepVo.setSummary(step.getSummary());
                tubeStepVo.setRemarks(step.getRemarks());
                if (i <= currentStepIndex) {
                    tubeStepVo.setHasPass(true);
                } else {
                    tubeStepVo.setHasPass(false);
                }
                hyTubeStepVoList.add(tubeStepVo);
            }
            vo.setHyTubeStepVoList(hyTubeStepVoList);
        }
    }

    private void fillHyTubeStepVo(List<HyUserTubeDataVo> dataVoList) {
        if (dataVoList == null || dataVoList.size() == 0) {
            return;
        }
        HyTubeStepExample stepExample = new HyTubeStepExample();
        stepExample.setOrderByClause(" sort asc ");
        List<HyTubeStep> hyTubeStepList = this.hyTubeStepDao.selectByExample(stepExample);
        for (HyUserTubeDataVo vo : dataVoList) {
            HyTubeStep step;
            int i;
            if (hyTubeStepList == null || hyTubeStepList.size() <= 0) continue;
            ArrayList<HyTubeStepVo> hyTubeStepVoList = new ArrayList<HyTubeStepVo>();
            int currentStepIndex = 0;
            for (i = hyTubeStepList.size() - 1; i >= 0; --i) {
                step = hyTubeStepList.get(i);
                boolean breakFlag = false;
                if (vo.getTubeStepId() != null && vo.getTubeStepId().trim().length() > 0) {
                    String[] tubeStepIdArray;
                    for (String tubeStepId : tubeStepIdArray = vo.getTubeStepId().split(",")) {
                        if (!tubeStepId.equals(step.getId())) continue;
                        currentStepIndex = i;
                        breakFlag = true;
                        break;
                    }
                }
                if (breakFlag) break;
            }
            for (i = 0; i < hyTubeStepList.size(); ++i) {
                step = hyTubeStepList.get(i);
                HyTubeStepVo tubeStepVo = new HyTubeStepVo();
                tubeStepVo.setId(step.getId());
                tubeStepVo.setName(step.getName());
                tubeStepVo.setCode(step.getCode());
                tubeStepVo.setSort(step.getSort());
                tubeStepVo.setSummary(step.getSummary());
                if (i <= currentStepIndex) {
                    tubeStepVo.setHasPass(true);
                } else {
                    tubeStepVo.setHasPass(false);
                }
                hyTubeStepVoList.add(tubeStepVo);
            }
            vo.setHyTubeStepVoList(hyTubeStepVoList);
        }
    }
}

