/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.modules.consult.service.SessionRedisCache;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.service.HyWechatPushService;
import com.cxqm.xiaoerke.modules.haoyun.util.PushWechatMsgUtils;
import com.cxqm.xiaoerke.modules.sys.beans.PushWechatMsg;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import com.cxqm.xiaoerke.modules.wechat.push.AngelWechatPushService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HyWechatPushServiceImpl
implements HyWechatPushService {
    @Autowired
    private AngelWechatPushService angelWechatPushService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    UserInfoService userInfoService;
    @Autowired
    private SessionRedisCache sessionRedisCache;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String reKey = "chat.user.";

    public void savePushRedisFiveMinutWithin(String userId) {
        String key = reKey + userId;
        this.redisTemplate.opsForValue().set((Object)key, (Object)userId);
        this.redisTemplate.expire((Object)key, 300L, TimeUnit.SECONDS);
    }

    public boolean isFiveMinutBack(String userId) {
        if (userId == null || userId.trim().equals("")) {
            return false;
        }
        String key = reKey + userId;
        if (this.redisTemplate.opsForValue().get((Object)key) == null) {
            System.out.println(key + " \u5df2\u6e05\u9664");
            return true;
        }
        System.out.println(key + " \u8fd8\u672a\u6e05\u9664");
        return false;
    }

    public void pushWechat(String userId, String fromName, String msgTime, String message, String url) {
        if (userId != null && this.isFiveMinutBack(userId)) {
            PushWechatMsg pushWechatMsg = new PushWechatMsg();
            pushWechatMsg.setUserId(userId);
            pushWechatMsg.setFromName(fromName + " \u533b\u751f");
            pushWechatMsg.setMessage(message);
            pushWechatMsg.setMsgTime(msgTime);
            pushWechatMsg.setUrl(url);
            pushWechatMsg.setModelId(Global.getConfig((String)"public_wechat_template_id"));
            PushWechatMsgUtils.pushWechatMsgRedisQueue(pushWechatMsg);
        }
    }

    public void pushSmallProgramToWechat(String user_id, String open_id, String phone_num, String url, String first_text, String first_color, String keyword1_text, String keyword1_color, String keyword2_text, String keyword2_color, String keyword3_text, String keyword3_color, String remark_text, String remark_color, String model_id, String access_token_key) {
        if (url == null || url.trim().equals("")) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.URL_NOT_NULL);
        }
        if (model_id == null || model_id.trim().equals("")) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.MODEL_ID_NOT_NULL);
        }
        String finalOpenId = open_id;
        String token = "";
        if (finalOpenId != null && finalOpenId.trim().length() != 0) {
            if (access_token_key != null && access_token_key.trim().length() != 0) {
                this.angelWechatPushService.pushByOpenId(open_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, access_token_key);
            } else {
                this.angelWechatPushService.pushByOpenId(open_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, first_color, keyword1_color, keyword2_color, keyword3_color, remark_color);
            }
        } else if (user_id != null && user_id.trim().length() != 0) {
            if (access_token_key != null && access_token_key.trim().length() != 0) {
                this.angelWechatPushService.pushByUserId(user_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, access_token_key);
            } else {
                this.angelWechatPushService.pushByUserId(user_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, first_color, keyword1_color, keyword2_color, keyword3_color, remark_color);
            }
        } else {
            this.angelWechatPushService.pushByPhone(phone_num, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text);
        }
    }
}

