/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyWithdrawCashVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyWithdrawCashMapper;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyWithdrawCash;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserAccount;
import com.cxqm.xiaoerke.modules.haoyun.enums.HyWithdrawCashEnum;
import com.cxqm.xiaoerke.modules.haoyun.example.HyWithdrawCashExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyWithdrawCashService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountDetailService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyWithdrawCashServiceImpl
implements HyWithdrawCashService {
    @Autowired
    HyWithdrawCashMapper hyWithdrawCashMapper;
    @Autowired
    SysUserAccountService sysUserAccountService;
    @Autowired
    SysUserAccountDetailService sysUserAccountDetailService;
    @Autowired
    UserInfoService userInfoService;

    public void add(HyWithdrawCash hyWithdrawCash) {
        if (hyWithdrawCash.getId() == null) {
            hyWithdrawCash.setId(IdGen.vestaId());
        }
        hyWithdrawCash.setCreateDate(new Date());
        hyWithdrawCash.setDelFlag("0");
        hyWithdrawCash.setUpdateDate(new Date());
        this.hyWithdrawCashMapper.insertSelective(hyWithdrawCash);
    }

    public void updateById(HyWithdrawCash hyWithdrawCash) {
        this.hyWithdrawCashMapper.updateByPrimaryKeySelective(hyWithdrawCash);
    }

    public HyWithdrawCash withdrawCash(String userId, Integer price) {
        User user = this.userInfoService.getUserById(userId);
        SysUserAccount sysUserAccount = this.sysUserAccountService.queryBalanceByUserId(userId);
        HyWithdrawCash hyWithdrawCash = new HyWithdrawCash();
        hyWithdrawCash.setPrice(price);
        hyWithdrawCash.setStatus(HyWithdrawCashEnum.AUDIT.getValue());
        hyWithdrawCash.setSysUserAccountId(sysUserAccount.getId());
        hyWithdrawCash.setGzhOpenid(user.getDoctorOpenid());
        hyWithdrawCash.setId(IdGen.vestaId());
        hyWithdrawCash.setCreateBy(user);
        this.sysUserAccountDetailService.saveWithdrawCash(sysUserAccount, price, hyWithdrawCash.getId());
        this.add(hyWithdrawCash);
        return hyWithdrawCash;
    }

    public HyWithdrawCash getById(String id) {
        return this.hyWithdrawCashMapper.selectByPrimaryKey(id);
    }

    public HyWithdrawCash getByDate(String date, String userId) {
        String startDate = date + " 00:00:00";
        String endDate = date + " 23:59:59";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = sdf.parse(startDate);
            end = sdf.parse(endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SysUserAccount sysUserAccount = this.sysUserAccountService.queryBalanceByUserId(userId);
        if (sysUserAccount == null) {
            return null;
        }
        HyWithdrawCashExample query = new HyWithdrawCashExample();
        query.createCriteria().andCreateDateGreaterThanOrEqualTo(start).andCreateDateLessThanOrEqualTo(end).andSysUserAccountIdEqualTo(sysUserAccount.getId());
        List<HyWithdrawCash> list = this.hyWithdrawCashMapper.selectByExample(query);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        HyWithdrawCashExample query1 = new HyWithdrawCashExample();
        query1.createCriteria().andStatusEqualTo(HyWithdrawCashEnum.AUDIT.getValue()).andSysUserAccountIdEqualTo(sysUserAccount.getId());
        list = this.hyWithdrawCashMapper.selectByExample(query1);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Page<HyWithdrawCashVo> findPageByVo(Page<HyWithdrawCashVo> page, HyWithdrawCashVo vo) {
        return this.hyWithdrawCashMapper.findPageByVo(page, vo);
    }

    public void agreeWithdrawCash(String hyWithdrawCashId) {
        this.updateStatus(hyWithdrawCashId, HyWithdrawCashEnum.PASS.getValue());
    }

    public void refuseWithdrawCash(String hyWithdrawCashId) {
        this.updateStatus(hyWithdrawCashId, HyWithdrawCashEnum.REFUSE.getValue());
    }

    private void updateStatus(String hyWithdrawCashId, Integer status) {
        HyWithdrawCash hyWithdrawCash = new HyWithdrawCash();
        hyWithdrawCash.setId(hyWithdrawCashId);
        hyWithdrawCash.setStatus(status);
        hyWithdrawCash.setUpdateDate(new Date());
        hyWithdrawCash.setExaminationTime(new Date());
        this.hyWithdrawCashMapper.updateByPrimaryKeySelective(hyWithdrawCash);
    }
}

