/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.bean.ParamNotNullError;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyHdYudengjiMapper;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyHdYudengji;
import com.cxqm.xiaoerke.modules.haoyun.enums.ModuleEnum;
import com.cxqm.xiaoerke.modules.haoyun.example.HyHdYudengjiExample;
import com.cxqm.xiaoerke.modules.haoyun.service.HyYdjService;
import com.cxqm.xiaoerke.modules.sys.enums.PayCouponBusinessEnum;
import com.cxqm.xiaoerke.modules.sys.service.PayCouponService;
import com.cxqm.xiaoerke.modules.sys.utils.TokenKeyUtil;
import com.cxqm.xiaoerke.modules.wechat.push.AngelWechatPushService;
import com.cxqm.xiaoerke.wechat.beans.WechatErrors;
import com.cxqm.xiaoerke.wechat.dao.WechatSubscriptionDao;
import com.cxqm.xiaoerke.wechat.entity.WechatQrcodeForever;
import com.cxqm.xiaoerke.wechat.entity.WechatQrcodeTemp;
import com.cxqm.xiaoerke.wechat.entity.WechatSubscription;
import com.cxqm.xiaoerke.wechat.example.WechatSubscriptionExample;
import com.cxqm.xiaoerke.wechat.service.WechatQrcodeForeverService;
import com.cxqm.xiaoerke.wechat.service.WechatQrcodeTempService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyYdjServiceImpl
implements HyYdjService {
    @Autowired
    MongoDictionaryService mongoDictionaryService;
    @Autowired
    WechatQrcodeForeverService wechatQrcodeForeverService;
    @Autowired
    WechatQrcodeTempService wechatQrcodeTempService;
    @Autowired
    WechatSubscriptionDao wechatSubscriptionDao;
    @Autowired
    HyHdYudengjiMapper hyHdYudengjiMapper;
    @Autowired
    PayCouponService payCouponService;
    @Autowired
    AngelWechatPushService angelWechatPushService;
    private static Logger log = LoggerFactory.getLogger(HyYdjServiceImpl.class);

    public String generateOrGetYdjFollowQrCode() {
        Integer environment = Integer.parseInt(Global.getConfig((String)"environment"));
        String qrcode = "";
        qrcode = environment == 1 ? this.generateOrGetYdjTempQrCode(ModuleEnum.YDJ_FOLLOW_MODULE, "ydj_follow_reply") : this.generateOrGetYdjForeverQrCode(ModuleEnum.YDJ_FOLLOW_MODULE, "ydj_follow_reply");
        return qrcode;
    }

    public String generateOrGetYdjRecommendQrCode() {
        Integer environment = Integer.parseInt(Global.getConfig((String)"environment"));
        String qrcode = "";
        qrcode = environment == 1 ? this.generateOrGetYdjTempQrCode(ModuleEnum.YDJ_RECOMMEND_MODULE, "ydj_recommend_reply") : this.generateOrGetYdjForeverQrCode(ModuleEnum.YDJ_RECOMMEND_MODULE, "ydj_recommend_reply");
        return qrcode;
    }

    public void checkoutReward() {
        int page = 1;
        int pageSize = 10;
        log.info("\u5f00\u59cb\u68c0\u6d4b\u9884\u767b\u8bb0\u7528\u6237\u4fe1\u606f===================");
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary("ydj_cycly_status");
        String status1 = mongoDictionary.getStr1();
        String status2 = mongoDictionary.getStr2();
        String templateId = Global.getConfig((String)"public_wechat_template_id");
        String openurl = "http://" + Global.getConfig((String)"baseUrl") + "/hy/mweb/coupon/all_list.do";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<HyHdYudengji> needUpdates = new ArrayList<HyHdYudengji>();
        block8: while (true) {
            Page<HyHdYudengji> data;
            if ((data = this.hyHdYudengjiMapper.checkoutRewardList((Page<HyHdYudengji>)new Page(page, pageSize))) == null || data.getList() == null || data.getList().size() <= 0) {
                log.info("\u672a\u67e5\u8be2\u5230\u9700\u8981\u53d1\u5956\u52b1\u4eba\u4fe1\u606f\uff1b\u5f53\u524d\u9875\u7801=" + page);
                break;
            }
            ++page;
            int i = 0;
            while (true) {
                if (i >= data.getList().size()) continue block8;
                HyHdYudengji temp = (HyHdYudengji)data.getList().get(i);
                HyHdYudengji needUpdate = new HyHdYudengji();
                needUpdate.setId(temp.getId());
                if (temp.getGrantVisit() != null && temp.getGrantVisit() == 0 && temp.getCycleStatus() != null && status1.indexOf(temp.getCycleStatus()) != -1) {
                    if (temp.getRegisterUserId() != null && temp.getRegisterUserId().length() > 0) {
                        this.payCouponService.sendYDJCoupon(temp.getRegisterUserId(), Integer.valueOf(6000), PayCouponBusinessEnum.INTERLOCUTION, "10");
                        try {
                            this.angelWechatPushService.pushByUserId(temp.getRegisterUserId(), templateId, openurl, "\u5956\u52b1\u53d1\u653e", "60\u95ee\u533b\u751f\u4f18\u60e0\u5238", formatter.format(new Date()), "\u7531\u4e8e\u60a8\u5230\u8bca\u53d1\u653e\u5956\u52b1", "", TokenKeyUtil.angel_key);
                        }
                        catch (Exception e) {
                            System.out.println("\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff01");
                        }
                    }
                    if (temp.getRecommendUserId() != null && temp.getRecommendUserId().length() > 0) {
                        this.payCouponService.sendYDJCoupon(temp.getRegisterUserId(), Integer.valueOf(15000), PayCouponBusinessEnum.MANAGE, "10");
                        try {
                            this.angelWechatPushService.pushByUserId(temp.getRegisterUserId(), templateId, openurl, "\u5956\u52b1\u53d1\u653e", "150\u75c5\u7a0b\u7ba1\u7406\u4f18\u60e0\u5238", formatter.format(new Date()), "\u7531\u4e8e\u60a8\u63a8\u8350\u7528\u6237\u5230\u8bca\u53d1\u653e\u5956\u52b1", "", TokenKeyUtil.angel_key);
                        }
                        catch (Exception e) {
                            System.out.println("\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff01");
                        }
                    }
                    needUpdate.setGrantVisit(Integer.valueOf(1));
                }
                if (temp.getGrantJinzhou() == 0 && status2.indexOf(temp.getCycleStatus()) != -1) {
                    if (temp.getRegisterUserId() != null && temp.getRegisterUserId().length() > 0) {
                        this.payCouponService.sendYDJCoupon(temp.getRegisterUserId(), Integer.valueOf(6000), PayCouponBusinessEnum.INTERLOCUTION, "10");
                        try {
                            this.angelWechatPushService.pushByUserId(temp.getRegisterUserId(), templateId, openurl, "\u5956\u52b1\u53d1\u653e", "60\u95ee\u533b\u751f\u4f18\u60e0\u5238", formatter.format(new Date()), "\u7531\u4e8e\u60a8\u8fdb\u5468\u53d1\u653e\u5956\u52b1", "", TokenKeyUtil.angel_key);
                        }
                        catch (Exception e) {
                            System.out.println("\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff01");
                        }
                    }
                    if (temp.getRecommendUserId() != null && temp.getRecommendUserId().length() > 0) {
                        this.payCouponService.sendYDJCoupon(temp.getRegisterUserId(), Integer.valueOf(5000), PayCouponBusinessEnum.MANAGE, "10");
                        try {
                            this.angelWechatPushService.pushByUserId(temp.getRegisterUserId(), templateId, openurl, "\u5956\u52b1\u53d1\u653e", "50\u75c5\u7a0b\u7ba1\u7406\u4f18\u60e0\u5238", formatter.format(new Date()), "\u7531\u4e8e\u60a8\u63a8\u8350\u7528\u6237\u8fdb\u5468\u53d1\u653e\u5956\u52b1", "", TokenKeyUtil.angel_key);
                        }
                        catch (Exception e) {
                            System.out.println("\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff01");
                        }
                    }
                    needUpdate.setGrantJinzhou(Integer.valueOf(1));
                    needUpdate.setReward(Integer.valueOf(1));
                }
                if (needUpdate.getGrantVisit() != null || needUpdate.getGrantJinzhou() != null) {
                    needUpdates.add(needUpdate);
                }
                ++i;
            }
            break;
        }
        if (needUpdates != null && needUpdates.size() > 0) {
            for (int i = 0; i < needUpdates.size(); ++i) {
                HyHdYudengji temp = (HyHdYudengji)needUpdates.get(i);
                this.hyHdYudengjiMapper.updateByPrimaryKeySelective(temp);
            }
        }
    }

    private String generateOrGetYdjForeverQrCode(ModuleEnum moduleEnum, String mongoKey) {
        if (moduleEnum == null || moduleEnum.getValue() == null || moduleEnum.getValue().trim().length() <= 0) {
            AssertEx.failByError((IErrorInfo)new ParamNotNullError("\u4e8c\u7ef4\u7801\u4e1a\u52a1\u7f16\u7801"));
        }
        WechatSubscriptionExample subscriptionExample = new WechatSubscriptionExample();
        subscriptionExample.createCriteria().andCodeEqualTo(Global.getConfig((String)"ydj.wechat.code"));
        List subscriptionList = this.wechatSubscriptionDao.selectByExample(subscriptionExample);
        if (subscriptionList == null || subscriptionList.size() == 0) {
            AssertEx.failByError((IErrorInfo)WechatErrors.WECHAT_NOT_FOUND);
        }
        WechatQrcodeForever qrcodeForever = new WechatQrcodeForever();
        qrcodeForever.setCode(moduleEnum.getValue());
        qrcodeForever.setSubscriptionId(((WechatSubscription)subscriptionList.get(0)).getId());
        qrcodeForever.setSpare1Str("ydj");
        if (mongoKey != null) {
            MongoDictionary ydj_follow_reply = this.mongoDictionaryService.queryDictionary(mongoKey);
            qrcodeForever.setSpare5Str(ydj_follow_reply.getStr1());
        }
        qrcodeForever.preInsert();
        return this.wechatQrcodeForeverService.createForeverQrcode(qrcodeForever).getQrcodeUrl();
    }

    private String generateOrGetYdjTempQrCode(ModuleEnum moduleEnum, String mongoKey) {
        if (moduleEnum == null || moduleEnum.getValue() == null || moduleEnum.getValue().trim().length() <= 0) {
            AssertEx.failByError((IErrorInfo)new ParamNotNullError("\u4e8c\u7ef4\u7801\u4e1a\u52a1\u7f16\u7801"));
        }
        WechatQrcodeTemp qrcodeTemp = new WechatQrcodeTemp();
        Date date = new Date();
        date.setTime(new Date().getTime() + 2592000000L);
        qrcodeTemp.setActiveTime(date);
        qrcodeTemp.setCode(moduleEnum.getValue());
        WechatSubscriptionExample subscriptionExample = new WechatSubscriptionExample();
        subscriptionExample.createCriteria().andCodeEqualTo(Global.getConfig((String)"ydj.wechat.code"));
        List subscriptionList = this.wechatSubscriptionDao.selectByExample(subscriptionExample);
        if (subscriptionList == null || subscriptionList.size() == 0) {
            AssertEx.failByError((IErrorInfo)WechatErrors.WECHAT_NOT_FOUND);
        }
        qrcodeTemp.setSubscriptionId(((WechatSubscription)subscriptionList.get(0)).getId());
        qrcodeTemp.setSpare1Str("ydj");
        if (mongoKey != null) {
            MongoDictionary ydj_follow_reply = this.mongoDictionaryService.queryDictionary(mongoKey);
            qrcodeTemp.setSpare5Str(ydj_follow_reply.getStr1());
        }
        qrcodeTemp.preInsert();
        return this.wechatQrcodeTempService.createTempQrcode(qrcodeTemp).getQrcodeUrl();
    }

    public void updateLastByOpenId(String openid, HyHdYudengji hyHdYudengji) {
        HyHdYudengji temp = this.getByOpenid(openid);
        if (temp != null) {
            hyHdYudengji.setId(temp.getId());
            this.hyHdYudengjiMapper.updateByPrimaryKeySelective(hyHdYudengji);
        }
    }

    public void saveYDJInfo(HyHdYudengji hyHdYudengji) {
        hyHdYudengji.setId(IdGen.vestaId());
        hyHdYudengji.setCreateDate(new Date());
        hyHdYudengji.setDelFlag("0");
        this.hyHdYudengjiMapper.insertSelective(hyHdYudengji);
    }

    public boolean haveCardNo(String cardNo) {
        HyHdYudengjiExample query = new HyHdYudengjiExample();
        query.createCriteria().andCardnoEqualTo(cardNo).andDelFlagEqualTo("0");
        List<HyHdYudengji> list = this.hyHdYudengjiMapper.selectByExample(query);
        return list != null && list.size() > 0;
    }

    public HyHdYudengji getByOpenid(String openid) {
        HyHdYudengjiExample query = new HyHdYudengjiExample();
        query.createCriteria().andOpenidEqualTo(openid).andDelFlagEqualTo("0");
        query.setOrderByClause(" create_date desc");
        List<HyHdYudengji> list = this.hyHdYudengjiMapper.selectByExample(query);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public HyHdYudengji findByOpenid(String openid) {
        if (openid == null || openid.trim().length() <= 0) {
            return null;
        }
        HyHdYudengjiExample example = new HyHdYudengjiExample();
        example.createCriteria().andOpenidEqualTo(openid).andDelFlagEqualTo("0");
        List<HyHdYudengji> list = this.hyHdYudengjiMapper.selectByExample(example);
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.get(0);
    }
}

