/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyDoctorManageOrderCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.JhsxReferralBean;
import com.cxqm.xiaoerke.modules.haoyun.beans.JhsxReferralCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.UserDetailVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.JhsxReferralMapper;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserAccountDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserAccountDetailDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyLabelSubCategory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyScheme;
import com.cxqm.xiaoerke.modules.haoyun.entity.HySchemeDoctor;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyYunSubStatus;
import com.cxqm.xiaoerke.modules.haoyun.entity.JhsxReferral;
import com.cxqm.xiaoerke.modules.haoyun.entity.JhsxReferralExample;
import com.cxqm.xiaoerke.modules.haoyun.enums.JhsxReferralEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.JhsxReferralRefundStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.service.HyDoctorManagePlanService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyLabelSubCategoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HySchemeDoctorService;
import com.cxqm.xiaoerke.modules.haoyun.service.HySchemeService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserLabelService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserYunStatusService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyYunSubStatusService;
import com.cxqm.xiaoerke.modules.haoyun.service.JhsxReferralService;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserAccountDetailService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JhsxReferralServiceImpl
implements JhsxReferralService {
    @Autowired
    JhsxReferralMapper JhsxReferralMapper;
    @Autowired
    HyDoctorManagePlanService hyDoctorManagePlanService;
    @Autowired
    HySchemeService hySchemeService;
    @Autowired
    HyUserLabelService hyUserLabelService;
    @Autowired
    UserInfoService userInfoService;
    @Autowired
    HyUserYunStatusService hyUserYunStatusService;
    @Autowired
    HyYunSubStatusService hyYunSubStatusService;
    @Autowired
    HySchemeDoctorService hySchemeDoctorService;
    @Autowired
    HyLabelSubCategoryService hyLabelSubCategoryService;
    @Autowired
    SysUserAccountDetailDao sysUserAccountDetailDao;
    @Autowired
    SysUserAccountDao sysUserAccountDao;
    @Autowired
    SysUserAccountDetailService sysUserAccountDetailService;

    public void refundOrder(String id, String userId) {
        JhsxReferral JhsxReferral2 = new JhsxReferral();
        Date date = new Date();
        JhsxReferral2.setId(id);
        JhsxReferral2.setUpdateBy(new User(userId));
        JhsxReferral2.setUpdateDate(date);
        JhsxReferral2.setRefundStatus(JhsxReferralRefundStatusEnum.AGREE_REFUND.getCode());
        this.JhsxReferralMapper.updateByPrimaryKeySelective(JhsxReferral2);
    }

    public int queryMyDoctorNumber(String userId) {
        HyDoctorManageOrderCondition condition = new HyDoctorManageOrderCondition();
        condition.setOrderStatus(JhsxReferralEnum.USER_PAY_SUCCESS.getCode());
        condition.setUserId(userId);
        return 1;
    }

    public void refuseRefundOrder(String id, String userId, String refundReason) {
        JhsxReferral JhsxReferral2 = new JhsxReferral();
        Date date = new Date();
        JhsxReferral2.setId(id);
        JhsxReferral2.setUpdateBy(new User(userId));
        JhsxReferral2.setUpdateDate(date);
        JhsxReferral2.setRefundReason(refundReason);
        JhsxReferral2.setRefundStatus(JhsxReferralRefundStatusEnum.REFUSE_REFUND.getCode());
        this.JhsxReferralMapper.updateByPrimaryKeySelective(JhsxReferral2);
    }

    public void applyRefundOrder(String id, String userId, String refundReason) {
        JhsxReferral JhsxReferral2 = new JhsxReferral();
        Date date = new Date();
        JhsxReferral2.setId(id);
        JhsxReferral2.setUpdateBy(new User(userId));
        JhsxReferral2.setUpdateDate(date);
        JhsxReferral2.setRefundReason(refundReason);
        JhsxReferral2.setRefundStatus(JhsxReferralRefundStatusEnum.APPLY_REFUND_WAITING.getCode());
        this.JhsxReferralMapper.updateByPrimaryKeySelective(JhsxReferral2);
    }

    public Page<JhsxReferralBean> queryAlreadyPaidPage(Page<JhsxReferralBean> page, JhsxReferralBean JhsxReferralBean2) {
        JhsxReferralBean2 = JhsxReferralBean2 == null ? new JhsxReferralBean() : JhsxReferralBean2;
        JhsxReferralBean2.setAlreadyPaid(true);
        return this.JhsxReferralMapper.queryPage(page, JhsxReferralBean2);
    }

    public Page<JhsxReferralBean> queryApplyRefundPage(Page<JhsxReferralBean> page, JhsxReferralBean JhsxReferralBean2) {
        JhsxReferralBean2 = JhsxReferralBean2 == null ? new JhsxReferralBean() : JhsxReferralBean2;
        JhsxReferralBean2.setRefundStatus(JhsxReferralRefundStatusEnum.APPLY_REFUND_WAITING.getCode());
        return this.JhsxReferralMapper.queryPage(page, JhsxReferralBean2);
    }

    public List<User> queryOutDoctorList() {
        return this.JhsxReferralMapper.queryOutDoctorList();
    }

    public List<User> queryInnerDoctorList() {
        return this.JhsxReferralMapper.queryInnerDoctorList();
    }

    public void payOrderInvalid(String orderId) {
        JhsxReferral order = this.queryById(orderId);
        if (order.getOrderStatus().equals(JhsxReferralEnum.DOCTOR_AGREE.getCode()) || order.getOrderStatus().equals(JhsxReferralEnum.WAIT_USER_AGREE.getCode())) {
            this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
        }
    }

    public boolean currentOrderIsExist(String doctorUserId, String userId) {
        JhsxReferralExample example = new JhsxReferralExample();
        JhsxReferralExample example1 = new JhsxReferralExample();
        JhsxReferralExample example2 = new JhsxReferralExample();
        JhsxReferralExample example3 = new JhsxReferralExample();
        example.or(example1.createCriteria());
        example.or(example2.createCriteria());
        example.or(example3.createCriteria());
        List<JhsxReferral> list = this.JhsxReferralMapper.selectByExample(example);
        return list != null && list.size() != 0;
    }

    public JhsxReferral queryManageOrderByOrderId(String id) {
        return this.JhsxReferralMapper.selectByPrimaryKey(id);
    }

    public JhsxReferral queryByOrderNo(String orderNo) {
        JhsxReferralExample example = new JhsxReferralExample();
        List<JhsxReferral> list = this.JhsxReferralMapper.selectByExample(example);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public void doctorInviteInvalid(String orderId) {
        JhsxReferral order = this.queryById(orderId);
        if (order.getOrderStatus().equals(JhsxReferralEnum.WAIT_USER_AGREE.getCode())) {
            this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
        }
    }

    public void userInviteInvalid(String orderId) {
        JhsxReferral order = this.queryById(orderId);
        if (order.getOrderStatus().equals(JhsxReferralEnum.WAIT_DOTOC_AGREE.getCode())) {
            this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
        }
    }

    public void orderInvalid(String orderId) {
        JhsxReferral order = this.queryById(orderId);
        if (order.getOrderStatus().equals(JhsxReferralEnum.USER_PAY_SUCCESS.getCode())) {
            this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
        }
    }

    public JhsxReferral createOrderByUserId(String userId, String schemeId, String doctorId, String price) {
        JhsxReferral order = new JhsxReferral();
        order.setId(IdGen.vestaId());
        order.setOrderNo(IdGen.vestaId());
        order.setCreateBy(new User(doctorId));
        order.setCreateDate(new Date());
        order.setDelFlag("0");
        this.JhsxReferralMapper.insertSelective(order);
        return order;
    }

    public JhsxReferral createOrder(String doctorId, String schemeId, String userId, String price) {
        JhsxReferral order = new JhsxReferral();
        order.setId(IdGen.vestaId());
        order.setOrderNo(IdGen.vestaId());
        order.setCreateBy(new User(userId));
        order.setCreateDate(new Date());
        order.setDelFlag("0");
        HySchemeDoctor hySchemeDoctor = this.hySchemeDoctorService.querySchemeByDoctorUserIdAndSchemeId(doctorId, schemeId);
        int actualPrice = 0;
        if (hySchemeDoctor != null && hySchemeDoctor.getPrice() != null) {
            actualPrice = (int)(hySchemeDoctor.getPrice() * 100.0);
        }
        this.JhsxReferralMapper.insertSelective(order);
        return order;
    }

    public void updatePayOrderStatus(String orderId, String price, String buyTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        JhsxReferral order = this.queryById(orderId);
        this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
    }

    public int queryOrderNumber(String doctorId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(JhsxReferralEnum.ORDER_END.getCode().toString());
        list.add(JhsxReferralEnum.USER_EVALUATE.getCode().toString());
        list.add(JhsxReferralEnum.USER_NOT_EVALUATE.getCode().toString());
        return 1;
    }

    public void userEvaluateDoctor(String orderId, String content, Integer key, Integer key2, Integer key3) {
        JhsxReferral order = this.queryById(orderId);
        order.setUpdateDate(new Date());
        order.setRemarks(content);
        this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
    }

    public Page<JhsxReferralBean> queryMyOrderHistory(Page<JhsxReferralBean> page, String userId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(JhsxReferralEnum.ORDER_END.getCode().toString());
        list.add(JhsxReferralEnum.USER_EVALUATE.getCode().toString());
        list.add(JhsxReferralEnum.USER_NOT_EVALUATE.getCode().toString());
        list.add(JhsxReferralEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(JhsxReferralEnum.ORDER_REFUND.getCode().toString());
        list.add(JhsxReferralEnum.ORDER_PAY_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.ORDER_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_REFUSE.getCode().toString());
        return this.JhsxReferralMapper.queryDoctorHistoryPage(page, condition);
    }

    public Page<JhsxReferralBean> queryMyOrder(Page<JhsxReferralBean> page, String userId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(JhsxReferralEnum.WAIT_DOTOC_AGREE.getCode().toString());
        list.add(JhsxReferralEnum.DOCTOR_AGREE.getCode().toString());
        list.add(JhsxReferralEnum.WAIT_USER_AGREE.getCode().toString());
        list.add(JhsxReferralEnum.USER_PAY_SUCCESS.getCode().toString());
        return null;
    }

    public Page<JhsxReferralBean> queryManageDoctor(Page<JhsxReferral> page, String userId, String name) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        return null;
    }

    public Page<JhsxReferralBean> queryExecutionOrder(Page<JhsxReferral> page, String doctorId, String status, String scheme, String label) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        if (label != null && !"".equals(label == null ? "" : label.trim())) {
            String[] labels = label.split(",");
            ArrayList<String> labelList = new ArrayList<String>();
            for (String l : labels) {
                labelList.add(l);
            }
        }
        if (scheme != null && !"".equals(scheme == null ? "" : scheme.trim())) {
            String[] schemes = scheme.split(",");
            ArrayList<String> schemeList = new ArrayList<String>();
            for (String l : schemes) {
                schemeList.add(l);
            }
        }
        if (status != null && !"".equals(status == null ? "" : status.trim())) {
            String[] statuss = status.split(",");
            ArrayList<String> statusList = new ArrayList<String>();
            for (String l : statuss) {
                statusList.add(l);
            }
        }
        return null;
    }

    public UserDetailVo queryUserDetail(String userId, String orderId) {
        User user = this.userInfoService.getUserById(userId);
        UserDetailVo userDetailVo = new UserDetailVo();
        this.packageUser(userDetailVo, user);
        List list = this.hyLabelSubCategoryService.queryByUserId(orderId);
        userDetailVo.setLabelList(list);
        HyYunSubStatus status = this.hyYunSubStatusService.queryStatusByUserId(user.getId());
        userDetailVo.setStatusName(status == null ? "" : status.getName());
        return userDetailVo;
    }

    public Page<JhsxReferralBean> queryApplying(Page<JhsxReferral> page, String doctorId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        return null;
    }

    public Page<JhsxReferralBean> queryNotPayment(Page<JhsxReferral> page, String doctorId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        return null;
    }

    public List<HyLabelSubCategory> queryManageDistinctLabel(String doctorId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        return null;
    }

    public List<HyScheme> queryManageDistinctScheme(String doctorId) {
        List schemeDoctorList = this.hySchemeDoctorService.querySchemeList(doctorId);
        if (schemeDoctorList == null || schemeDoctorList.size() == 0) {
            return null;
        }
        ArrayList<HyScheme> list = new ArrayList<HyScheme>();
        for (HySchemeDoctor hySchemeDoctor : schemeDoctorList) {
            list.add(hySchemeDoctor.getHyScheme());
        }
        return list;
    }

    public List<HyLabelSubCategory> queryHistoryDistinctLabel(String doctorId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(JhsxReferralEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_EVALUATE.getCode().toString());
        list.add(JhsxReferralEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(JhsxReferralEnum.USER_REFUSE.getCode().toString());
        list.add(JhsxReferralEnum.ORDER_END.getCode().toString());
        list.add(JhsxReferralEnum.USER_NOT_EVALUATE.getCode().toString());
        return null;
    }

    public List<HyLabelSubCategory> queryManageLabel(String doctorId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(JhsxReferralEnum.USER_PAY_SUCCESS.getCode().toString());
        return null;
    }

    public List<HyScheme> queryHistoryDistinctScheme(String doctorId) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        ArrayList<String> list = new ArrayList<String>();
        list.add(JhsxReferralEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_EVALUATE.getCode().toString());
        list.add(JhsxReferralEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(JhsxReferralEnum.USER_REFUSE.getCode().toString());
        return null;
    }

    public Page<JhsxReferralBean> queryDoctorHistoryPageByDoctorId(Page<JhsxReferralBean> page, String doctorId, String status, String scheme, String label) {
        JhsxReferralCondition condition = new JhsxReferralCondition();
        if (label != null && !"".equals(label == null ? "" : label.trim())) {
            String[] labels = label.split(",");
            ArrayList<String> labelList = new ArrayList<String>();
            for (String l : labels) {
                labelList.add(l);
            }
        }
        if (scheme != null && !"".equals(scheme == null ? "" : scheme.trim())) {
            String[] schemes = scheme.split(",");
            ArrayList<String> schemeList = new ArrayList<String>();
            for (String l : schemes) {
                schemeList.add(l);
            }
        }
        if (status != null && !"".equals(status == null ? "" : status.trim())) {
            String[] statuss = status.split(",");
            ArrayList<String> statusList = new ArrayList<String>();
            for (String l : statuss) {
                statusList.add(l);
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(JhsxReferralEnum.DOCTOR_INVITATION_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_INVITATION_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_EVALUATE.getCode().toString());
        list.add(JhsxReferralEnum.DOCTOR_REFUSE.getCode().toString());
        list.add(JhsxReferralEnum.USER_REFUSE.getCode().toString());
        list.add(JhsxReferralEnum.ORDER_END.getCode().toString());
        list.add(JhsxReferralEnum.ORDER_REFUND.getCode().toString());
        list.add(JhsxReferralEnum.ORDER_PAY_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.ORDER_INVALID.getCode().toString());
        list.add(JhsxReferralEnum.USER_NOT_EVALUATE.getCode().toString());
        return null;
    }

    public JhsxReferral queryById(String id) {
        JhsxReferralExample example = new JhsxReferralExample();
        example.createCriteria().andIdEqualTo(id);
        List<JhsxReferral> list = this.JhsxReferralMapper.selectByExample(example);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public UserDetailVo packageUserDetailVo(String doctorUserId, String orderId) {
        JhsxReferral JhsxReferral2 = this.queryById(orderId);
        UserDetailVo userDetailVo = new UserDetailVo();
        List list = this.hyLabelSubCategoryService.queryByUserId(orderId);
        userDetailVo.setLabelList(list);
        return userDetailVo;
    }

    private void packageUser(UserDetailVo userDetailVo, User user) {
        userDetailVo.setId(user.getId());
        userDetailVo.setName(user.getName());
        userDetailVo.setBuckter(user.getBuckter());
        userDetailVo.setMarketer(user.getMarketer());
        userDetailVo.setPhoto(user.getPhoto());
        userDetailVo.setSex(user.getSex());
        userDetailVo.setDetailedAddress(user.getDetailedAddress());
        userDetailVo.setHeight(user.getHeight());
        userDetailVo.setWeight(user.getWeight());
        userDetailVo.setBirthDate(user.getBirthDate());
        userDetailVo.setRegion(user.getRegion());
    }

    public void selectedUser(String userId, String planId, String currentUserId) {
        JhsxReferral JhsxReferral2 = new JhsxReferral();
        JhsxReferral2.setId(IdGen.vestaId());
        JhsxReferral2.setOrderNo(IdGen.vestaId());
        JhsxReferral2.setCreateBy(new User(currentUserId));
        JhsxReferral2.setCreateDate(new Date());
        JhsxReferral2.setDelFlag("0");
        this.JhsxReferralMapper.insertSelective(JhsxReferral2);
    }

    public void agreeManage(String doctorUserId, String orderId) {
        JhsxReferralExample example = new JhsxReferralExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<JhsxReferral> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        JhsxReferral order = list.get(0);
        order.setUpdateBy(new User(doctorUserId));
        order.setUpdateDate(new Date());
        this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
    }

    public void refuseManage(String doctorUserId, String orderId) {
        JhsxReferralExample example = new JhsxReferralExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<JhsxReferral> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        JhsxReferral order = list.get(0);
        order.setUpdateBy(new User(doctorUserId));
        order.setUpdateDate(new Date());
        this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
    }

    public void userEndManage(String orderId) {
        JhsxReferralExample example = new JhsxReferralExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<JhsxReferral> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        JhsxReferral order = list.get(0);
        order.setUpdateDate(new Date());
        this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
    }

    public void userRefuseManage(String orderId) {
        JhsxReferralExample example = new JhsxReferralExample();
        example.createCriteria().andIdEqualTo(orderId);
        List<JhsxReferral> list = this.queryList(example);
        if (list == null || list.size() == 0) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_INFO_NOT_NULL);
        }
        JhsxReferral order = list.get(0);
        order.setUpdateDate(new Date());
        this.JhsxReferralMapper.updateByPrimaryKeySelective(order);
    }

    public Page<JhsxReferralBean> queryPageByDoctorUserId(Page<JhsxReferralBean> page, String userId) {
        JhsxReferralBean bean = new JhsxReferralBean();
        return null;
    }

    public Page<JhsxReferralBean> queryPageByUserId(Page<JhsxReferralBean> page, String userId) {
        JhsxReferralBean bean = new JhsxReferralBean();
        return null;
    }

    public void selectedDoctor(String doctorUserId, String userId) {
        JhsxReferral JhsxReferral2 = new JhsxReferral();
        JhsxReferral2.setId(IdGen.vestaId());
        JhsxReferral2.setOrderNo(IdGen.vestaId());
        JhsxReferral2.setCreateBy(new User(userId));
        JhsxReferral2.setCreateDate(new Date());
        JhsxReferral2.setDelFlag("0");
        this.JhsxReferralMapper.insertSelective(JhsxReferral2);
    }

    public int doctorManageCount(String doctorUserId) {
        JhsxReferralExample query = new JhsxReferralExample();
        return 0;
    }

    public int update(JhsxReferral record) {
        return this.JhsxReferralMapper.updateByPrimaryKeySelective(record);
    }

    public void ManageOrderAdmission(Date date) {
        if (date == null) {
            date = new Date();
        }
        boolean haveNext = true;
        boolean pageNo = true;
        int pageSize = 200;
        JhsxReferral query = new JhsxReferral();
        while (haveNext) {
        }
    }

    public static int daysBetween(Date smdate, Date bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    private List<JhsxReferral> queryList(JhsxReferralExample example) {
        return this.JhsxReferralMapper.selectByExample(example);
    }
}

