/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.modules.haoyun.beans.KjBxVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.KjActivityDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.KjInvitationDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.KjActivity;
import com.cxqm.xiaoerke.modules.haoyun.entity.KjInvitation;
import com.cxqm.xiaoerke.modules.haoyun.enums.KjHuoDongEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.KjInvitationStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.example.KjInvitationExample;
import com.cxqm.xiaoerke.modules.haoyun.service.KjActivityService;
import com.cxqm.xiaoerke.modules.haoyun.service.KjInvitationService;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KjInvitationServiceImpl
implements KjInvitationService {
    boolean strictCheck = false;
    @Autowired
    KjInvitationDao kjInvitationDao;
    @Autowired
    KjActivityDao kjActivityDao;
    @Autowired
    KjActivityService kjActivityService;

    public void save(KjInvitation kjInvitation) {
        this.kjInvitationDao.insertSelective(kjInvitation);
    }

    public KjInvitation selectById(String kjActivityId, String userId) {
        KjInvitationExample kjInvitationExample = new KjInvitationExample();
        kjInvitationExample.createCriteria().andActivityIdEqualTo(kjActivityId).andUseridEqualTo(userId);
        kjInvitationExample.setOrderByClause(" create_date desc ");
        List<KjInvitation> kjInvitations = this.kjInvitationDao.selectByExample(kjInvitationExample);
        if (kjInvitations == null || kjInvitations.size() <= 0) {
            return null;
        }
        return kjInvitations.get(0);
    }

    public KjInvitation selectByInvitationId(String InvitationId) {
        return this.kjInvitationDao.selectByPrimaryKey(InvitationId);
    }

    public KjHuoDongEnum checkInvalid(KjInvitation kjInvitation) {
        KjActivity kjActivity;
        KjHuoDongEnum status;
        if (kjInvitation == null) {
            return KjHuoDongEnum.INVITATION_NULL;
        }
        if (kjInvitation.getStatus() != null && KjInvitationStatusEnum.START.getValue() != kjInvitation.getStatus()) {
            return KjHuoDongEnum.INVITATION_STATUS;
        }
        Long time = System.currentTimeMillis() - kjInvitation.getCreateDate().getTime();
        if (time != null) {
            time = time / 1000L;
        }
        if (time > kjInvitation.getTotalTime()) {
            return KjHuoDongEnum.INVITATION_TIMEOUT;
        }
        if (kjInvitation.getBargainCount() == kjInvitation.getTotalCount()) {
            return KjHuoDongEnum.INVITATION_FINISH;
        }
        if (this.strictCheck && (status = this.kjActivityService.checkInvalid(kjActivity = this.kjActivityDao.selectByPrimaryKey(kjInvitation.getActivityId()))) != KjHuoDongEnum.EFFECTIVE) {
            return status;
        }
        return KjHuoDongEnum.EFFECTIVE;
    }

    public void update(KjInvitation kjInvitation) {
        this.kjInvitationDao.updateByPrimaryKeySelective(kjInvitation);
    }

    public KjInvitation selectKjById(String kjActivityId, String userId) {
        KjInvitation kjInvitation = this.selectById(kjActivityId, userId);
        if (kjInvitation == null) {
            System.out.println("\u4e0b\u5355\u6ca1\u6709\u53d1\u8d77\u8fc7\u780d\u4ef7");
            return null;
        }
        KjBxVo kjs = this.kjInvitationDao.selectOrderIsNew(userId);
        if (kjs != null) {
            List<String> jiesu = Arrays.asList("31", "50", "60", "-20");
            if (jiesu.contains(kjs.getStatus())) {
                System.out.println("\u8ba2\u5355\u7ed3\u675f");
            } else if (!jiesu.contains(kjs.getStatus()) && kjInvitation.getStatus() == KjInvitationStatusEnum.END.getValue()) {
                if (kjs.getKjRefereeId() == null || kjs.getKjRefereeId().trim().length() <= 0) {
                    System.out.println("\u8ba2\u5355\u672a\u7ed3\u675f\uff0c\u672a\u53c2\u52a0\u780d\u4ef7");
                    return null;
                }
                System.out.println("\u8ba2\u5355\u672a\u7ed3\u675f\uff0c\u780d\u4ef7\u7ed3\u675f");
            } else if (!jiesu.contains(kjs.getStatus()) && kjInvitation.getStatus() == KjInvitationStatusEnum.START.getValue()) {
                System.out.println("\u8ba2\u5355\u672a\u7ed3\u675f\uff0c\u780d\u4ef7\u8fdb\u884c\u4e2d");
            } else if (!(jiesu.contains(kjs.getStatus()) || kjs.getKjRefereeId() != null && kjs.getKjRefereeId().trim().length() > 0)) {
                System.out.println("\u8ba2\u5355\u672a\u7ed3\u675f\uff0c\u672a\u53c2\u52a0\u780d\u4ef7");
                return null;
            }
        }
        return kjInvitation;
    }
}

