/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import com.cxqm.xiaoerke.common.utils.HttpRequestUtil;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.JsApiTicketUtil;
import com.cxqm.xiaoerke.common.utils.Sha1Util;
import com.cxqm.xiaoerke.common.utils.XMLUtil;
import com.cxqm.xiaoerke.modules.haoyun.entity.PayUrlRecordSmallProgram;
import com.cxqm.xiaoerke.modules.haoyun.service.PayService;
import com.cxqm.xiaoerke.modules.payinterface.service.PayUrlRecordSmallProgramInterfaceService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONObject;
import org.jdom.JDOMException;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements PayService {
    @Autowired
    MongoDictionaryService mongoDictionaryService;
    @Autowired
    PayUrlRecordSmallProgramInterfaceService payUrlRecordSmallProgramInterfaceService;

    public String getPrepayId(String openid, String IP, String body, String totalFee, String notifyUrl, String outTradeNo, String mongoKey) {
        PayUrlRecordSmallProgram payUrlRecordSmallProgram = new PayUrlRecordSmallProgram();
        payUrlRecordSmallProgram.setUrl(notifyUrl);
        payUrlRecordSmallProgram.setModule("sp");
        payUrlRecordSmallProgram.setOrderNo(outTradeNo);
        Map returnMap = this.payUrlRecordSmallProgramInterfaceService.queryOrInsertRecord(outTradeNo, notifyUrl);
        payUrlRecordSmallProgram = (PayUrlRecordSmallProgram)JSON.parseObject((String)returnMap.get("payUrlRecord").toString(), (TypeReference)new TypeReference<PayUrlRecordSmallProgram>(){}, (Feature[])new Feature[0]);
        MongoDictionary mongoDictionary = this.mongoDictionaryService.queryDictionary(mongoKey);
        String gateUrl = "https://api.mch.weixin.qq.com/pay/unifiedorder";
        String nonceStr = IdGen.uuid();
        if (payUrlRecordSmallProgram != null && payUrlRecordSmallProgram.getWxOrderNo() != null && !"".equals(payUrlRecordSmallProgram.getWxOrderNo() == null ? "" : payUrlRecordSmallProgram.getWxOrderNo().trim())) {
            return this.getPrepayId(IP, mongoDictionary.getStr1(), mongoDictionary.getStr3(), nonceStr, body, totalFee, notifyUrl, outTradeNo, openid, mongoDictionary.getStr4(), gateUrl, payUrlRecordSmallProgram.getId(), payUrlRecordSmallProgram.getWxOrderNo());
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("appid", mongoDictionary.getStr1());
        parameters.put("mch_id", mongoDictionary.getStr3());
        parameters.put("nonce_str", nonceStr);
        parameters.put("body", body);
        parameters.put("total_fee", totalFee);
        parameters.put("notify_url", "http://" + Global.getConfig((String)"baseUrl") + "/hy/mapi/pay/spPayRedirect.do");
        parameters.put("attach", payUrlRecordSmallProgram.getId());
        parameters.put("out_trade_no", outTradeNo);
        parameters.put("spbill_create_ip", IP);
        parameters.put("trade_type", "JSAPI");
        parameters.put("openid", openid);
        String sign = JsApiTicketUtil.createPublicTestSign((String)"UTF-8", parameters, (String)mongoDictionary.getStr4());
        parameters.put("sign", sign);
        String requestXML = JsApiTicketUtil.getRequestXml(parameters);
        String result = HttpRequestUtil.httpsRequest((String)gateUrl, (String)"POST", (String)requestXML);
        resultMap.put("result", result);
        resultMap.put("out_trade_no", outTradeNo);
        try {
            Map map = XMLUtil.doXMLParse((String)result);
            this.payUrlRecordSmallProgramInterfaceService.updateRecordOrderNo(payUrlRecordSmallProgram.getId(), (String)map.get("prepay_id"));
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.assemblyPublicHYPayParameter(resultMap, mongoDictionary.getStr1(), nonceStr, mongoDictionary.getStr4(), payUrlRecordSmallProgram.getId());
    }

    private String getPrepayId(String IP, String appid, String mch_id, String nonce_str, String body, String total_fee, String notify_url, String out_trade_no, String openid, String partnerKey, String gateurl, String payUrlRecordId, String prepay_id) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("appid", appid);
        parameters.put("mch_id", mch_id);
        parameters.put("nonce_str", nonce_str);
        parameters.put("body", body);
        parameters.put("total_fee", total_fee);
        parameters.put("notify_url", "http://" + Global.getConfig((String)"baseUrl") + "hy/mapi/pay/spPayRedirect.do");
        parameters.put("attach", payUrlRecordId);
        parameters.put("out_trade_no", out_trade_no);
        parameters.put("spbill_create_ip", IP);
        parameters.put("trade_type", "JSAPI");
        parameters.put("openid", openid);
        parameters.put("prepay_id", prepay_id);
        String sign = JsApiTicketUtil.createPublicTestSign((String)"UTF-8", parameters, (String)partnerKey);
        parameters.put("sign", sign);
        String requestXML = JsApiTicketUtil.getRequestXml(parameters);
        resultMap.put("result", requestXML);
        resultMap.put("out_trade_no", out_trade_no);
        return this.assemblyPublicHYPayParameter(resultMap, appid, nonce_str, partnerKey, payUrlRecordId);
    }

    private String assemblyPublicHYPayParameter(Map<String, String> PrepayInfo, String appid, String noncestr, String partnerKey, String payUrlRecordId) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        try {
            Map map = XMLUtil.doXMLParse((String)PrepayInfo.get("result"));
            if (map == null || "FAIL".equals(map.get("return_code"))) {
                LoggerFactory.getLogger(this.getClass()).error("\u5fae\u4fe1\u652f\u4ed8\u5931\u8d25\uff1a" + PrepayInfo.get("result"));
                return null;
            }
            params.put("appId", appid);
            params.put("timeStamp", Sha1Util.getTimeStamp());
            params.put("nonceStr", noncestr);
            params.put("package", "prepay_id=" + map.get("prepay_id"));
            params.put("signType", "md5");
            String paySign = JsApiTicketUtil.createPublicTestSign((String)"UTF-8", params, (String)partnerKey);
            params.put("paySign", paySign);
            params.put("payUrlRecordId", payUrlRecordId);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String json = JSONObject.fromObject(params).toString();
        return json;
    }
}

